/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class MacIntelliJComboBoxUI
extends BasicComboBoxUI {
    private static final Icon COMBOBOX = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/comboboxMac.png");
    private static final Icon COMBOBOX_LEFT = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/comboboxLeft.png");
    private static final Icon COMBOBOX_TOP_BOTTOM = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/comboboxTopBottom.png");
    private final JComboBox myComboBox;

    public MacIntelliJComboBoxUI(JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.currentValuePane = new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                c.setBackground(Color.WHITE);
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJComboBoxUI((JComboBox)c);
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.myComboBox.getBackground();
        Color fg = this.myComboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Icon icon = MacIntelliJComboBoxUI.this.myComboBox.isEnabled() ? COMBOBOX : IconLoader.getDisabledIcon((Icon)COMBOBOX);
                icon.paintIcon(this, g2, 0, 0);
            }

            @Override
            public Dimension getPreferredSize() {
                return JBUI.size((int)COMBOBOX.getIconWidth(), (int)COMBOBOX.getIconWidth());
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getSizeWithIcon(super.getMinimumSize(c));
    }

    private Dimension getSizeWithIcon(Dimension d) {
        return new Dimension(Math.max(d.width + 6, COMBOBOX.getIconWidth()), Math.max(d.height, COMBOBOX.getIconHeight()));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getSizeWithIcon(super.getPreferredSize(c));
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource comboBoxEditor = new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){
                    {
                        this.setOpaque(false);
                        this.setBorder(new Border(){

                            @Override
                            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                            }

                            @Override
                            public Insets getBorderInsets(Component c) {
                                return JBUI.insets((int)2, (int)6, (int)2, (int)6);
                            }

                            @Override
                            public boolean isBorderOpaque() {
                                return false;
                            }
                        });
                    }

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public void setBorder(Border b) {
                        super.setBorder(b);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        return new Dimension(size.width, COMBOBOX.getIconHeight() - 2);
                    }
                };
            }
        };
        if (comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        MacIntelliJComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            });
            comboBoxEditor.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                void update() {
                    if (MacIntelliJComboBoxUI.this.comboBox != null) {
                        MacIntelliJComboBoxUI.this.comboBox.revalidate();
                        MacIntelliJComboBoxUI.this.comboBox.repaint();
                    }
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = super.rectangleForCurrentValue();
        rect.height = Math.min(rect.height, COMBOBOX.getIconHeight());
        rect.y += 2;
        rect.x += 5;
        rect.height -= 4;
        return rect;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return null;
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return null;
            }

            @Override
            public void layoutContainer(Container parent) {
                int buttonHeight;
                JComboBox cb = (JComboBox)parent;
                int width = cb.getWidth();
                int height = cb.getHeight();
                Insets insets = MacIntelliJComboBoxUI.this.getInsets();
                int buttonWidth = buttonHeight = height - (insets.top + insets.bottom);
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    Insets arrowInsets = MacIntelliJComboBoxUI.this.arrowButton.getInsets();
                    buttonWidth = ((MacIntelliJComboBoxUI)MacIntelliJComboBoxUI.this).arrowButton.getPreferredSize().width + arrowInsets.left + arrowInsets.right;
                }
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    MacIntelliJComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                }
                if (MacIntelliJComboBoxUI.this.editor != null) {
                    Rectangle cvb = MacIntelliJComboBoxUI.this.rectangleForCurrentValue();
                    MacIntelliJComboBoxUI.this.editor.setBounds(cvb);
                }
            }
        };
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        g.setColor(Color.WHITE);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        super.paintCurrentValue(g, bounds, this.comboBox.isPopupVisible());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle r = this.arrowButton.getBounds();
        int stop = r.x;
        g.setClip(0, 0, stop, COMBOBOX.getIconHeight());
        COMBOBOX_LEFT.paintIcon(c, g, 0, r.y);
        for (int x = COMBOBOX_LEFT.getIconWidth(); x < stop; x += COMBOBOX_TOP_BOTTOM.getIconWidth()) {
            COMBOBOX_TOP_BOTTOM.paintIcon(c, g, x, r.y);
        }
        if (UIUtil.isRetina()) {
            ((Graphics2D)g).scale(0.5, 0.5);
            g.setColor(Color.WHITE);
            g.drawLine(COMBOBOX_LEFT.getIconWidth() * 2, 3, stop * 2, 3);
            g.drawLine(COMBOBOX_LEFT.getIconWidth() * 2, 40, stop * 2, 40);
            ((Graphics2D)g).scale(2.0, 2.0);
        }
    }
}

