/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.MultiStateElementsChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementsChooser<T>
extends MultiStateElementsChooser<T, Boolean> {
    private static final BooleanMarkStateDescriptor MARK_STATE_DESCRIPTOR = new BooleanMarkStateDescriptor();

    public ElementsChooser(boolean elementsCanBeMarked) {
        super(elementsCanBeMarked, ElementsChooser.<T>getMarkStateDescriptor());
    }

    public ElementsChooser(List<T> elements, boolean marked) {
        super(elements, marked, ElementsChooser.<T>getMarkStateDescriptor());
    }

    public void addElementsMarkListener(ElementsMarkListener<T> listener) {
        this.addElementsMarkListener(new ElementsMarkStateListenerAdapter<T>(listener));
    }

    public void removeElementsMarkListener(ElementsMarkListener<T> listener) {
        this.removeElementsMarkListener(new ElementsMarkStateListenerAdapter<T>(listener));
    }

    @Override
    public void addElement(T element, boolean isMarked) {
        this.addElement(element, ElementsChooser.getMarkState(isMarked));
    }

    public boolean isElementMarked(T element) {
        return (Boolean)this.getElementMarkState(element);
    }

    public void setElementMarked(T element, boolean marked) {
        this.setElementMarkState(element, ElementsChooser.getMarkState(marked));
    }

    @Override
    public void addElement(T element, boolean isMarked, MultiStateElementsChooser.ElementProperties elementProperties) {
        this.addElement(element, ElementsChooser.getMarkState(isMarked), elementProperties);
    }

    @Override
    public void setElements(List<T> elements, boolean marked) {
        this.setElements(elements, ElementsChooser.getMarkState(marked));
    }

    public void markElements(Collection<T> elements) {
        this.markElements(elements, Boolean.TRUE);
    }

    @NotNull
    public List<T> getMarkedElements() {
        Map elementMarkStates = this.getElementMarkStates();
        ArrayList elements = new ArrayList();
        for (Map.Entry entry : elementMarkStates.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            elements.add(entry.getKey());
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser", "getMarkedElements"));
        }
        return arrayList;
    }

    public void invertSelection() {
        int count = this.getElementCount();
        for (int i = 0; i < count; ++i) {
            Object type;
            this.setElementMarked(type, !this.isElementMarked(type = this.getElementAt(i)));
        }
    }

    @Override
    public void setAllElementsMarked(boolean marked) {
        this.setAllElementsMarked(ElementsChooser.getMarkState(marked));
    }

    private static Boolean getMarkState(boolean marked) {
        return marked;
    }

    private static <T> MultiStateElementsChooser.MarkStateDescriptor<T, Boolean> getMarkStateDescriptor() {
        return MARK_STATE_DESCRIPTOR;
    }

    private static class ElementsMarkStateListenerAdapter<T>
    implements MultiStateElementsChooser.ElementsMarkStateListener<T, Boolean> {
        private final ElementsMarkListener<T> myListener;

        public ElementsMarkStateListenerAdapter(ElementsMarkListener<T> listener) {
            this.myListener = listener;
        }

        @Override
        public void elementMarkChanged(T element, Boolean markState) {
            this.myListener.elementMarkChanged(element, markState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsMarkStateListenerAdapter that = (ElementsMarkStateListenerAdapter)o;
            return this.myListener.equals(that.myListener);
        }

        public int hashCode() {
            return this.myListener.hashCode();
        }
    }

    private static class BooleanMarkStateDescriptor<T>
    implements MultiStateElementsChooser.MarkStateDescriptor<T, Boolean> {
        private BooleanMarkStateDescriptor() {
        }

        @Override
        @NotNull
        public Boolean getDefaultState(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "getDefaultState"));
            }
            Boolean bl = Boolean.FALSE;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "getDefaultState"));
            }
            return bl;
        }

        @Override
        @NotNull
        public Boolean getNextState(@NotNull T element, @NotNull Boolean state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "getNextState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "getNextState"));
            }
            Boolean bl = state == false;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "getNextState"));
            }
            return bl;
        }

        @Override
        @Nullable
        public Boolean getNextState(@NotNull Map<T, Boolean> elementsWithStates) {
            Boolean state;
            if (elementsWithStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsWithStates", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "getNextState"));
            }
            boolean currentlyMarked = true;
            Iterator<Boolean> iterator = elementsWithStates.values().iterator();
            while (iterator.hasNext() && (currentlyMarked = (state = iterator.next()).booleanValue())) {
            }
            return !currentlyMarked;
        }

        @Override
        public boolean isMarked(@NotNull Boolean state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor", "isMarked"));
            }
            return state;
        }

        @Override
        @Nullable
        public Boolean getMarkState(@Nullable Object value) {
            return value instanceof Boolean ? (Boolean)value : null;
        }

        @Override
        @Nullable
        public TableCellRenderer getMarkRenderer() {
            return null;
        }
    }

    public static interface ElementsMarkListener<T> {
        public void elementMarkChanged(T var1, boolean var2);
    }
}

