/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeRepaintManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.CommandLineApplication;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.ui.Splash;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.MessageBus;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaApplication {
    @NonNls
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";
    @NonNls
    public static final String IDEA_IS_UNIT_TEST = "idea.is.unit.test";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.IdeaApplication");
    private static IdeaApplication ourInstance;
    private final String[] myArgs;
    private boolean myPerformProjectLoad = true;
    private ApplicationStarter myStarter;
    private volatile boolean myLoaded = false;

    public static IdeaApplication getInstance() {
        return ourInstance;
    }

    public static boolean isLoaded() {
        return ourInstance != null && IdeaApplication.ourInstance.myLoaded;
    }

    public IdeaApplication(String[] args) {
        LOG.assertTrue(ourInstance == null);
        ourInstance = this;
        this.myArgs = args;
        boolean isInternal = Boolean.getBoolean(IDEA_IS_INTERNAL_PROPERTY);
        boolean isUnitTest = Boolean.getBoolean(IDEA_IS_UNIT_TEST);
        boolean headless = Main.isHeadless();
        IdeaApplication.patchSystem(headless);
        if (Main.isCommandLine()) {
            if (CommandLineApplication.ourInstance == null) {
                new CommandLineApplication(isInternal, isUnitTest, headless);
            }
            if (isUnitTest) {
                this.myLoaded = true;
            }
        } else {
            Splash splash = null;
            if (this.myArgs.length == 0) {
                this.myStarter = this.getStarter();
                if (this.myStarter instanceof IdeStarter) {
                    splash = ((IdeStarter)this.myStarter).showSplash(this.myArgs);
                }
            }
            ApplicationManagerEx.createApplication(isInternal, isUnitTest, false, false, "idea", splash);
        }
        if (this.myStarter == null) {
            this.myStarter = this.getStarter();
        }
        if (headless && this.myStarter instanceof ApplicationStarterEx && !((ApplicationStarterEx)this.myStarter).isHeadless()) {
            Main.showMessage((String)"Startup Error", (String)"Application cannot start in headless mode", (boolean)true);
            System.exit(1);
        }
        this.myStarter.premain(args);
    }

    private static void patchSystem(boolean headless) {
        System.setProperty("sun.awt.noerasebackground", "true");
        IdeEventQueue.getInstance();
        if (headless) {
            return;
        }
        RepaintManager.setCurrentManager(new IdeRepaintManager());
        if (SystemInfo.isXWindow) {
            String wmName = X11UiUtil.getWmName();
            LOG.info("WM detected: " + wmName);
            if (wmName != null) {
                X11UiUtil.patchDetectedWm(wmName);
            }
        }
        IconLoader.activate();
        new JFrame().pack();
    }

    @NotNull
    public ApplicationStarter getStarter() {
        if (this.myArgs.length > 0) {
            PluginManagerCore.getPlugins();
            ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.appStarter");
            ApplicationStarter[] starters = (ApplicationStarter[])point.getExtensions();
            String key = this.myArgs[0];
            for (ApplicationStarter o : starters) {
                if (!Comparing.equal((String)o.getCommandName(), (String)key)) continue;
                ApplicationStarter applicationStarter = o;
                if (applicationStarter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/IdeaApplication", "getStarter"));
                }
                return applicationStarter;
            }
        }
        IdeStarter ideStarter = new IdeStarter();
        if (ideStarter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/IdeaApplication", "getStarter"));
        }
        return ideStarter;
    }

    public void run() {
        try {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            app.load(PathManager.getOptionsPath());
            this.myLoaded = true;
            this.myStarter.main(this.myArgs);
            this.myStarter = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initLAF() {
        try {
            Class.forName("com.jgoodies.looks.plastic.PlasticLookAndFeel");
            if (SystemInfo.isWindows) {
                UIManager.installLookAndFeel("JGoodies Windows L&F", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            }
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private Project loadProjectFromExternalCommandLine() {
        Project project = null;
        if (this.myArgs != null && this.myArgs.length > 0 && this.myArgs[0] != null) {
            LOG.info("IdeaApplication.loadProject");
            project = CommandLineProcessor.processExternalCommandLine(Arrays.asList(this.myArgs), null);
        }
        return project;
    }

    public String[] getCommandLineArguments() {
        return this.myArgs;
    }

    public void setPerformProjectLoad(boolean performProjectLoad) {
        this.myPerformProjectLoad = performProjectLoad;
    }

    protected class IdeStarter
    extends ApplicationStarterEx {
        private Splash mySplash;

        protected IdeStarter() {
        }

        public boolean isHeadless() {
            return false;
        }

        public String getCommandName() {
            return null;
        }

        public void premain(String[] args) {
            IdeaApplication.initLAF();
        }

        @Nullable
        private Splash showSplash(String[] args) {
            if (StartupUtil.shouldShowSplash(args)) {
                ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
                SplashScreen splashScreen = this.getSplashScreen();
                if (splashScreen == null) {
                    this.mySplash = new Splash(appInfo);
                    this.mySplash.show();
                    return this.mySplash;
                }
                this.updateSplashScreen(appInfo, splashScreen);
            }
            return null;
        }

        private void updateSplashScreen(ApplicationInfoEx appInfo, SplashScreen splashScreen) {
            Graphics2D graphics = splashScreen.createGraphics();
            Dimension size = splashScreen.getSize();
            if (Splash.showLicenseeInfo(graphics, 0, 0, size.height, appInfo.getSplashTextColor())) {
                splashScreen.update();
            }
        }

        @Nullable
        private SplashScreen getSplashScreen() {
            try {
                return SplashScreen.getSplashScreen();
            }
            catch (Throwable t) {
                LOG.warn(t);
                return null;
            }
        }

        public boolean canProcessExternalCommandLine() {
            return true;
        }

        public void processExternalCommandLine(String[] args, @Nullable String currentDirectory) {
            LOG.info("Request to open in " + currentDirectory + " with parameters: " + StringUtil.join((String[])args, (String)","));
            if (args.length > 0) {
                VirtualFile virtualFile;
                String filename = args[0];
                File file = new File(currentDirectory, filename);
                if (file.exists() && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)) != null) {
                    int line = -1;
                    if (args.length > 2 && "--line".equals(args[1])) {
                        try {
                            line = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException ex) {
                            LOG.error("Wrong line number:" + args[2]);
                        }
                    }
                    PlatformProjectOpenProcessor.doOpenProject(virtualFile, null, false, line, null, false);
                }
                throw new IncorrectOperationException("Can't find file:" + file);
            }
        }

        public void main(String[] args) {
            SystemDock.updateMenu();
            final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
            IdeEventQueue.getInstance().setWindowManager(windowManager);
            Ref willOpenProject = new Ref((Object)Boolean.FALSE);
            AppLifecycleListener lifecyclePublisher = (AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecyclePublisher.appFrameCreated(args, (Ref<Boolean>)willOpenProject);
            LOG.info("App initialization took " + (System.nanoTime() - PluginManager.startupStart) / 1000000L + " ms");
            PluginManagerCore.dumpPluginClassStatistics();
            if (!((Boolean)willOpenProject.get()).booleanValue()) {
                WelcomeFrame.showNow();
                lifecyclePublisher.welcomeScreenDisplayed();
            } else {
                windowManager.showFrame();
            }
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (IdeStarter.this.mySplash != null) {
                        IdeStarter.this.mySplash.dispose();
                        IdeStarter.this.mySplash = null;
                    }
                }
            }, ModalityState.NON_MODAL);
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Project projectFromCommandLine = null;
                    if (IdeaApplication.this.myPerformProjectLoad) {
                        projectFromCommandLine = IdeaApplication.this.loadProjectFromExternalCommandLine();
                    }
                    MessageBus bus = ApplicationManager.getApplication().getMessageBus();
                    ((AppLifecycleListener)bus.syncPublisher(AppLifecycleListener.TOPIC)).appStarting(projectFromCommandLine);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginManager.reportPluginError();
                        }
                    });
                    UsageTrigger.trigger(app.getName() + "app.started");
                }
            }, ModalityState.NON_MODAL);
        }
    }
}

