/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsDataSender;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistenceComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemotelyConfigurableStatisticsService
implements StatisticsService {
    private StatisticsConnectionService myConnectionService;
    private StatisticsDataSender sender;
    private StatisticsUploadAssistant myAssistant;

    public RemotelyConfigurableStatisticsService(@NotNull StatisticsConnectionService connectionService, @NotNull StatisticsDataSender sender, @NotNull StatisticsUploadAssistant assistant) {
        if (connectionService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionService", "com/intellij/internal/statistic/connect/RemotelyConfigurableStatisticsService", "<init>"));
        }
        if (sender == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/intellij/internal/statistic/connect/RemotelyConfigurableStatisticsService", "<init>"));
        }
        if (assistant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assistant", "com/intellij/internal/statistic/connect/RemotelyConfigurableStatisticsService", "<init>"));
        }
        this.myConnectionService = connectionService;
        this.sender = sender;
        this.myAssistant = assistant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatisticsResult send() {
        Class<ApplicationStatisticsPersistenceComponent> clazz = ApplicationStatisticsPersistenceComponent.class;
        synchronized (ApplicationStatisticsPersistenceComponent.class) {
            String serviceUrl = this.myConnectionService.getServiceUrl();
            if (serviceUrl == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR");
            }
            if (!this.myConnectionService.isTransmissionPermitted()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
            }
            String content = this.myAssistant.getData(this.myConnectionService.getDisabledGroups());
            if (StringUtil.isEmptyOrSpaces((String)content)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "NOTHING_TO_SEND");
            }
            try {
                this.sender.send(serviceUrl, content);
                StatisticsUploadAssistant.updateSentTime();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StatisticsResult(StatisticsResult.ResultCode.SEND, content);
            }
            catch (Exception e) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, e.getMessage() != null ? e.getMessage() : "NPE");
            }
        }
    }

    @Override
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/internal/statistic/connect/RemotelyConfigurableStatisticsService", "createNotification"));
        }
        String fullProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        String companyName = ApplicationInfo.getInstance().getCompanyName();
        String text = "<html>Please click <a href='allow'>I agree</a> if you want to help make " + fullProductName + " better or <a href='decline'>I don't agree</a> otherwise. <a href='settings'>more...</a></html>";
        String title = "Help improve " + fullProductName + " by sending anonymous usage statistics to " + companyName;
        return new Notification(groupDisplayId, title, text, NotificationType.INFORMATION, listener);
    }

    @Override
    @Nullable
    public Map<String, String> getStatisticsConfigurationLabels() {
        return null;
    }
}

