/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.WindowsCommandLineListener;
import com.intellij.ide.WindowsCommandLineProcessor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.ApplicationPathMacroManager;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.components.impl.stores.StoresFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiLock;
import com.intellij.ui.Splash;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.picocontainer.MutablePicoContainer;

public class ApplicationImpl
extends PlatformComponentManagerImpl
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.impl.ApplicationImpl");
    private final ModalityState MODALITY_STATE_NONE;
    private final ReentrantReadWriteLock myLock;
    private final ModalityInvokator myInvokator;
    private final EventDispatcher<ApplicationListener> myDispatcher;
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final String myName;
    private final Stack<Class> myWriteActionsStack;
    private int myInEditorPaintCounter;
    private final long myStartTime;
    @Nullable
    private final Splash mySplash;
    private boolean myDoNotSave;
    private volatile boolean myDisposeInProgress;
    private final Disposable myLastDisposable;
    private final AtomicBoolean mySaveSettingsIsInProgress;
    private static final int ourDumpThreadsOnLongWriteActionWaiting = Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);
    private final ExecutorService ourThreadExecutorsService;
    private boolean myLoaded;
    @NonNls
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private Boolean myActive;
    private static final int IS_EDT_FLAG = 0x40000000;
    private static final int IS_READ_LOCK_ACQUIRED_FLAG = 0x20000000;
    private static final ThreadLocal<Status> status = new ThreadLocal<Status>(){

        @Override
        protected Status initialValue() {
            Status status = new Status();
            status.flags = BitUtil.set((int)status.flags, (int)0x40000000, (boolean)EventQueue.isDispatchThread());
            return status;
        }
    };
    private static final ModalityState ANY = new ModalityState(){

        public boolean dominates(@NotNull ModalityState anotherState) {
            if (anotherState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherState", "com/intellij/openapi/application/impl/ApplicationImpl$2", "dominates"));
            }
            return false;
        }

        @NonNls
        public String toString() {
            return "ANY";
        }
    };
    private static volatile boolean exiting;
    private volatile boolean myWriteActionPending;
    private final boolean myExtraChecks;

    private static Status getStatus() {
        return status.get();
    }

    private static void setReadLockAcquired(Status status, boolean acquired) {
        status.flags = BitUtil.set((int)status.flags, (int)0x20000000, (boolean)acquired);
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/application/impl/ApplicationImpl", "bootstrapPicoContainer"));
        }
        super.bootstrapPicoContainer(name);
        this.getPicoContainer().registerComponentImplementation(IComponentStore.class, StoresFactory.getApplicationStoreClass());
        this.getPicoContainer().registerComponentImplementation(ApplicationPathMacroManager.class);
    }

    @NotNull
    public IApplicationStore getStateStore() {
        IApplicationStore iApplicationStore = (IApplicationStore)this.getPicoContainer().getComponentInstance(IComponentStore.class);
        if (iApplicationStore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getStateStore"));
        }
        return iApplicationStore;
    }

    @Override
    public void initializeComponent(@NotNull Object component, boolean service) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/application/impl/ApplicationImpl", "initializeComponent"));
        }
        this.getStateStore().initComponent(component, service);
    }

    @Override
    public void init() {
        this.loadComponents();
        for (ApplicationLoadListener listener : (ApplicationLoadListener[])ApplicationLoadListener.EP_NAME.getExtensions()) {
            try {
                listener.beforeApplicationLoaded(this);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        super.init();
    }

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine, @NotNull String appName, @Nullable Splash splash) {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appName", "com/intellij/openapi/application/impl/ApplicationImpl", "<init>"));
        }
        super(null);
        this.MODALITY_STATE_NONE = ModalityState.NON_MODAL;
        this.myLock = new ReentrantReadWriteLock(false);
        this.myInvokator = new ModalityInvokatorImpl();
        this.myDispatcher = EventDispatcher.create(ApplicationListener.class);
        this.myWriteActionsStack = new Stack();
        this.myLastDisposable = Disposer.newDisposable();
        this.mySaveSettingsIsInProgress = new AtomicBoolean(false);
        this.ourThreadExecutorsService = PooledThreadExecutor.INSTANCE;
        this.myExtraChecks = this.isUnitTestMode();
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
        this.getPicoContainer().registerComponentInstance(Application.class, (Object)this);
        IconLoader.STRICT = isUnitTestMode || isInternal;
        BundleBase.assertKeyIsFound = IconLoader.STRICT;
        AWTExceptionHandler.register();
        String debugDisposer = System.getProperty("idea.disposer.debug");
        Disposer.setDebugMode(((isInternal || isUnitTestMode || "on".equals(debugDisposer)) && !"off".equals(debugDisposer) ? 1 : 0) != 0);
        this.myStartTime = System.currentTimeMillis();
        this.mySplash = splash;
        this.myName = appName;
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        boolean bl = this.myDoNotSave = isUnitTestMode || isHeadless;
        if (this.myTestModeFlag) {
            this.registerShutdownHook();
        }
        if (!isUnitTestMode && !isHeadless) {
            Disposer.register((Disposable)this, (Disposable)Disposer.newDisposable(), (String)"ui");
            StartupUtil.addExternalInstanceListener(new Consumer<List<String>>(){

                public void consume(final List<String> args) {
                    ApplicationImpl.this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JFrame frame;
                            LOG.info("ApplicationImpl.externalInstanceListener invocation");
                            String currentDirectory = args.isEmpty() ? null : (String)args.get(0);
                            List realArgs = args.isEmpty() ? args : args.subList(1, args.size());
                            Project project = CommandLineProcessor.processExternalCommandLine(realArgs, currentDirectory);
                            JFrame jFrame = frame = project == null ? WindowManager.getInstance().findVisibleFrame() : (JFrame)WindowManager.getInstance().getIdeFrame(project);
                            if (frame != null) {
                                frame.requestFocus();
                            }
                        }
                    });
                }
            });
            WindowsCommandLineProcessor.LISTENER = new WindowsCommandLineListener(){

                public void processWindowsLauncherCommandLine(final String currentDirectory, final String commandLine) {
                    LOG.info("Received external Windows command line: current directory " + currentDirectory + ", command line " + commandLine);
                    ApplicationImpl.this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List args = StringUtil.splitHonorQuotes((String)commandLine, (char)' ');
                            args.remove(0);
                            CommandLineProcessor.processExternalCommandLine(args, currentDirectory);
                        }
                    });
                }
            };
        }
        if (isUnitTestMode && IdeaApplication.getInstance() == null) {
            String[] args = new String[]{"inspect", "", "", ""};
            Main.setFlags((String[])args);
            System.setProperty("idea.is.unit.test", Boolean.TRUE.toString());
            assert (Main.isHeadless());
            assert (Main.isCommandLine());
            new IdeaApplication(args);
        }
    }

    private void registerShutdownHook() {
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (ApplicationImpl.this.isDisposed() || ApplicationImpl.this.myDisposeInProgress) {
                    return;
                }
                ShutDownTracker.invokeAndWait((boolean)ApplicationImpl.this.isUnitTestMode(), (boolean)true, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationManager.getApplication() != ApplicationImpl.this) {
                            return;
                        }
                        try {
                            ApplicationImpl.this.myDisposeInProgress = true;
                            ApplicationImpl.this.saveAll();
                        }
                        finally {
                            if (!ApplicationImpl.this.disposeSelf(true)) {
                                ApplicationImpl.this.myDisposeInProgress = false;
                            }
                        }
                    }
                });
            }
        });
    }

    private boolean disposeSelf(final boolean checkCanCloseProject) {
        final ProjectManagerImpl manager = (ProjectManagerImpl)ProjectManagerEx.getInstanceEx();
        if (manager != null) {
            final boolean[] canClose = new boolean[]{true};
            for (final Project project : manager.getOpenProjects()) {
                try {
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            if (!manager.closeProject(project, true, true, checkCanCloseProject)) {
                                canClose[0] = false;
                            }
                        }
                    }, ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]), null);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                if (canClose[0]) continue;
                return false;
            }
        }
        this.runWriteAction(new Runnable(){

            @Override
            public void run() {
                Disposer.dispose((Disposable)ApplicationImpl.this);
            }
        });
        Disposer.assertIsEmpty();
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getName"));
        }
        return string;
    }

    @Override
    public boolean holdsReadLock() {
        return ApplicationImpl.holdsReadLock(ApplicationImpl.getStatus());
    }

    private static boolean holdsReadLock(Status status) {
        return BitUtil.isSet((int)status.flags, (int)0x20000000);
    }

    @Override
    protected synchronized Object createComponent(@NotNull Class componentInterface) {
        if (componentInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInterface", "com/intellij/openapi/application/impl/ApplicationImpl", "createComponent"));
        }
        Object component = super.createComponent(componentInterface);
        if (this.mySplash != null) {
            this.mySplash.showProgress("", 0.65f + this.getPercentageOfComponentsLoaded() * 0.35f);
        }
        return component;
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        AreaPicoContainer areaPicoContainer = Extensions.getRootArea().getPicoContainer();
        if (areaPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "createPicoContainer"));
        }
        return areaPicoContainer;
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        Future<?> future = this.ourThreadExecutorsService.submit(new Runnable(){

            @Override
            public void run() {
                assert (!ApplicationImpl.this.isReadAccessAllowed()) : ApplicationImpl.access$500(Thread.currentThread());
                try {
                    action.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                    Thread.interrupted();
                    assert (!ApplicationImpl.this.isReadAccessAllowed()) : ApplicationImpl.access$500(Thread.currentThread());
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    Thread.interrupted();
                    assert (!ApplicationImpl.this.isReadAccessAllowed()) : ApplicationImpl.access$500(Thread.currentThread());
                }
            }
        });
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        return future;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        Future future = this.ourThreadExecutorsService.submit(new Callable<T>(){

            @Override
            public T call() {
                assert (!ApplicationImpl.this.isReadAccessAllowed()) : ApplicationImpl.access$500(Thread.currentThread());
                try {
                    Object v = action.call();
                    return v;
                }
                catch (ProcessCanceledException processCanceledException) {
                    Thread.interrupted();
                    assert (!ApplicationImpl.this.isReadAccessAllowed()) : ApplicationImpl.access$500(Thread.currentThread());
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    Thread.interrupted();
                    assert (!ApplicationImpl.this.isReadAccessAllowed()) : ApplicationImpl.access$500(Thread.currentThread());
                }
                return null;
            }
        });
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        return future;
    }

    public boolean isDispatchThread() {
        return ApplicationImpl.isDispatchThread(ApplicationImpl.getStatus());
    }

    private static boolean isDispatchThread(Status status) {
        return BitUtil.isSet((int)status.flags, (int)0x40000000);
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getInvokator"));
        }
        return modalityInvokator;
    }

    public void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable);
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable, expired);
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable, state);
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(runnable, state, expired);
    }

    @Override
    public void load(@Nullable String optionsPath) throws IOException {
        this.load(PathManager.getConfigPath(), optionsPath == null ? PathManager.getOptionsPath() : optionsPath);
    }

    public void load(@NotNull String configPath, @NotNull String optionsPath) throws IOException {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/openapi/application/impl/ApplicationImpl", "load"));
        }
        if (optionsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsPath", "com/intellij/openapi/application/impl/ApplicationImpl", "load"));
        }
        IApplicationStore store = this.getStateStore();
        store.setOptionsPath(optionsPath);
        store.setConfigPath(configPath);
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Loading application components");
        try {
            store.load();
        }
        catch (StateStorageException e) {
            throw new IOException(e);
        }
        finally {
            token.finish();
        }
        this.myLoaded = true;
        ApplicationImpl.createLocatorFile();
    }

    private static void createLocatorFile() {
        File locatorFile = new File(PathManager.getSystemPath() + "/" + ".home");
        try {
            byte[] data = PathManager.getHomePath().getBytes(CharsetToolkit.UTF8_CHARSET);
            FileUtil.writeToFile((File)locatorFile, (byte[])data);
        }
        catch (IOException e) {
            LOG.warn("can't store a location in '" + locatorFile + "'", (Throwable)e);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.myLoaded;
    }

    @Override
    public void dispose() {
        this.fireApplicationExiting();
        ShutDownTracker.getInstance().ensureStopperThreadsFinished();
        this.disposeComponents();
        this.ourThreadExecutorsService.shutdownNow();
        super.dispose();
        Disposer.dispose((Disposable)this.myLastDisposable);
    }

    @Override
    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/openapi/application/impl/ApplicationImpl", "getMyComponentConfigsFromDescriptor"));
        }
        ComponentConfig[] componentConfigArray = plugin.getAppComponents();
        if (componentConfigArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getMyComponentConfigsFromDescriptor"));
        }
        return componentConfigArray;
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, Project project) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, parentComponent, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent, String cancelText) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        this.assertIsDispatchThread();
        boolean writeAccessAllowed = this.isInsideWriteActionEDTOnly();
        if (writeAccessAllowed || this.isHeadlessEnvironment() && !this.isUnitTestMode()) {
            LOG.debug("Starting process with progress from within write action makes no sense");
            try {
                ProgressManager.getInstance().runProcess(process, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            return true;
        }
        final ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        final AtomicBoolean threadStarted = new AtomicBoolean();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationImpl.this.executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progress);
                        }
                        catch (ProcessCanceledException e) {
                            progress.cancel();
                        }
                        catch (RuntimeException e) {
                            progress.cancel();
                            throw e;
                        }
                    }
                });
                threadStarted.set(true);
            }
        });
        progress.startBlocking();
        LOG.assertTrue(threadStarted.get());
        LOG.assertTrue(!progress.isRunning());
        return !progress.isCanceled();
    }

    @Override
    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project project, @NotNull String progressTitle, boolean canBeCanceled, String cancelText, JComponent parentComponent, final @NotNull Runnable process) {
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronouslyInReadAction"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronouslyInReadAction"));
        }
        this.assertIsDispatchThread();
        boolean writeAccessAllowed = this.isInsideWriteActionEDTOnly();
        if (writeAccessAllowed) {
            throw new IncorrectOperationException("Starting process with progress from within write action makes no sense");
        }
        final ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        final Semaphore readActionAcquired = new Semaphore();
        readActionAcquired.down();
        final Semaphore modalityEntered = new Semaphore();
        modalityEntered.down();
        this.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            readActionAcquired.up();
                            modalityEntered.waitFor();
                            ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progress);
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    progress.cancel();
                }
                catch (RuntimeException e) {
                    progress.cancel();
                    throw e;
                }
            }
        });
        readActionAcquired.waitFor();
        progress.startBlocking(new Runnable(){

            @Override
            public void run() {
                modalityEntered.up();
            }
        });
        LOG.assertTrue(!progress.isRunning());
        return !progress.isCanceled();
    }

    public void invokeAndWait(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        Status status = ApplicationImpl.getStatus();
        if (ApplicationImpl.isDispatchThread(status)) {
            runnable.run();
            return;
        }
        if (this.holdsReadLock()) {
            LOG.error("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        LaterInvocator.invokeAndWait(runnable, modalityState);
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        Object[] entities = LaterInvocator.getCurrentModalEntities();
        ModalityStateEx modalityStateEx = entities.length > 0 ? new ModalityStateEx(entities) : this.getNoneModalityState();
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getCurrentModalityState"));
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
        }
        Window window = UIUtil.getWindow((Component)c);
        if (window == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow(window);
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        ModalityState modalityState = ANY;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getAnyModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        if (this.isDispatchThread()) {
            ModalityState modalityState = this.getCurrentModalityState();
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getDefaultModalityState"));
            }
            return modalityState;
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        ModalityState modalityState = progress == null ? this.getNoneModalityState() : progress.getModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getDefaultModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = this.MODALITY_STATE_NONE;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getNoneModalityState"));
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        this.assertIsDispatchThread();
        return IdeEventQueue.getInstance().getIdleTime();
    }

    public void exit() {
        this.exit(false, false);
    }

    @Override
    public void exit(boolean force, boolean exitConfirmed) {
        this.exit(false, exitConfirmed, true, false);
    }

    public void restart() {
        this.restart(false);
    }

    @Override
    public void restart(boolean exitConfirmed) {
        this.exit(false, exitConfirmed, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(final boolean force, final boolean exitConfirmed, final boolean allowListenersToCancel, final boolean restart) {
        if (!force && exiting) {
            return;
        }
        exiting = true;
        try {
            if (!force && !exitConfirmed && this.getDefaultModalityState() != ModalityState.NON_MODAL) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!force && !ApplicationImpl.confirmExitIfNeeded(exitConfirmed)) {
                        ApplicationImpl.this.saveAll();
                        return;
                    }
                    ((AppLifecycleListener)ApplicationImpl.this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).appClosing();
                    ApplicationImpl.this.myDisposeInProgress = true;
                    ApplicationImpl.this.doExit(allowListenersToCancel, restart);
                    ApplicationImpl.this.myDisposeInProgress = false;
                }
            };
            if (this.isDispatchThread()) {
                runnable.run();
            } else {
                this.invokeLater(runnable, ModalityState.NON_MODAL);
            }
        }
        finally {
            exiting = false;
        }
    }

    private boolean doExit(boolean allowListenersToCancel, boolean restart) {
        this.saveSettings();
        if (allowListenersToCancel && !this.canExit()) {
            return false;
        }
        boolean success = this.disposeSelf(allowListenersToCancel);
        if (!success || this.isUnitTestMode()) {
            return false;
        }
        int exitCode = 0;
        if (restart && Restarter.isSupported()) {
            try {
                exitCode = Restarter.scheduleRestart((String[])new String[0]);
            }
            catch (IOException e) {
                LOG.warn("Cannot restart", (Throwable)e);
            }
        }
        System.exit(exitCode);
        return true;
    }

    private static boolean confirmExitIfNeeded(boolean exitConfirmed) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (exitConfirmed && !hasUnsafeBgTasks) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value, int exitCode) {
                GeneralSettings.getInstance().setConfirmExit(value);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                if ("Do not ask me again" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$14", "getDoNotShowMessage"));
                }
                return "Do not ask me again";
            }
        };
        if (hasUnsafeBgTasks || option.isToBeShown()) {
            String message = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(option)).show() != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = (ProjectManagerEx)ProjectManager.getInstance();
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project)) continue;
            return false;
        }
        return true;
    }

    public void runReadAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        Status status = ApplicationImpl.getStatus();
        if (ApplicationImpl.isReadAccessAllowed(status)) {
            action.run();
        } else {
            this.startRead(status);
            try {
                action.run();
            }
            finally {
                this.endRead(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        Status status = ApplicationImpl.getStatus();
        if (ApplicationImpl.isReadAccessAllowed(status)) {
            return (T)computation.compute();
        }
        this.startRead(status);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endRead(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        Status status = ApplicationImpl.getStatus();
        if (ApplicationImpl.isReadAccessAllowed(status)) {
            return (T)computation.compute();
        }
        this.startRead(status);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endRead(status);
        }
    }

    private void startRead(Status status) {
        this.assertNoPsiLock();
        try {
            this.myLock.readLock().lockInterruptibly();
            ApplicationImpl.setReadLockAcquired(status, true);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    private void endRead(Status status) {
        ApplicationImpl.setReadLockAcquired(status, false);
        this.myLock.readLock().unlock();
    }

    public void runWriteAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        Class<?> clazz = action.getClass();
        this.startWrite(clazz);
        try {
            action.run();
        }
        finally {
            this.endWrite(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        Class<?> clazz = computation.getClass();
        this.startWrite(clazz);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        Class<?> clazz = computation.getClass();
        this.startWrite(clazz);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public boolean hasWriteAction(@Nullable Class<?> actionClass) {
        this.assertIsDispatchThread();
        for (int i = this.myWriteActionsStack.size() - 1; i >= 0; --i) {
            Class action = (Class)this.myWriteActionsStack.get(i);
            if (actionClass != action && (action == null || actionClass == null || !ReflectionUtil.isAssignable(actionClass, (Class)action))) continue;
            return true;
        }
        return false;
    }

    public void assertReadAccessAllowed() {
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from event dispatch thread or inside read-action only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "; dispatch thread: " + EventQueue.isDispatchThread() + "; isDispatchThread(): " + this.isDispatchThread(), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    @NonNls
    private static String describe(Thread o) {
        if (o == null) {
            return "null";
        }
        return o + " " + System.identityHashCode(o);
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, (String)"getDispatchThread", (Class[])new Class[0]);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReadAccessAllowed() {
        return ApplicationImpl.isReadAccessAllowed(ApplicationImpl.getStatus());
    }

    private static boolean isReadAccessAllowed(Status status) {
        return (status.flags & 0x60000000) != 0;
    }

    public void assertIsDispatchThread() {
        ApplicationImpl.assertIsDispatchThread(ApplicationImpl.getStatus());
    }

    private static void assertIsDispatchThread(Status status) {
        if (ApplicationImpl.isDispatchThread(status)) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        int safeCounter = ApplicationImpl.getSafeCounter(status);
        if (safeCounter == 0) {
            ApplicationImpl.assertIsDispatchThread(status, "Access is allowed from event dispatch thread only.");
        }
    }

    private static int getSafeCounter(Status status) {
        return status.flags & 0x1FFFFFFF;
    }

    private static void assertIsDispatchThread(Status status, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/application/impl/ApplicationImpl", "assertIsDispatchThread"));
        }
        if (ApplicationImpl.isDispatchThread(status)) {
            return;
        }
        Attachment dump = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
        throw new LogEventException(message, " EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " isDispatchThread()=" + ApplicationImpl.isDispatchThread(ApplicationImpl.getStatus()) + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + " Current thread: " + ApplicationImpl.describe(Thread.currentThread()) + " SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread()), dump);
    }

    @Override
    public void runEdtSafeAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "runEdtSafeAction"));
        }
        Status status = ApplicationImpl.getStatus();
        LOG.assertTrue(ApplicationImpl.getSafeCounter(status) < 0x4000000);
        status.flags++;
        try {
            runnable.run();
        }
        finally {
            status.flags--;
        }
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component) {
        if (component == null) {
            return;
        }
        Status status = ApplicationImpl.getStatus();
        if (ApplicationImpl.isDispatchThread(status)) {
            return;
        }
        if (Boolean.TRUE.equals(component.getClientProperty(WAS_EVER_SHOWN))) {
            ApplicationImpl.assertIsDispatchThread(status);
        } else {
            JRootPane root = component.getRootPane();
            if (root != null) {
                component.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                ApplicationImpl.assertIsDispatchThread(status);
            }
        }
    }

    @Override
    public void assertTimeConsuming() {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        LOG.assertTrue(!this.isDispatchThread(), (Object)"This operation is time consuming and must not be called on EDT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRunReadAction(@NotNull Runnable action) {
        boolean mustAcquire;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "tryRunReadAction"));
        }
        Status status = ApplicationImpl.getStatus();
        boolean bl = mustAcquire = !ApplicationImpl.isReadAccessAllowed(status);
        if (mustAcquire) {
            this.assertNoPsiLock();
            try {
                if (!this.myLock.readLock().tryLock(0L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
                ApplicationImpl.setReadLockAcquired(status, true);
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
        try {
            action.run();
        }
        finally {
            if (mustAcquire) {
                this.endRead(status);
            }
        }
        return true;
    }

    public boolean tryToApplyActivationState(boolean active, Window window) {
        Component frame = UIUtil.findUltimateParent((Component)window);
        if (frame instanceof IdeFrame) {
            IdeFrame ideFrame = (IdeFrame)frame;
            if (this.isActive() != active) {
                this.myActive = active;
                System.setProperty("idea.active", this.myActive.toString());
                ApplicationActivationListener publisher = (ApplicationActivationListener)this.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC);
                if (active) {
                    publisher.applicationActivated(ideFrame);
                } else {
                    publisher.applicationDeactivated(ideFrame);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        if (this.isUnitTestMode()) {
            return true;
        }
        if (this.myActive == null) {
            Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            return active != null;
        }
        return this.myActive;
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        Status status = ApplicationImpl.getStatus();
        if (ApplicationImpl.isReadAccessAllowed(status)) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireReadActionLock"));
            }
            return accessToken;
        }
        ReadAccessToken readAccessToken = new ReadAccessToken(status);
        if (readAccessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireReadActionLock"));
        }
        return readAccessToken;
    }

    @Override
    public boolean isWriteActionPending() {
        return this.myWriteActionPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWrite(Class clazz) {
        ApplicationImpl.assertIsDispatchThread(ApplicationImpl.getStatus(), "Write access is allowed from event dispatch thread only");
        boolean writeActionPending = this.myWriteActionPending;
        this.myWriteActionPending = true;
        try {
            ActivityTracker.getInstance().inc();
            this.fireBeforeWriteActionStart(clazz);
            try {
                if (!this.isWriteAccessAllowed()) {
                    this.assertNoPsiLock();
                }
                if (!this.myLock.writeLock().tryLock()) {
                    final AtomicBoolean lockAcquired = new AtomicBoolean(false);
                    if (ourDumpThreadsOnLongWriteActionWaiting > 0) {
                        this.executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                while (!lockAcquired.get()) {
                                    TimeoutUtil.sleep((long)ourDumpThreadsOnLongWriteActionWaiting);
                                    if (lockAcquired.get()) continue;
                                    PerformanceWatcher.getInstance().dumpThreads("waiting", true);
                                }
                            }
                        });
                    }
                    this.myLock.writeLock().lockInterruptibly();
                    lockAcquired.set(true);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
        finally {
            this.myWriteActionPending = writeActionPending;
        }
        this.myWriteActionsStack.push((Object)clazz);
        this.fireWriteActionStarted(clazz);
    }

    private void endWrite(Class clazz) {
        try {
            this.myWriteActionsStack.pop();
            this.fireWriteActionFinished(clazz);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @NotNull
    public AccessToken acquireWriteActionLock(Class clazz) {
        WriteAccessToken writeAccessToken = new WriteAccessToken(clazz);
        if (writeAccessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireWriteActionLock"));
        }
        return writeAccessToken;
    }

    private void assertNoPsiLock() {
        if (this.myExtraChecks) {
            LOG.assertTrue(!Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing readAction");
        }
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.myLock.isWriteLockedByCurrentThread();
    }

    private boolean isInsideWriteActionEDTOnly() {
        return !this.myWriteActionsStack.isEmpty();
    }

    @Override
    public boolean isWriteActionInProgress() {
        return this.myLock.isWriteLocked();
    }

    public void editorPaintStart() {
        ++this.myInEditorPaintCounter;
    }

    public void editorPaintFinish() {
        --this.myInEditorPaintCounter;
        LOG.assertTrue(this.myInEditorPaintCounter >= 0);
    }

    public void addApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(@NotNull ApplicationListener l, @NotNull Disposable parent) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/application/impl/ApplicationImpl", "removeApplicationListener"));
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireApplicationExiting() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
    }

    private void fireBeforeWriteActionStart(Class action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart((Object)action);
    }

    private void fireWriteActionStarted(Class action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted((Object)action);
    }

    private void fireWriteActionFinished(Class action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished((Object)action);
    }

    public void saveSettings() {
        if (this.myDoNotSave) {
            return;
        }
        if (this.mySaveSettingsIsInProgress.compareAndSet(false, true)) {
            try {
                StoreUtil.save(this.getStateStore(), null);
            }
            finally {
                this.mySaveSettingsIsInProgress.set(false);
            }
        }
    }

    public void saveAll() {
        Project[] openProjects;
        if (this.myDoNotSave) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            openProject.save();
        }
        this.saveSettings();
    }

    @Override
    public void doNotSave() {
        this.doNotSave(true);
    }

    @Override
    public void doNotSave(boolean value) {
        this.myDoNotSave = value;
    }

    @Override
    public boolean isDoNotSave() {
        return this.myDoNotSave;
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/application/impl/ApplicationImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getRootArea().getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getExtensions"));
        }
        return objectArray;
    }

    public boolean isDisposeInProgress() {
        return this.myDisposeInProgress || ShutDownTracker.isShutdownHookRunning();
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public void setDisposeInProgress(boolean disposeInProgress) {
        this.myDisposeInProgress = disposeInProgress;
    }

    @NonNls
    public String toString() {
        return "Application" + (this.isDisposed() ? " (Disposed)" : "") + (this.isUnitTestMode() ? " (Unit test)" : "") + (this.isInternal() ? " (Internal)" : "") + (this.isHeadlessEnvironment() ? " (Headless)" : "") + (this.isCommandLine() ? " (Command line)" : "");
    }

    static /* synthetic */ String access$500(Thread x0) {
        return ApplicationImpl.describe(x0);
    }

    private class ReadAccessToken
    extends AccessToken {
        private final Status myStatus;

        private ReadAccessToken(Status status) {
            this.myStatus = status;
            ApplicationImpl.this.startRead(status);
            this.acquired();
        }

        public void finish() {
            ApplicationImpl.this.endRead(this.myStatus);
            this.released();
        }
    }

    private class WriteAccessToken
    extends AccessToken {
        private final Class clazz;

        public WriteAccessToken(Class clazz) {
            this.clazz = clazz;
            ApplicationImpl.this.startWrite(clazz);
            this.markThreadNameInStackTrace();
            this.acquired();
        }

        public void finish() {
            try {
                ApplicationImpl.this.endWrite(this.clazz);
            }
            finally {
                this.unmarkThreadNameInStackTrace();
                this.released();
            }
        }

        private void markThreadNameInStackTrace() {
            String id = this.id();
            if (id != null) {
                Thread thread = Thread.currentThread();
                thread.setName(thread.getName() + id);
            }
        }

        private void unmarkThreadNameInStackTrace() {
            String id = this.id();
            if (id != null) {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                name = StringUtil.replace((String)name, (String)id, (String)"");
                thread.setName(name);
            }
        }

        private String id() {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            while (name == null) {
                aClass = aClass.getSuperclass();
                name = aClass.getName();
            }
            name = name.substring(name.lastIndexOf(46) + 1);
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
                return " [" + name + "]";
            }
            return null;
        }
    }

    private static class Status {
        private int flags;

        private Status() {
        }
    }
}

