/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.StorageUtil");
    private static final byte[] XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(CharsetToolkit.UTF8_CHARSET);
    private static final Pair<byte[], String> NON_EXISTENT_FILE_DATA = Pair.create(null, (Object)SystemProperties.getLineSeparator());
    public static String DEBUG_LOG = "";

    private StorageUtil() {
    }

    public static boolean isChangedByStorageOrSaveSession(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil", "isChangedByStorageOrSaveSession"));
        }
        return event.getRequestor() instanceof StateStorage.SaveSession || event.getRequestor() instanceof StateStorage;
    }

    public static void notifyUnknownMacros(@NotNull TrackingPathMacroSubstitutor substitutor, final @NotNull Project project, final @Nullable String componentName) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        final LinkedHashSet<String> macros = new LinkedHashSet<String>(substitutor.getUnknownMacros(componentName));
        if (macros.isEmpty()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                SmartList notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, project)) {
                    if (notified == null) {
                        notified = new SmartList();
                    }
                    notified.addAll(notification.getMacros());
                }
                if (!ContainerUtil.isEmpty(notified)) {
                    macros.removeAll((Collection<?>)notified);
                }
                if (!macros.isEmpty()) {
                    LOG.debug("Reporting unknown path macros " + macros + " in component " + componentName);
                    String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
                    String productName = ApplicationNamesInfo.getInstance().getProductName();
                    String content = String.format(format, StringUtil.join((Collection)macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
                    new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/components/impl/stores/StorageUtil$1$1", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil$1$1", "hyperlinkUpdate"));
                            }
                            ((ProjectEx)project).checkUnknownMacros(true);
                        }
                    }, macros).notify(project);
                }
            }
        });
    }

    @NotNull
    public static VirtualFile writeFile(@Nullable File file, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull BufferExposingByteArrayOutputStream content, @Nullable LineSeparator lineSeparatorIfPrependXmlProlog) throws IOException {
        VirtualFile result;
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        if (!(file == null || virtualFile != null && virtualFile.isValid())) {
            result = StorageUtil.getOrCreateVirtualFile(requestor, file);
        } else {
            result = virtualFile;
            assert (result != null);
        }
        boolean equals = StorageUtil.isEqualContent(result, lineSeparatorIfPrependXmlProlog, content);
        if (equals) {
            LOG.warn("Content equals, but it must be handled not on this level: " + result.getName());
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode() && DEBUG_LOG != null) {
                DEBUG_LOG = result.getPath() + ":\n" + content + "\nOld Content:\n" + LoadTextUtil.loadText(result) + "\n---------";
            }
            StorageUtil.doWrite(requestor, result, content, lineSeparatorIfPrependXmlProlog);
        }
        VirtualFile virtualFile2 = result;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        return virtualFile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doWrite(final @NotNull Object requestor, final @NotNull VirtualFile file, final @NotNull BufferExposingByteArrayOutputStream content, final @Nullable LineSeparator lineSeparatorIfPrependXmlProlog) throws IOException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        LOG.debug("Save " + file.getPresentableUrl());
        AccessToken token = WriteAction.start();
        try {
            OutputStream out = file.getOutputStream(requestor);
            try {
                if (lineSeparatorIfPrependXmlProlog != null) {
                    out.write(XML_PROLOG);
                    out.write(lineSeparatorIfPrependXmlProlog.getSeparatorBytes());
                }
                content.writeTo(out);
            }
            finally {
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new ReadOnlyModificationException(file, e, new StateStorage.SaveSession(){

                public void save() throws IOException {
                    StorageUtil.doWrite(requestor, file, content, lineSeparatorIfPrependXmlProlog);
                }
            });
        }
        finally {
            token.finish();
        }
    }

    private static boolean isEqualContent(VirtualFile result, @Nullable LineSeparator lineSeparatorIfPrependXmlProlog, @NotNull BufferExposingByteArrayOutputStream content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StorageUtil", "isEqualContent"));
        }
        boolean equals = true;
        int headerLength = lineSeparatorIfPrependXmlProlog == null ? 0 : XML_PROLOG.length + lineSeparatorIfPrependXmlProlog.getSeparatorBytes().length;
        int toWriteLength = headerLength + content.size();
        if (result.getLength() != (long)toWriteLength) {
            equals = false;
        } else {
            byte[] bytes = result.contentsToByteArray();
            if (!(lineSeparatorIfPrependXmlProlog == null || ArrayUtil.startsWith((byte[])bytes, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])bytes, (int)XML_PROLOG.length, (byte[])lineSeparatorIfPrependXmlProlog.getSeparatorBytes()))) {
                equals = false;
            }
            if (!ArrayUtil.startsWith((byte[])bytes, (int)headerLength, (byte[])content.toByteArray())) {
                equals = false;
            }
        }
        return equals;
    }

    public static void deleteFile(@NotNull File file, final @NotNull Object requestor, final @Nullable VirtualFile virtualFile) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (virtualFile == null) {
            LOG.warn("Cannot find virtual file " + file.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file.exists()) {
                FileUtil.delete((File)file);
            }
        } else if (virtualFile.exists()) {
            try {
                StorageUtil.deleteFile(requestor, virtualFile);
            }
            catch (FileNotFoundException e) {
                throw new ReadOnlyModificationException(virtualFile, e, new StateStorage.SaveSession(){

                    public void save() throws IOException {
                        StorageUtil.deleteFile(requestor, virtualFile);
                    }
                });
            }
        }
    }

    public static void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) throws IOException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
        try {
            virtualFile.delete(requestor);
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public static BufferExposingByteArrayOutputStream writeToBytes(@NotNull Parent element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)element, (OutputStream)out, (String)lineSeparator);
        BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = out;
        if (bufferExposingByteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        return bufferExposingByteArrayOutputStream;
    }

    @NotNull
    public static VirtualFile getOrCreateVirtualFile(final @Nullable Object requestor, final @NotNull File file) throws IOException {
        VirtualFile parentVirtualFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile2;
        }
        File absoluteFile = file.getAbsoluteFile();
        FileUtil.createParentDirs((File)absoluteFile);
        File parentFile = absoluteFile.getParentFile();
        VirtualFile virtualFile3 = parentVirtualFile = StringUtil.isEmpty((String)parentFile.getPath()) ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
        if (parentVirtualFile == null) {
            throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            VirtualFile virtualFile4 = parentVirtualFile.createChildData(requestor, file.getName());
            if (virtualFile4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile4;
        }
        VirtualFile virtualFile5 = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return parentVirtualFile.createChildData(requestor, file.getName());
            }
        });
        if (virtualFile5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        return virtualFile5;
    }

    @NotNull
    public static Pair<byte[], String> loadFile(@Nullable VirtualFile file) throws IOException {
        if (file == null || !file.exists()) {
            Pair<byte[], String> pair = NON_EXISTENT_FILE_DATA;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "loadFile"));
            }
            return pair;
        }
        byte[] bytes = file.contentsToByteArray();
        String lineSeparator = file.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = StorageUtil.detectLineSeparators(CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(bytes)), null).getSeparatorString();
        }
        Pair pair = Pair.create((Object)bytes, (Object)lineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "loadFile"));
        }
        return pair;
    }

    @NotNull
    public static LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
        }
        int n = chars.length();
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c == '\r') {
                LineSeparator lineSeparator = LineSeparator.CRLF;
                if (lineSeparator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
                }
                return lineSeparator;
            }
            if (c != '\n') continue;
            LineSeparator lineSeparator = LineSeparator.LF;
            if (lineSeparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
            }
            return lineSeparator;
        }
        LineSeparator lineSeparator = defaultSeparator == null ? LineSeparator.getSystemLineSeparator() : defaultSeparator;
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
        }
        return lineSeparator;
    }

    public static void delete(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull RoamingType type) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (provider.isApplicable(fileSpec, type)) {
            provider.delete(fileSpec, type);
        }
    }

    public static void sendContent(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull Element element, @NotNull RoamingType type, boolean async) throws IOException {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        BufferExposingByteArrayOutputStream content = StorageUtil.writeToBytes((Parent)element, "\n");
        provider.saveContent(fileSpec, content.getInternalBuffer(), content.size(), type, async);
    }

    public static boolean isProjectOrModuleFile(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "isProjectOrModuleFile"));
        }
        return "$PROJECT_FILE$".equals(fileSpec) || fileSpec.startsWith("$PROJECT_CONFIG_DIR$") || fileSpec.equals("$MODULE_FILE$");
    }
}

