/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.SaveSessionBase;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementStorage
extends StateStorageBase<StorageData> {
    @NotNull
    protected final String myRootElementName;
    protected final StreamProvider myStreamProvider;
    protected final String myFileSpec;
    protected boolean myBlockSavingTheContent;
    protected final RoamingType myRoamingType;

    protected XmlElementStorage(@NotNull String fileSpec, @Nullable RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull String rootElementName, @Nullable StreamProvider streamProvider) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        super(pathMacroSubstitutor);
        this.myBlockSavingTheContent = false;
        this.myFileSpec = fileSpec;
        this.myRoamingType = roamingType == null ? RoamingType.PER_USER : roamingType;
        this.myRootElementName = rootElementName;
        this.myStreamProvider = this.myRoamingType == RoamingType.DISABLED ? null : streamProvider;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    protected Element getStateAndArchive(@NotNull StorageData storageData, Object component, @NotNull String componentName) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStateAndArchive"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStateAndArchive"));
        }
        return storageData.getStateAndArchive(componentName);
    }

    @Override
    @NotNull
    protected StorageData loadData() {
        Element element;
        StorageData result = this.createStorageData();
        if (this.myStreamProvider != null && this.myStreamProvider.isEnabled()) {
            try {
                element = this.loadDataFromStreamProvider();
                if (element != null) {
                    this.loadState(result, element);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                element = null;
            }
        } else {
            element = this.loadLocalData();
        }
        if (element != null) {
            this.loadState(result, element);
        }
        StorageData storageData = result;
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadData"));
        }
        return storageData;
    }

    @Nullable
    protected final Element loadDataFromStreamProvider() throws IOException, JDOMException {
        assert (this.myStreamProvider != null);
        return JDOMUtil.load((InputStream)this.myStreamProvider.loadContent(this.myFileSpec, this.myRoamingType));
    }

    protected final void loadState(@NotNull StorageData result, @NotNull Element element) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadState"));
        }
        result.load(element, this.myPathMacroSubstitutor, true);
    }

    @NotNull
    protected StorageData createStorageData() {
        StorageData storageData = new StorageData(this.myRootElementName);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "createStorageData"));
        }
        return storageData;
    }

    public void setDefaultState(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "setDefaultState"));
        }
        this.myStorageData = this.createStorageData();
        this.loadState((StorageData)this.myStorageData, element);
    }

    @Nullable
    public final XmlElementStorageSaveSession startExternalization() {
        return this.checkIsSavingDisabled() ? null : this.createSaveSession((StorageData)this.getStorageData());
    }

    @NotNull
    protected abstract XmlElementStorageSaveSession createSaveSession(@NotNull StorageData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Element getElement(@NotNull StorageData data, boolean collapsePaths, @NotNull Map<String, Element> newLiveStates) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getElement"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getElement"));
        }
        Element element = data.save(newLiveStates);
        if (element == null || JDOMUtil.isEmpty((Element)element)) {
            return null;
        }
        if (collapsePaths && this.myPathMacroSubstitutor != null) {
            try {
                this.myPathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.myPathMacroSubstitutor.reset();
            }
        }
        return element;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<VirtualFile> changedFiles, @NotNull Set<String> componentNames) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        StorageData oldData = (StorageData)this.myStorageData;
        StorageData newData = (StorageData)this.getStorageData(true);
        if (oldData == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString());
            }
            componentNames.addAll(newData.getComponentNames());
        } else {
            Set<String> changedComponentNames = oldData.getChangedComponentNames(newData, this.myPathMacroSubstitutor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("analyzeExternalChangesAndUpdateIfNeed: changedComponentNames + " + changedComponentNames + " for " + this.toString());
            }
            if (!ContainerUtil.isEmpty(changedComponentNames)) {
                componentNames.addAll(changedComponentNames);
            }
        }
    }

    protected abstract class XmlElementStorageSaveSession
    extends SaveSessionBase {
        private final StorageData myOriginalStorageData;
        private StorageData myCopiedStorageData;
        private final Map<String, Element> myNewLiveStates;

        public XmlElementStorageSaveSession(StorageData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "<init>"));
            }
            this.myNewLiveStates = new THashMap();
            this.myOriginalStorageData = storageData;
        }

        @Nullable
        public final StateStorage.SaveSession createSaveSession() {
            return XmlElementStorage.this.checkIsSavingDisabled() || this.myCopiedStorageData == null ? null : this;
        }

        @Override
        protected void setSerializedState(@NotNull Object component, @NotNull String componentName, @Nullable Element element) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setSerializedState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setSerializedState"));
            }
            if (this.myCopiedStorageData == null) {
                this.myCopiedStorageData = StorageData.setStateAndCloneIfNeed(componentName, element, this.myOriginalStorageData, this.myNewLiveStates);
            } else {
                this.myCopiedStorageData.setState(componentName, element, this.myNewLiveStates);
            }
        }

        public void forceSave() throws IOException {
            StateStorageBase.LOG.assertTrue(this.myCopiedStorageData == null);
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            this.doSave(XmlElementStorage.this.getElement(this.myOriginalStorageData, this.isCollapsePathsOnSave(), Collections.<String, Element>emptyMap()));
        }

        public final void save() throws IOException {
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            this.doSave(XmlElementStorage.this.getElement(this.myCopiedStorageData, this.isCollapsePathsOnSave(), this.myNewLiveStates));
            XmlElementStorage.this.myStorageData = this.myCopiedStorageData;
        }

        protected boolean isCollapsePathsOnSave() {
            return true;
        }

        protected abstract void doSave(@Nullable Element var1) throws IOException;

        protected void saveForProvider(@Nullable BufferExposingByteArrayOutputStream content, @Nullable Element element) throws IOException {
            if (!XmlElementStorage.this.myStreamProvider.isApplicable(XmlElementStorage.this.myFileSpec, XmlElementStorage.this.myRoamingType)) {
                return;
            }
            if (element == null) {
                XmlElementStorage.this.myStreamProvider.delete(XmlElementStorage.this.myFileSpec, XmlElementStorage.this.myRoamingType);
            } else {
                this.doSaveForProvider(element, XmlElementStorage.this.myRoamingType, content);
            }
        }

        private void doSaveForProvider(@NotNull Element element, @NotNull RoamingType roamingType, @Nullable BufferExposingByteArrayOutputStream content) throws IOException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "doSaveForProvider"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "doSaveForProvider"));
            }
            if (content == null) {
                StorageUtil.sendContent(XmlElementStorage.this.myStreamProvider, XmlElementStorage.this.myFileSpec, element, roamingType, true);
            } else {
                XmlElementStorage.this.myStreamProvider.saveContent(XmlElementStorage.this.myFileSpec, content.getInternalBuffer(), content.size(), XmlElementStorage.this.myRoamingType, true);
            }
        }
    }
}

