/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class FontInfo {
    private static final boolean USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE = SystemInfo.isAppleJvm && Registry.is((String)"ide.mac.fix.font.fallback");
    private static final FontRenderContext DUMMY_CONTEXT = new FontRenderContext(null, false, false);
    private final TIntHashSet mySymbolsToBreakDrawingIteration = new TIntHashSet();
    private final Font myFont;
    private final int mySize;
    @JdkConstants.FontStyle
    private final int myStyle;
    private final TIntHashSet mySafeCharacters = new TIntHashSet();
    private FontMetrics myFontMetrics = null;
    private final int[] charWidth = new int[128];
    private boolean myHasGlyphsToBreakDrawingIteration;
    private boolean myCheckedForProblemGlyphs;

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style) {
        this.mySize = size;
        this.myStyle = style;
        this.myFont = new Font(familyName, style, size);
    }

    private void parseProblemGlyphs() {
        this.myCheckedForProblemGlyphs = true;
        BufferedImage buffer = UIUtil.createImage((int)20, (int)20, (int)1);
        Graphics graphics = buffer.getGraphics();
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        FontRenderContext context = ((Graphics2D)graphics).getFontRenderContext();
        char[] charBuffer = new char[1];
        for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            if (!this.myFont.canDisplay(c)) continue;
            charBuffer[0] = c;
            GlyphVector vector = this.myFont.createGlyphVector(context, charBuffer);
            float y = vector.getGlyphMetrics(0).getAdvanceY();
            if (Math.round(y) == 0) continue;
            this.mySymbolsToBreakDrawingIteration.add((int)c);
        }
        this.myHasGlyphsToBreakDrawingIteration = !this.mySymbolsToBreakDrawingIteration.isEmpty();
    }

    public boolean hasGlyphsToBreakDrawingIteration() {
        if (!this.myCheckedForProblemGlyphs) {
            this.parseProblemGlyphs();
        }
        return this.myHasGlyphsToBreakDrawingIteration;
    }

    @NotNull
    public TIntHashSet getSymbolsToBreakDrawingIteration() {
        if (!this.myCheckedForProblemGlyphs) {
            this.parseProblemGlyphs();
        }
        TIntHashSet tIntHashSet = this.mySymbolsToBreakDrawingIteration;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getSymbolsToBreakDrawingIteration"));
        }
        return tIntHashSet;
    }

    public boolean canDisplay(char c) {
        try {
            if (c < '\u0080') {
                return true;
            }
            if (this.mySafeCharacters.contains((int)c)) {
                return true;
            }
            if (this.canDisplayImpl(c)) {
                this.mySafeCharacters.add((int)c);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canDisplayImpl(char c) {
        if (USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE) {
            return this.myFont.createGlyphVector(DUMMY_CONTEXT, new char[]{c}).getGlyphCode(0) > 0;
        }
        return this.myFont.canDisplay(c);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(char c) {
        FontMetrics metrics = this.fontMetrics();
        if (c < '\u0080') {
            return this.charWidth[c];
        }
        return metrics.charWidth(c);
    }

    private FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            Graphics graphics = UIUtil.createImage((int)1, (int)1, (int)1).getGraphics();
            EditorUIUtil.setupAntialiasing(graphics);
            graphics.setFont(this.myFont);
            this.myFontMetrics = graphics.getFontMetrics();
            for (int i = 0; i < 128; ++i) {
                this.charWidth[i] = this.myFontMetrics.charWidth(i);
            }
        }
        return this.myFontMetrics;
    }

    void reset() {
        this.myFontMetrics = null;
    }

    public int getSize() {
        return this.mySize;
    }

    @JdkConstants.FontStyle
    public int getStyle() {
        return this.myStyle;
    }
}

