/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

class EditorCoordinateMapper {
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModelImpl myFoldingModel;

    EditorCoordinateMapper(EditorView view) {
        this.myView = view;
        this.myDocument = this.myView.getEditor().getDocument();
        this.myFoldingModel = this.myView.getEditor().getFoldingModel();
    }

    int visualLineToY(int line) {
        return line * this.myView.getLineHeight();
    }

    int yToVisualLine(int y) {
        return y / this.myView.getLineHeight();
    }

    @NotNull
    LogicalPosition offsetToLogicalPosition(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (offset <= 0 || textLength == 0) {
            LogicalPosition logicalPosition = new LogicalPosition(0, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "offsetToLogicalPosition"));
            }
            return logicalPosition;
        }
        offset = Math.min(offset, textLength);
        int line = this.myDocument.getLineNumber(offset);
        offset = Math.min(offset, this.myDocument.getLineEndOffset(line));
        int column = 0;
        CharSequence text = this.myDocument.getImmutableCharSequence();
        int tabSize = this.myView.getTabSize();
        for (int i = this.myDocument.getLineStartOffset(line); i < offset; ++i) {
            if (text.charAt(i) == '\t') {
                column = (column / tabSize + 1) * tabSize;
                continue;
            }
            ++column;
        }
        LogicalPosition logicalPosition = new LogicalPosition(line, column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalPositionToOffset"));
        }
        int line = pos.line;
        if (line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        int lineEndOffset = this.myDocument.getLineEndOffset(line);
        CharSequence text = this.myDocument.getImmutableCharSequence();
        int tabSize = this.myView.getTabSize();
        int column = 0;
        for (int i = lineStartOffset; i < lineEndOffset; ++i) {
            column = text.charAt(i) == '\t' ? (column / tabSize + 1) * tabSize : ++column;
            if (pos.column >= column) continue;
            return i;
        }
        return lineEndOffset;
    }

    @NotNull
    VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
        }
        int line = pos.line;
        int column = pos.column;
        int logicalLineCount = this.myDocument.getLineCount();
        if (line >= logicalLineCount) {
            VisualPosition visualPosition = new VisualPosition(line - logicalLineCount + this.myView.getEditor().getVisibleLineCount(), column, pos.leansForward);
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
            }
            return visualPosition;
        }
        int offset = this.logicalPositionToOffset(pos);
        int visualLine = this.offsetToVisualLine(offset);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset)) {
            if (column == 0 && !pos.leansForward && fragment.getStartVisualColumn() == 0 && fragment.getStartLogicalLine() == line) {
                VisualPosition visualPosition = new VisualPosition(visualLine, 0);
                if (visualPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
                }
                return visualPosition;
            }
            if (fragment.isCollapsedFoldRegion()) {
                int startLogicalLine = fragment.getStartLogicalLine();
                int endLogicalLine = fragment.getEndLogicalLine();
                int startLogicalColumn = fragment.getStartLogicalColumn();
                int endLogicalColumn = fragment.getEndLogicalColumn();
                if ((line > startLogicalLine || line == startLogicalLine && (column > startLogicalColumn || column == startLogicalColumn && pos.leansForward)) && (line < endLogicalLine || line == endLogicalLine && column < endLogicalColumn)) {
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.getStartVisualColumn(), true);
                    if (visualPosition == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
                    }
                    return visualPosition;
                }
                if (line == endLogicalLine && column == endLogicalColumn && !pos.leansForward) {
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.getEndVisualColumn());
                    if (visualPosition == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
                    }
                    return visualPosition;
                }
                maxLogicalColumn = startLogicalLine == endLogicalLine ? Math.max(maxLogicalColumn, endLogicalColumn) : endLogicalColumn;
            } else {
                int minColumn = fragment.getMinLogicalColumn();
                int maxColumn = fragment.getMaxLogicalColumn();
                if (line == fragment.getStartLogicalLine() && (column > minColumn && column < maxColumn || column == minColumn && pos.leansForward || column == maxColumn && !pos.leansForward)) {
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.logicalToVisualColumn(column), fragment.isRtl() ^ pos.leansForward);
                    if (visualPosition == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
                    }
                    return visualPosition;
                }
                maxLogicalColumn = Math.max(maxLogicalColumn, maxColumn);
            }
            maxVisualColumn = fragment.getEndVisualColumn();
        }
        VisualPosition visualPosition = new VisualPosition(visualLine, column - maxLogicalColumn + maxVisualColumn, pos.leansForward);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualToLogicalPosition"));
        }
        int line = pos.line;
        int column = pos.column;
        int logicalLine = this.visualToLogicalLine(line);
        if (logicalLine >= this.myDocument.getLineCount()) {
            LogicalPosition logicalPosition = new LogicalPosition(logicalLine, column, pos.leansRight);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualToLogicalPosition"));
            }
            return logicalPosition;
        }
        if (column == 0 && !pos.leansRight) {
            LogicalPosition logicalPosition = new LogicalPosition(logicalLine, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualToLogicalPosition"));
            }
            return logicalPosition;
        }
        int offset = this.myDocument.getLineStartOffset(logicalLine);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset)) {
            int minColumn = fragment.getStartVisualColumn();
            int maxColumn = fragment.getEndVisualColumn();
            if (column > minColumn && column < maxColumn || column == minColumn && pos.leansRight || column == maxColumn && !pos.leansRight) {
                LogicalPosition logicalPosition = new LogicalPosition(column == maxColumn ? fragment.getEndLogicalLine() : fragment.getStartLogicalLine(), fragment.visualToLogicalColumn(column), fragment.isCollapsedFoldRegion() ? column < maxColumn : fragment.isRtl() ^ pos.leansRight);
                if (logicalPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualToLogicalPosition"));
                }
                return logicalPosition;
            }
            maxLogicalColumn = logicalLine == fragment.getEndLogicalLine() ? Math.max(maxLogicalColumn, fragment.getMaxLogicalColumn()) : fragment.getMaxLogicalColumn();
            maxVisualColumn = maxColumn;
            logicalLine = fragment.getEndLogicalLine();
        }
        LogicalPosition logicalPosition = new LogicalPosition(logicalLine, column - maxVisualColumn + maxLogicalColumn, true);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanTowardsLargerOffsets));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    int offsetToVisualLine(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            return 0;
        }
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset = Math.min(offset, textLength));
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            assert (outermostCollapsed.isValid());
            offset = outermostCollapsed.getStartOffset();
        }
        return this.myDocument.getLineNumber(offset) - this.myFoldingModel.getFoldedLinesCountBefore(offset);
    }

    int visualToLogicalLine(int visualLine) {
        int offset;
        FoldRegion region;
        FoldRegion[] regions = this.myFoldingModel.fetchTopLevel();
        if (regions == null || regions.length == 0) {
            return visualLine;
        }
        int start = 0;
        int end = regions.length - 1;
        int i = 0;
        while (start <= end) {
            i = (start + end) / 2;
            region = regions[i];
            assert (region.isValid());
            int regionVisualLine = this.offsetToVisualLine(region.getStartOffset());
            if (regionVisualLine < visualLine) {
                start = i + 1;
                continue;
            }
            if (regionVisualLine <= visualLine) break;
            end = i - 1;
        }
        while (i >= 0) {
            region = regions[i];
            assert (region.isValid());
            if (this.offsetToVisualLine(region.getStartOffset()) < visualLine) break;
            --i;
        }
        if (++i < regions.length) {
            FoldRegion region2 = regions[i];
            assert (region2.isValid());
            offset = region2.getStartOffset();
        } else {
            offset = this.myDocument.getTextLength();
        }
        return visualLine + this.myFoldingModel.getFoldedLinesCountBefore(offset);
    }

    private float getStartX(int line) {
        return line == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
    }

    @NotNull
    VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "xyToVisualPosition"));
        }
        int visualLine = this.yToVisualLine(Math.max(p.y, 0));
        int logicalLine = this.visualToLogicalLine(visualLine);
        int lastColumn = 0;
        float x = this.getStartX(logicalLine);
        if (logicalLine < this.myDocument.getLineCount()) {
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, this.myDocument.getLineStartOffset(logicalLine))) {
                float nextX = fragment.getEndX();
                if ((float)p.x <= nextX) {
                    int[] column = fragment.xToVisualColumn(p.x);
                    VisualPosition visualPosition = new VisualPosition(visualLine, column[0], column[1] > 0);
                    if (visualPosition == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "xyToVisualPosition"));
                    }
                    return visualPosition;
                }
                x = nextX;
                lastColumn = fragment.getEndVisualColumn();
            }
        }
        int plainSpaceWidth = this.myView.getPlainSpaceWidth();
        int remainingShift = (int)((float)p.x - x);
        int additionalColumns = remainingShift <= 0 ? 0 : (remainingShift + plainSpaceWidth / 2) / plainSpaceWidth;
        VisualPosition visualPosition = new VisualPosition(visualLine, lastColumn + additionalColumns, remainingShift > 0 && additionalColumns == (remainingShift - 1) / plainSpaceWidth);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    Point visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualPositionToXY"));
        }
        int visualLine = pos.line;
        int column = pos.column;
        int y = this.visualLineToY(visualLine);
        int logicalLine = this.visualToLogicalLine(visualLine);
        float x = this.getStartX(logicalLine);
        int lastColumn = 0;
        if (logicalLine < this.myDocument.getLineCount()) {
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, this.myDocument.getLineStartOffset(logicalLine))) {
                int endColumn = fragment.getEndVisualColumn();
                if (column <= endColumn) {
                    Point point = new Point((int)fragment.visualColumnToX(column), y);
                    if (point == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualPositionToXY"));
                    }
                    return point;
                }
                x = fragment.getEndX();
                lastColumn = endColumn;
            }
        }
        int additionalShift = column <= lastColumn ? 0 : (column - lastColumn) * this.myView.getPlainSpaceWidth();
        Point point = new Point((int)x + additionalShift, y);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "visualPositionToXY"));
        }
        return point;
    }

    @NotNull
    Point offsetToXY(int offset, boolean leanTowardsLargerOffsets) {
        offset = Math.max(0, Math.min(this.myDocument.getTextLength(), offset));
        int logicalLine = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(logicalLine);
        int intraLineOffset = offset - lineStartOffset;
        int y = this.visualLineToY(this.offsetToVisualLine(offset));
        float x = this.getStartX(logicalLine);
        if (this.myDocument.getTextLength() > 0) {
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset)) {
                if (intraLineOffset == 0 && !leanTowardsLargerOffsets && fragment.getStartVisualColumn() == 0 && fragment.getStartLogicalLine() == logicalLine) break;
                int minOffset = fragment.getMinOffset();
                int maxOffset = fragment.getMaxOffset();
                if (offset > minOffset && offset < maxOffset || offset == minOffset && leanTowardsLargerOffsets || offset == maxOffset && !leanTowardsLargerOffsets) {
                    x = fragment.offsetToX(offset);
                    break;
                }
                x = fragment.getEndX();
            }
        }
        Point point = new Point((int)x, y);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper", "offsetToXY"));
        }
        return point;
    }
}

