/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.TIntArrayList;
import java.awt.Dimension;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class EditorSizeManager
implements PrioritizedDocumentListener,
Disposable,
FoldingListener {
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final TIntArrayList myLineWidths = new TIntArrayList();
    private int myWidthInPixels;
    private int myMaxLineWithExtensionWidth;
    private int myWidestLineWithExtension;
    private int foldingChangeStartOffset = Integer.MAX_VALUE;
    private int foldingChangeEndOffset = Integer.MIN_VALUE;

    EditorSizeManager(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
        this.myDocument.addDocumentListener(this, this);
        this.myEditor.getFoldingModel().addListener(this, this);
    }

    public void dispose() {
    }

    @Override
    public int getPriority() {
        return 75;
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.invalidateRange(event.getOffset(), event.getOffset() + event.getNewLength());
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/view/EditorSizeManager", "onFoldRegionStateChange"));
        }
        if (region.isValid()) {
            this.foldingChangeStartOffset = Math.min(this.foldingChangeStartOffset, region.getStartOffset());
            this.foldingChangeEndOffset = Math.max(this.foldingChangeEndOffset, region.getEndOffset());
        }
    }

    @Override
    public void onFoldProcessingEnd() {
        if (this.foldingChangeStartOffset <= this.foldingChangeEndOffset) {
            this.invalidateRange(this.foldingChangeStartOffset, this.foldingChangeEndOffset);
        }
        this.foldingChangeStartOffset = Integer.MAX_VALUE;
        this.foldingChangeEndOffset = Integer.MIN_VALUE;
    }

    Dimension getPreferredSize() {
        int width = this.getPreferredWidth();
        if (!this.myDocument.isInBulkUpdate()) {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                if (!caret.isUpToDate()) continue;
                int caretX = this.myView.visualPositionToXY((VisualPosition)caret.getVisualPosition()).x;
                width = Math.max(caretX, width);
            }
        }
        return new Dimension(width += this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth(), this.myEditor.getPreferredHeight());
    }

    private int getPreferredWidth() {
        if (this.myWidthInPixels < 0) {
            this.myWidthInPixels = this.calculatePreferredWidth();
        }
        this.validateMaxLineWithExtension();
        return Math.max(this.myWidthInPixels, this.myMaxLineWithExtensionWidth);
    }

    private void validateMaxLineWithExtension() {
        if (this.myMaxLineWithExtensionWidth > 0) {
            Project project = this.myEditor.getProject();
            VirtualFile virtualFile = this.myEditor.getVirtualFile();
            if (project != null && virtualFile != null) {
                for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                    Collection<LineExtensionInfo> extensions = painter.getLineExtensions(project, virtualFile, this.myWidestLineWithExtension);
                    if (extensions == null || extensions.isEmpty()) continue;
                    return;
                }
            }
            this.myMaxLineWithExtensionWidth = 0;
        }
    }

    private int calculatePreferredWidth() {
        int lineCount = this.myLineWidths.size();
        int maxWidth = 0;
        for (int i = 0; i < lineCount; ++i) {
            int width = this.myLineWidths.get(i);
            if (width < 0) {
                width = this.myView.getMaxWidthInLineRange(i, i);
                this.myLineWidths.set(i, width);
            }
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    void reset() {
        this.invalidateRange(0, this.myDocument.getTextLength());
    }

    void invalidateRange(int startOffset, int endOffset) {
        this.myWidthInPixels = -1;
        int startVisualLine = this.myView.offsetToVisualLine(startOffset);
        int endVisualLine = this.myView.offsetToVisualLine(endOffset);
        int lineDiff = this.myEditor.getVisibleLineCount() - this.myLineWidths.size();
        if (lineDiff > 0) {
            int[] newEntries = new int[lineDiff];
            this.myLineWidths.insert(startVisualLine, newEntries);
        } else if (lineDiff < 0) {
            this.myLineWidths.remove(startVisualLine, -lineDiff);
        }
        for (int i = startVisualLine; i <= endVisualLine && i < this.myLineWidths.size(); ++i) {
            this.myLineWidths.set(i, -1);
        }
    }

    int getMaxLineWithExtensionWidth() {
        return this.myMaxLineWithExtensionWidth;
    }

    void setMaxLineWithExtensionWidth(int lineNumber, int width) {
        this.myWidestLineWithExtension = lineNumber;
        this.myMaxLineWithExtensionWidth = width;
    }
}

