/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private JComboBox myKeymapList;
    private final DefaultComboBoxModel myKeymapListModel = new DefaultComboBoxModel();
    private KeymapImpl mySelectedKeymap;
    private JButton myCopyButton;
    private JButton myDeleteButton;
    private JButton myResetToDefault;
    private JCheckBox myNonEnglishKeyboardSupportOption;
    private JLabel myBaseKeymapLabel;
    private ActionsTree myActionsTree;
    private FilterComponent myFilterComponent;
    private JBPopup myPopup = null;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private boolean myQuickListsModified = false;
    private JButton myExportButton;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();

    public KeymapPanel() {
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add((Component)this.createKeymapListPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$1", "propertyChange"));
                }
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.processCurrentKeymapChanged(KeymapPanel.this.getCurrentQuickListIds());
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
    }

    @Override
    public void quickListRenamed(QuickList oldQuickList, QuickList newQuickList) {
        for (Keymap keymap : this.getAllKeymaps()) {
            KeymapImpl impl = (KeymapImpl)keymap;
            String actionId = oldQuickList.getActionId();
            String newActionId = newQuickList.getActionId();
            Shortcut[] shortcuts = impl.getShortcuts(actionId);
            if (shortcuts == null) continue;
            for (Shortcut shortcut : shortcuts) {
                impl.removeShortcut(actionId, shortcut);
                impl.addShortcut(newActionId, shortcut);
            }
        }
        this.myQuickListsModified = true;
    }

    private JPanel createKeymapListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.myKeymapList = new ComboBox((ComboBoxModel)this.myKeymapListModel);
        this.myKeymapList.setEditor((ComboBoxEditor)((Object)new MyEditor()));
        this.myKeymapList.setRenderer(new MyKeymapRenderer());
        JLabel keymapLabel = new JLabel(KeyMapBundle.message((String)"keymaps.border.factory.title", (Object[])new Object[0]));
        keymapLabel.setLabelFor(this.myKeymapList);
        panel.add((Component)keymapLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myKeymapList, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.createKeymapButtonsPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myKeymapList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "actionPerformed"));
                }
                if (KeymapPanel.this.myKeymapListModel.getSelectedItem() != KeymapPanel.this.mySelectedKeymap) {
                    KeymapPanel.this.processCurrentKeymapChanged(KeymapPanel.this.getCurrentQuickListIds());
                }
            }
        });
        panel.add((Component)this.createKeymapNamePanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                KeymapPanel.this.showOption(option);
            }
        };
    }

    @Override
    public void processCurrentKeymapChanged(QuickList[] ids) {
        KeymapImpl selectedKeymap;
        this.myQuickLists = ids;
        this.myCopyButton.setEnabled(false);
        this.myDeleteButton.setEnabled(false);
        this.myResetToDefault.setEnabled(false);
        if (this.myExportButton != null) {
            this.myExportButton.setEnabled(false);
        }
        this.mySelectedKeymap = selectedKeymap = this.getSelectedKeymap();
        if (selectedKeymap == null) {
            this.myActionsTree.reset(new KeymapImpl(), this.getCurrentQuickListIds());
            return;
        }
        this.myKeymapList.setEditable(this.mySelectedKeymap.canModify());
        this.myCopyButton.setEnabled(true);
        this.myBaseKeymapLabel.setText("");
        Keymap parent = this.mySelectedKeymap.getParent();
        if (parent != null && this.mySelectedKeymap.canModify()) {
            this.myBaseKeymapLabel.setText(KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{parent.getPresentableName()}));
            if (this.mySelectedKeymap.canModify() && this.mySelectedKeymap.getOwnActionIds().length > 0) {
                this.myResetToDefault.setEnabled(true);
            }
        }
        if (this.mySelectedKeymap.canModify()) {
            this.myDeleteButton.setEnabled(true);
            if (this.myExportButton != null) {
                this.myExportButton.setEnabled(true);
            }
        }
        this.myActionsTree.reset(this.mySelectedKeymap, this.getCurrentQuickListIds());
    }

    private KeymapImpl getSelectedKeymap() {
        return (KeymapImpl)((Object)this.myKeymapList.getSelectedItem());
    }

    List<Keymap> getAllKeymaps() {
        ComboBoxModel model = this.myKeymapList.getModel();
        ArrayList<Keymap> result = new ArrayList<Keymap>();
        for (int i = 0; i < model.getSize(); ++i) {
            result.add((Keymap)model.getElementAt(i));
        }
        return result;
    }

    private JPanel createKeymapButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        panel.setLayout(new GridBagLayout());
        this.myCopyButton = new JButton(new AbstractAction(KeyMapBundle.message((String)"copy.keymap.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.copyKeymap();
            }
        });
        Insets insets = new Insets(2, 2, 2, 2);
        this.myCopyButton.setMargin(insets);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        panel.add((Component)this.myCopyButton, gc);
        this.myResetToDefault = new JButton(CommonBundle.message((String)"button.reset", (Object[])new Object[0]));
        this.myResetToDefault.setMargin(insets);
        panel.add((Component)this.myResetToDefault, gc);
        this.myDeleteButton = new JButton(new AbstractAction(KeyMapBundle.message((String)"delete.keymap.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.deleteKeymap();
            }
        });
        this.myDeleteButton.setMargin(insets);
        gc.weightx = 1.0;
        panel.add((Component)this.myDeleteButton, gc);
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            String displayLanguage = ideFrame.getComponent().getInputContext().getLocale().getDisplayLanguage();
            this.myNonEnglishKeyboardSupportOption = new JCheckBox(new AbstractAction(displayLanguage + " " + KeyMapBundle.message((String)"use.non.english.keyboard.layout.support", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(KeymapPanel.this.myNonEnglishKeyboardSupportOption.isSelected());
                }
            });
            this.myNonEnglishKeyboardSupportOption.setSelected(KeyboardSettingsExternalizable.getInstance().isNonEnglishKeyboardSupportEnabled());
            panel.add((Component)this.myNonEnglishKeyboardSupportOption, gc);
        }
        this.myResetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$7", "actionPerformed"));
                }
                KeymapPanel.this.resetKeymap();
            }
        });
        return panel;
    }

    private static SchemesManager<Keymap, KeymapImpl> getSchemesManager() {
        return ((KeymapManagerEx)KeymapManager.getInstance()).getSchemesManager();
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.myActionsTree = new ActionsTree();
        panel.add((Component)this.createToolbarPanel(), "North");
        panel.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                KeymapPanel.this.editSelection(e);
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$9", "mousePressed"));
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$9", "mouseReleased"));
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e);
                    e.consume();
                }
            }
        });
        return panel;
    }

    private JPanel createToolbarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)KeymapPanel.this.myActionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(new AnAction("Edit Shortcut", "Edit Shortcut", AllIcons.ToolbarDecorator.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$11", "update"));
                }
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$11", "actionPerformed"));
                }
                KeymapPanel.this.editSelection(e.getInputEvent());
            }
        });
        panel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        group = new DefaultActionGroup();
        final JComponent searchToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                            return;
                        }
                        KeymapPanel.this.myTreeExpansionMonitor.freeze();
                        String filter = this.getFilter();
                        KeymapPanel.this.myActionsTree.filter(filter, KeymapPanel.this.getCurrentQuickListIds());
                        JTree tree = KeymapPanel.this.myActionsTree.getTree();
                        TreeUtil.expandAll((JTree)tree);
                        if (filter == null || filter.length() == 0) {
                            TreeUtil.collapseAll((JTree)tree, (int)0);
                            KeymapPanel.this.myTreeExpansionMonitor.restore();
                        } else {
                            KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                        }
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$13", "actionPerformed"));
                }
                KeymapPanel.this.myFilterComponent.reset();
                if (KeymapPanel.this.myPopup == null || KeymapPanel.this.myPopup.getContent() == null) {
                    KeymapPanel.this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)KeymapPanel.this.createFilteringPanel(), null).setRequestFocus(true).setTitle(KeyMapBundle.message((String)"filter.settings.popup.title", (Object[])new Object[0])).setCancelKeyEnabled(false).setMovable(true).createPopup();
                }
                KeymapPanel.this.myPopup.showUnderneathOf((Component)searchToolbar);
            }
        });
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$14", "actionPerformed"));
                }
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.getCurrentQuickListIds());
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }
        });
        panel.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createKeymapNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myBaseKeymapLabel = new JLabel(KeyMapBundle.message((String)"parent.keymap.label", (Object[])new Object[0]));
        panel.add((Component)this.myBaseKeymapLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createFilteringPanel() {
        this.myActionsTree.reset(this.getSelectedKeymap(), this.getCurrentQuickListIds());
        JLabel firstLabel = new JLabel(KeyMapBundle.message((String)"filter.first.stroke.input", (Object[])new Object[0]));
        final JCheckBox enable2Shortcut = new JCheckBox(KeyMapBundle.message((String)"filter.second.stroke.input", (Object[])new Object[0]));
        final ShortcutTextField firstShortcut = new ShortcutTextField();
        final ShortcutTextField secondShortcut = new ShortcutTextField();
        enable2Shortcut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$15", "actionPerformed"));
                }
                secondShortcut.setEnabled(enable2Shortcut.isSelected());
                if (enable2Shortcut.isSelected()) {
                    secondShortcut.requestFocusInWindow();
                }
            }
        });
        firstShortcut.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                KeymapPanel.this.filterTreeByShortcut(firstShortcut, enable2Shortcut, secondShortcut);
            }
        });
        secondShortcut.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                KeymapPanel.this.filterTreeByShortcut(firstShortcut, enable2Shortcut, secondShortcut);
            }
        });
        IJSwingUtilities.adjustComponentsOnMac(firstLabel, firstShortcut);
        JPanel filterComponent = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)firstLabel, (JComponent)firstShortcut, true).addComponent((JComponent)enable2Shortcut).setVerticalGap(0).setIndent(5).addComponent((JComponent)secondShortcut).getPanel();
        filterComponent.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        enable2Shortcut.setSelected(false);
        secondShortcut.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                firstShortcut.requestFocus();
            }
        });
        return filterComponent;
    }

    private void filterTreeByShortcut(ShortcutTextField firstShortcut, JCheckBox enable2Shortcut, ShortcutTextField secondShortcut) {
        KeyStroke keyStroke = firstShortcut.getKeyStroke();
        if (keyStroke != null) {
            this.myTreeExpansionMonitor.freeze();
            this.myActionsTree.filterTree(new KeyboardShortcut(keyStroke, enable2Shortcut.isSelected() ? secondShortcut.getKeyStroke() : null), this.getCurrentQuickListIds());
            JTree tree = this.myActionsTree.getTree();
            TreeUtil.expandAll((JTree)tree);
            this.myTreeExpansionMonitor.restore();
        }
    }

    public void showOption(String option) {
        this.createFilteringPanel();
        this.myFilterComponent.setFilter(option);
        this.myActionsTree.filter(option, this.getCurrentQuickListIds());
    }

    private void addKeyboardShortcut(Shortcut shortcut) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        if (!this.createKeymapCopyIfNeeded()) {
            return;
        }
        KeyboardShortcutDialog dialog = new KeyboardShortcutDialog(this, actionId, this.getCurrentQuickListIds());
        KeyboardShortcut selectedKeyboardShortcut = shortcut instanceof KeyboardShortcut ? (KeyboardShortcut)shortcut : null;
        dialog.setData(this.mySelectedKeymap, selectedKeyboardShortcut);
        if (!dialog.showAndGet()) {
            return;
        }
        KeyboardShortcut keyboardShortcut = dialog.getKeyboardShortcut();
        if (keyboardShortcut == null) {
            return;
        }
        HashMap<String, ArrayList<KeyboardShortcut>> conflicts = this.mySelectedKeymap.getConflicts(actionId, keyboardShortcut);
        if (conflicts.size() > 0) {
            int result = Messages.showYesNoCancelDialog((Component)this, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (result == 0) {
                for (String id : conflicts.keySet()) {
                    for (Shortcut s : (ArrayList)conflicts.get((Object)id)) {
                        this.mySelectedKeymap.removeShortcut(id, s);
                    }
                }
            } else if (result != 1) {
                return;
            }
        }
        Shortcut[] shortcuts = this.mySelectedKeymap.getShortcuts(actionId);
        for (Shortcut s : shortcuts) {
            if (!s.equals(keyboardShortcut)) continue;
            return;
        }
        this.mySelectedKeymap.addShortcut(actionId, (Shortcut)keyboardShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)keyboardShortcut);
        }
        this.repaintLists();
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
    }

    private QuickList[] getCurrentQuickListIds() {
        return this.myQuickLists;
    }

    private void addMouseShortcut(Shortcut shortcut, ShortcutRestrictions restrictions) {
        Shortcut[] shortcuts;
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        if (!this.createKeymapCopyIfNeeded()) {
            return;
        }
        MouseShortcut mouseShortcut = shortcut instanceof MouseShortcut ? (MouseShortcut)shortcut : null;
        MouseShortcutDialog dialog = new MouseShortcutDialog(this, mouseShortcut, this.mySelectedKeymap, actionId, this.myActionsTree.getMainGroup(), restrictions);
        if (!dialog.showAndGet()) {
            return;
        }
        mouseShortcut = dialog.getMouseShortcut();
        if (mouseShortcut == null) {
            return;
        }
        String[] actionIds = this.mySelectedKeymap.getActionIds(mouseShortcut);
        if (actionIds.length > 1 || actionIds.length == 1 && !actionId.equals(actionIds[0])) {
            int result = Messages.showYesNoCancelDialog((Component)this, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (result == 0) {
                for (String string : actionIds) {
                    this.mySelectedKeymap.removeShortcut(string, (Shortcut)mouseShortcut);
                }
            } else if (result != 1) {
                return;
            }
        }
        for (Shortcut shortcut2 : shortcuts = this.mySelectedKeymap.getShortcuts(actionId)) {
            if (!shortcut2.equals(mouseShortcut)) continue;
            return;
        }
        this.mySelectedKeymap.addShortcut(actionId, (Shortcut)mouseShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)mouseShortcut);
        }
        this.repaintLists();
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    private boolean createKeymapCopyIfNeeded() {
        if (this.mySelectedKeymap.canModify()) {
            return true;
        }
        KeymapImpl selectedKeymap = this.getSelectedKeymap();
        if (selectedKeymap == null) {
            return false;
        }
        KeymapImpl newKeymap = selectedKeymap.deriveKeymap();
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{selectedKeymap.getPresentableName()});
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{selectedKeymap.getPresentableName(), i}))) {
                ++i;
            }
        }
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        int indexOf = this.myKeymapListModel.getIndexOf((Object)selectedKeymap);
        if (indexOf >= 0) {
            this.myKeymapListModel.insertElementAt(newKeymap, indexOf + 1);
        } else {
            this.myKeymapListModel.addElement(newKeymap);
        }
        this.myKeymapList.setSelectedItem((Object)newKeymap);
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
        return true;
    }

    private void removeShortcut(Shortcut shortcut) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        if (!this.createKeymapCopyIfNeeded()) {
            return;
        }
        if (shortcut == null) {
            return;
        }
        this.mySelectedKeymap.removeShortcut(actionId, shortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
        }
        this.repaintLists();
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
    }

    private void copyKeymap() {
        KeymapImpl keymap = this.getSelectedKeymap();
        if (keymap == null) {
            return;
        }
        KeymapImpl newKeymap = keymap.deriveKeymap();
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap.getPresentableName(), i}))) {
                ++i;
            }
        }
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        this.myKeymapListModel.addElement(newKeymap);
        this.myKeymapList.setSelectedItem((Object)newKeymap);
        this.myKeymapList.getEditor().selectAll();
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
    }

    private boolean tryNewKeymapName(String name) {
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap k = (Keymap)this.myKeymapListModel.getElementAt(i);
            if (!name.equals(k.getPresentableName())) continue;
            return false;
        }
        return true;
    }

    private void deleteKeymap() {
        KeymapImpl keymap = this.getSelectedKeymap();
        if (keymap == null) {
            return;
        }
        int result = Messages.showYesNoDialog((Component)this, (String)KeyMapBundle.message((String)"delete.keymap.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"delete.keymap.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        if (result != 0) {
            return;
        }
        this.myKeymapListModel.removeElement(this.myKeymapList.getSelectedItem());
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
    }

    private void resetKeymap() {
        KeymapImpl keymap = this.getSelectedKeymap();
        if (keymap == null) {
            return;
        }
        keymap.clearOwnActionsIds();
        this.processCurrentKeymapChanged(this.getCurrentQuickListIds());
    }

    @NotNull
    public String getId() {
        if ("preferences.keymap" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapPanel", "getId"));
        }
        return "preferences.keymap";
    }

    public void reset() {
        if (this.myNonEnglishKeyboardSupportOption != null) {
            KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(false);
            this.myNonEnglishKeyboardSupportOption.setSelected(KeyboardSettingsExternalizable.getInstance().isNonEnglishKeyboardSupportEnabled());
        }
        this.myKeymapListModel.removeAllElements();
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        for (Keymap keymap1 : keymapManager.getAllKeymaps()) {
            if (SystemInfo.isMac && "$default".equals(keymap1.getName())) continue;
            KeymapImpl keymap = (KeymapImpl)keymap1;
            if (keymap.canModify()) {
                keymap = keymap.copy();
            }
            this.myKeymapListModel.addElement(keymap);
            if (!Comparing.equal((Object)keymapManager.getActiveKeymap(), (Object)keymap1)) continue;
            this.mySelectedKeymap = keymap;
        }
        if (this.myKeymapListModel.getSize() == 0) {
            KeymapImpl keymap = new KeymapImpl();
            keymap.setName(KeyMapBundle.message((String)"keymap.no.name", (Object[])new Object[0]));
            this.myKeymapListModel.addElement(keymap);
        }
        this.myKeymapList.setSelectedItem((Object)this.mySelectedKeymap);
        this.myActionsTree.reset(this.mySelectedKeymap, this.getCurrentQuickListIds());
    }

    public void apply() throws ConfigurationException {
        this.ensureNonEmptyKeymapNames();
        this.ensureUniqueKeymapNames();
        KeymapManagerImpl keymapManager = (KeymapManagerImpl)KeymapManager.getInstance();
        ArrayList<Keymap> keymaps = new ArrayList<Keymap>();
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap modelKeymap = (Keymap)this.myKeymapListModel.getElementAt(i);
            if (!modelKeymap.canModify()) continue;
            keymaps.add(((KeymapImpl)modelKeymap).copy());
        }
        keymapManager.setKeymaps(keymaps);
        keymapManager.setActiveKeymap(this.mySelectedKeymap);
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    private void ensureNonEmptyKeymapNames() throws ConfigurationException {
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap modelKeymap = (Keymap)this.myKeymapListModel.getElementAt(i);
            if (!StringUtil.isEmptyOrSpaces((String)modelKeymap.getName())) continue;
            throw new ConfigurationException(KeyMapBundle.message((String)"configuration.all.keymaps.should.have.non.empty.names.error.message", (Object[])new Object[0]));
        }
    }

    private void ensureUniqueKeymapNames() throws ConfigurationException {
        HashSet<String> keymapNames = new HashSet<String>();
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap modelKeymap = (Keymap)this.myKeymapListModel.getElementAt(i);
            String name = modelKeymap.getName();
            if (keymapNames.contains(name)) {
                throw new ConfigurationException(KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]));
            }
            keymapNames.add(name);
        }
    }

    public boolean isModified() {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        if (!Comparing.equal((Object)((Object)this.mySelectedKeymap), (Object)keymapManager.getActiveKeymap())) {
            return true;
        }
        Object[] managerKeymaps = ContainerUtil.filter((Object[])keymapManager.getAllKeymaps(), (Condition)new Condition<Keymap>(){

            public boolean value(Keymap keymap) {
                return !SystemInfo.isMac || !"$default".equals(keymap.getName());
            }
        }).toArray(new Keymap[0]);
        Object[] panelKeymaps = new Keymap[this.myKeymapListModel.getSize()];
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            panelKeymaps[i] = (Keymap)this.myKeymapListModel.getElementAt(i);
        }
        return !Comparing.equal((Object[])managerKeymaps, (Object[])panelKeymaps);
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public Shortcut[] getCurrentShortcuts(String actionId) {
        return this.mySelectedKeymap == null ? null : this.mySelectedKeymap.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e) {
        final String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        final Shortcut[] shortcuts = this.getCurrentShortcuts(actionId);
        Set abbreviations = AbbreviationManager.getInstance().getAbbreviations(actionId);
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Keyboard Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$20", "actionPerformed"));
                    }
                    Shortcut firstKeyboard = null;
                    assert (shortcuts != null);
                    for (Shortcut shortcut : shortcuts) {
                        if (!(shortcut instanceof KeyboardShortcut)) continue;
                        firstKeyboard = shortcut;
                        break;
                    }
                    KeymapPanel.this.addKeyboardShortcut(firstKeyboard);
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Mouse Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$21", "actionPerformed"));
                    }
                    Shortcut firstMouse = null;
                    for (Shortcut shortcut : shortcuts) {
                        if (!(shortcut instanceof MouseShortcut)) continue;
                        firstMouse = shortcut;
                        break;
                    }
                    KeymapPanel.this.addMouseShortcut(firstMouse, restrictions);
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add((AnAction)new DumbAwareAction("Add Abbreviation"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$22", "actionPerformed"));
                    }
                    String abbr = Messages.showInputDialog((String)"Enter new abbreviation:", (String)"Abbreviation", null);
                    if (abbr != null) {
                        String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                        AbbreviationManager.getInstance().register(abbr, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$22", "update"));
                    }
                    boolean enabled = KeymapPanel.this.myActionsTree.getSelectedActionId() != null;
                    e.getPresentation().setEnabledAndVisible(enabled);
                }
            });
        }
        group.addSeparator();
        for (final Shortcut shortcut : shortcuts) {
            group.add((AnAction)new DumbAwareAction("Remove " + KeymapUtil.getShortcutText((Shortcut)shortcut)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$23", "actionPerformed"));
                    }
                    KeymapPanel.this.removeShortcut(shortcut);
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (final String abbreviation : abbreviations) {
                group.addAction((AnAction)new DumbAwareAction("Remove Abbreviation '" + abbreviation + "'"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$24", "actionPerformed"));
                        }
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$24", "update"));
                        }
                        super.update(e);
                    }
                });
            }
        }
        group.add((AnAction)new Separator());
        group.add((AnAction)new DumbAwareAction("Reset Shortcuts"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$25", "actionPerformed"));
                }
                KeymapPanel.this.mySelectedKeymap.clearOwnActionsId(actionId);
                KeymapPanel.this.processCurrentKeymapChanged(KeymapPanel.this.getCurrentQuickListIds());
                KeymapPanel.this.repaintLists();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$25", "update"));
                }
                e.getPresentation().setVisible(KeymapPanel.this.mySelectedKeymap.canModify() && KeymapPanel.this.mySelectedKeymap.hasOwnActionId(actionId));
                super.update(e);
            }
        });
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
            popupMenu.getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Edit Shortcuts", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        }
    }

    private static class MyEditor
    extends FixedComboBoxEditor {
        private KeymapImpl myKeymap = null;

        public MyEditor() {
            this.getField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (MyEditor.this.myKeymap != null && MyEditor.this.myKeymap.canModify()) {
                        MyEditor.this.myKeymap.setName(MyEditor.this.getField().getText());
                    }
                }
            });
        }

        public void setItem(Object anObject) {
            if (anObject instanceof KeymapImpl) {
                this.myKeymap = (KeymapImpl)((Object)anObject);
                this.getField().setText(this.myKeymap.getPresentableName());
            }
        }

        public Object getItem() {
            return this.myKeymap;
        }
    }

    private static final class MyKeymapRenderer
    extends ListCellRendererWrapper<Keymap> {
        public void customize(JList list, Keymap keymap, int index, boolean selected, boolean hasFocus) {
            if (keymap != null) {
                String name = keymap.getPresentableName();
                if (name == null) {
                    name = KeyMapBundle.message((String)"keymap.noname.presentable.name", (Object[])new Object[0]);
                }
                this.setText(name);
            }
        }
    }
}

