/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    private ProgressIndicatorUtils() {
    }

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable builder) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, builder);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        return progressIndicator;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task);
    }

    public static void scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (readTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
    }

    public static boolean runWithWriteActionPriority(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        return ProgressIndicatorUtils.runWithWriteActionPriority(action, new ProgressIndicatorBase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWithWriteActionPriority(final @NotNull Runnable action, final @NotNull ProgressIndicator progressIndicator) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        final ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (application.isWriteActionPending()) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        final ApplicationAdapter listener = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                if (!progressIndicator.isCanceled()) {
                    progressIndicator.cancel();
                }
            }
        };
        boolean succeededWithAddingListener = application.tryRunReadAction(new Runnable(){

            @Override
            public void run() {
                application.addApplicationListener((ApplicationListener)listener);
            }
        });
        if (!succeededWithAddingListener) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        final Ref wasCancelled = new Ref();
        try {
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.run();
                    }
                    catch (ProcessCanceledException ignore) {
                        wasCancelled.set((Object)Boolean.TRUE);
                    }
                }
            }, progressIndicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)listener);
        }
        return wasCancelled.get() != Boolean.TRUE;
    }

    public static void scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, final @NotNull Executor executor, final @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (readTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        final Application application = ApplicationManager.getApplication();
        EdtInvocationManager.getInstance().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (application.isDisposed()) {
                    return;
                }
                application.assertIsDispatchThread();
                final ApplicationAdapter listener = new ApplicationAdapter(){

                    public void beforeWriteActionStart(Object action) {
                        if (!progressIndicator.isCanceled()) {
                            progressIndicator.cancel();
                            readTask.onCanceled(progressIndicator);
                        }
                    }
                };
                application.addApplicationListener((ApplicationListener)listener);
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                            }
                            finally {
                                application.removeApplicationListener((ApplicationListener)listener);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    application.removeApplicationListener((ApplicationListener)listener);
                    throw e;
                }
                catch (Error e) {
                    application.removeApplicationListener((ApplicationListener)listener);
                    throw e;
                }
            }
        });
    }

    private static void runUnderProgress(final @NotNull ProgressIndicator progressIndicator, final @NotNull ReadTask task) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runUnderProgress"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runUnderProgress"));
        }
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            task.computeInReadAction(progressIndicator);
                        }
                    });
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        }, progressIndicator);
    }
}

