/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchMergeRequestFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.ApplyPatchAction");

    public void actionPerformed(AnActionEvent e) {
        VirtualFile vFile;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        if (e.getPlace().equals("ProjectViewPopup") && (vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && vFile.getFileType() == StdFileTypes.PATCH) {
            ApplyPatchAction.showApplyPatch(project, vFile);
            return;
        }
        ApplyPatchAction.showApplyPatch(project, null);
    }

    public static void showApplyPatch(final Project project, VirtualFile file) {
        FileDocumentManager.getInstance().saveAllDocuments();
        if (file != null) {
            ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, file);
            dialog.show();
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            final VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect, (Consumer)new Consumer<List<VirtualFile>>(){

                public void consume(List<VirtualFile> files) {
                    if (files.size() != 1) {
                        return;
                    }
                    VirtualFile parent = files.get(0).getParent();
                    if (parent != null) {
                        settings.PATCH_STORAGE_LOCATION = FileUtil.toSystemDependentName((String)parent.getPath());
                    }
                    new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, files.get(0)).show();
                }
            });
        }
    }

    public static void applySkipDirs(List<FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch patch : patches) {
            patch.setBeforeName(ApplyPatchAction.skipN(patch.getBeforeName(), skipDirs));
            patch.setAfterName(ApplyPatchAction.skipN(patch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path, int num) {
        String[] pieces = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    public static <T extends FilePatch> ApplyPatchStatus applyOnly(final Project project, final ApplyFilePatchBase<T> patch, final ApplyPatchContext context, final VirtualFile file, final CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus status;
        final T patchBase = patch.getPatch();
        Application application = ApplicationManager.getApplication();
        ApplyFilePatch.Result result = (ApplyFilePatch.Result)application.runWriteAction((Computable)new Computable<ApplyFilePatch.Result>(){

            public ApplyFilePatch.Result compute() {
                try {
                    return patch.apply(file, context, project, VcsUtil.getFilePath((VirtualFile)file), new Getter<CharSequence>(){

                        public CharSequence get() {
                            return ApplyPatchAction.getBaseContents((FilePatch)((TextFilePatch)patchBase), commitContext, project);
                        }
                    }, commitContext);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return ApplyFilePatch.Result.createThrow(e);
                }
            }
        });
        try {
            status = result.getStatus();
        }
        catch (IOException e) {
            ApplyPatchAction.showIOException(project, patchBase.getBeforeName(), e);
            return ApplyPatchStatus.FAILURE;
        }
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)status) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            return status;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result.getMergeData();
        if (mergeData != null) {
            if (mergeData.getBase() != null) {
                return ApplyPatchAction.showMergeDialog(project, file, mergeData.getBase(), mergeData.getPatched(), ApplyPatchMergeRequestFactory.INSTANCE, reverse, leftPanelTitle, rightPanelTitle);
            }
            try {
                return ApplyPatchAction.showBadDiffDialog(project, file, mergeData, false);
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new Runnable((FilePatch)patchBase, e){
                    final /* synthetic */ FilePatch val$patchBase;
                    final /* synthetic */ IOException val$e;
                    {
                        this.val$patchBase = filePatch;
                        this.val$e = iOException;
                    }

                    @Override
                    public void run() {
                        ApplyPatchAction.showIOException(project, this.val$patchBase.getBeforeName(), this.val$e);
                    }
                });
                return ApplyPatchStatus.FAILURE;
            }
        }
        return status;
    }

    private static <T extends FilePatch> void showIOException(Project project, String name, IOException e) {
        Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"patch.apply.error", (Object[])new Object[]{name, e.getMessage()}), (String)VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
    }

    @Nullable
    private static CharSequence getBaseContents(FilePatch patchBase, CommitContext commitContext, Project project) {
        BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class);
        if (baseRevisionTextPatchEP != null) {
            String path = patchBase.getBeforeName() == null ? patchBase.getAfterName() : patchBase.getBeforeName();
            return baseRevisionTextPatchEP.provideContent(path, commitContext);
        }
        return null;
    }

    public static ApplyPatchStatus showBadDiffDialog(Project project, VirtualFile file, ApplyPatchForBaseRevisionTexts texts, boolean readonly) throws IOException {
        if (texts.getLocal() == null) {
            return ApplyPatchStatus.FAILURE;
        }
        DiffTool tool = DiffManager.getInstance().getDiffTool();
        SimpleDiffRequest simpleRequest = ApplyPatchAction.createBadDiffRequest(project, file, texts, readonly);
        tool.show((DiffRequest)simpleRequest);
        return ApplyPatchStatus.SUCCESS;
    }

    public static SimpleDiffRequest createBadDiffRequest(final Project project, final VirtualFile file, ApplyPatchForBaseRevisionTexts texts, boolean readonly) {
        SimpleDiffRequest simpleRequest = new SimpleDiffRequest(project, "Result Of Patch Apply To " + file.getName() + " (" + (file.getParent() == null ? file.getPath() : file.getParent().getPath()) + ")");
        DocumentImpl patched = new DocumentImpl(texts.getPatched());
        patched.setReadOnly(false);
        final DocumentContent mergedDocument = new DocumentContent(project, (Document)patched, file.getFileType());
        mergedDocument.getDocument().setReadOnly(readonly);
        simpleRequest.setContents((DiffContent)new SimpleContent(texts.getLocal().toString(), file.getFileType()), (DiffContent)mergedDocument);
        simpleRequest.setContentTitles(VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]), "Patched (with problems)");
        simpleRequest.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
        simpleRequest.addHint(DiffTool.HINT_DIFF_IS_APPROXIMATE);
        if (!readonly) {
            simpleRequest.setOnOkRunnable(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            String resultText = mergedDocument.getDocument().getText();
                            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                            Document document = fileDocumentManager.getDocument(file);
                            if (document == null) {
                                try {
                                    VfsUtil.saveText((VirtualFile)file, (String)resultText);
                                }
                                catch (IOException e) {
                                    ApplyPatchAction.showIOException(project, file.getName(), e);
                                }
                            } else {
                                document.setText((CharSequence)resultText);
                                fileDocumentManager.saveDocument(document);
                            }
                        }
                    });
                }
            });
        }
        return simpleRequest;
    }

    private static ApplyPatchStatus showMergeDialog(Project project, VirtualFile file, CharSequence content, String patchedContent, PatchMergeRequestFactory mergeRequestFactory, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        CharSequence fileContent;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getDocument(file);
        if (document != null) {
            fileDocumentManager.saveDocument(document);
        }
        if ((fileContent = LoadTextUtil.loadText(file)) == null || content == null) {
            return ApplyPatchStatus.FAILURE;
        }
        MergeRequest request = mergeRequestFactory.createMergeRequest(fileContent.toString(), patchedContent, content.toString(), file, project, reverse, leftPanelTitle, rightPanelTitle);
        DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
        if (request.getResult() == 0) {
            return ApplyPatchStatus.SUCCESS;
        }
        request.restoreOriginalContent();
        return ApplyPatchStatus.FAILURE;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (e.getPlace().equals("ProjectViewPopup")) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setVisible(project != null && vFile != null && vFile.getFileType() == StdFileTypes.PATCH);
        } else {
            e.getPresentation().setEnabled(project != null);
        }
    }

    public static class ApplyPatchMergeRequestFactory
    implements PatchMergeRequestFactory {
        private final boolean myReadOnly;
        public static final ApplyPatchMergeRequestFactory INSTANCE = new ApplyPatchMergeRequestFactory(false);
        public static final ApplyPatchMergeRequestFactory INSTANCE_READ_ONLY = new ApplyPatchMergeRequestFactory(true);

        public ApplyPatchMergeRequestFactory(boolean readOnly) {
            this.myReadOnly = readOnly;
        }

        @Override
        public MergeRequest createMergeRequest(String leftText, String rightText, String originalContent, @NotNull VirtualFile file, Project project, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction$ApplyPatchMergeRequestFactory", "createMergeRequest"));
            }
            MergeRequest request = this.myReadOnly ? DiffRequestFactory.getInstance().create3WayDiffRequest(leftText, rightText, originalContent, file.getFileType(), project, null, null) : DiffRequestFactory.getInstance().createMergeRequest(reverse ? rightText : leftText, reverse ? leftText : rightText, originalContent, file, project, ActionButtonPresentation.APPLY, ActionButtonPresentation.CANCEL_WITH_PROMPT);
            request.setVersionTitles(new String[]{leftPanelTitle == null ? VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]) : leftPanelTitle, rightPanelTitle == null ? VcsBundle.message((String)"patch.apply.conflict.merged.version", (Object[])new Object[0]) : rightPanelTitle, VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0])});
            request.setWindowTitle(VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{file.getPresentableUrl()}));
            return request;
        }
    }
}

