/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ApplyPatchDefaultExecutor
implements ApplyPatchExecutor<AbstractFilePatchInProgress> {
    private final Project myProject;

    public ApplyPatchDefaultExecutor(Project project) {
        this.myProject = project;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void apply(MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups, LocalChangeList localList, String fileName, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        LinkedList<PatchApplier> appliers = new LinkedList<PatchApplier>();
        CommitContext commitContext = new CommitContext();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        for (VirtualFile base : patchGroups.keySet()) {
            PatchApplier patchApplier = new PatchApplier(this.myProject, base, ObjectsConvertor.convert(patchGroups.get((Object)base), new Convertor<AbstractFilePatchInProgress, FilePatch>(){

                public FilePatch convert(AbstractFilePatchInProgress o) {
                    return o.getPatch();
                }
            }), localList, null, commitContext);
            appliers.add(patchApplier);
        }
        PatchApplier.executePatchGroup(appliers, localList);
        ApplyPatchDefaultExecutor.applyAdditionalInfo(this.myProject, additionalInfo, commitContext);
    }

    public static void applyAdditionalInfoBefore(Project project, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, CommitContext commitContext) {
        ApplyPatchDefaultExecutor.applyAdditionalInfoImpl(project, additionalInfo, commitContext, new Consumer<InfoGroup>(){

            public void consume(InfoGroup infoGroup) {
                infoGroup.myPatchEP.consumeContentBeforePatchApplied(infoGroup.myPath, infoGroup.myContent, infoGroup.myCommitContext);
            }
        });
    }

    private static void applyAdditionalInfo(Project project, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, CommitContext commitContext) {
        ApplyPatchDefaultExecutor.applyAdditionalInfoImpl(project, additionalInfo, commitContext, new Consumer<InfoGroup>(){

            public void consume(InfoGroup infoGroup) {
                infoGroup.myPatchEP.consumeContent(infoGroup.myPath, infoGroup.myContent, infoGroup.myCommitContext);
            }
        });
    }

    public static void applyAdditionalInfoImpl(Project project, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, CommitContext commitContext, Consumer<InfoGroup> worker) {
        PatchEP[] extensions = (PatchEP[])Extensions.getExtensions((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project);
        if (extensions.length == 0) {
            return;
        }
        if (additionalInfo != null) {
            try {
                Map map = (Map)additionalInfo.get();
                for (Map.Entry entry : map.entrySet()) {
                    String path = (String)entry.getKey();
                    Map innerMap = (Map)entry.getValue();
                    for (PatchEP extension : extensions) {
                        CharSequence charSequence = (CharSequence)innerMap.get(extension.getName());
                        if (charSequence == null) continue;
                        worker.consume((Object)new InfoGroup(extension, path, charSequence, commitContext));
                    }
                }
            }
            catch (PatchSyntaxException e) {
                VcsBalloonProblemNotifier.showOverChangesView(project, "Can not apply additional patch info: " + e.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }

    public static Set<String> pathsFromGroups(MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups) {
        HashSet selectedPaths = new HashSet();
        Collection values = patchGroups.values();
        for (AbstractFilePatchInProgress value : values) {
            String path = value.getPatch().getBeforeName() == null ? value.getPatch().getAfterName() : value.getPatch().getBeforeName();
            selectedPaths.add(path);
        }
        return selectedPaths;
    }

    private static class InfoGroup {
        private PatchEP myPatchEP;
        private String myPath;
        private CharSequence myContent;
        private CommitContext myCommitContext;

        private InfoGroup(PatchEP patchEP, String path, CharSequence content, CommitContext commitContext) {
            this.myPatchEP = patchEP;
            this.myPath = path;
            this.myContent = content;
            this.myCommitContext = commitContext;
        }
    }
}

