/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.LazyPatchContentRevision;
import com.intellij.openapi.vcs.changes.patch.MergedDiffRequestPresentable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextFilePatchInProgress
extends AbstractFilePatchInProgress<TextFilePatch> {
    protected TextFilePatchInProgress(TextFilePatch patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch.pathsOnlyCopy(), autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision == null) {
            this.myConflicts = null;
            if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
                FilePath newFilePath = VcsUtil.getFilePathOnNonLocal((String)this.myIoCurrentBase.getAbsolutePath(), (boolean)false);
                String content = ((TextFilePatch)this.myPatch).getNewFileText();
                this.myNewContentRevision = new SimpleContentRevision(content, newFilePath, ((TextFilePatch)this.myPatch).getAfterVersionId());
            } else {
                FilePath newFilePath = this.detectNewFilePathForMovedOrModified();
                this.myNewContentRevision = new LazyPatchContentRevision(this.myCurrentBase, newFilePath, ((TextFilePatch)this.myPatch).getAfterVersionId(), (TextFilePatch)this.myPatch);
                if (this.myCurrentBase != null) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            ((LazyPatchContentRevision)TextFilePatchInProgress.this.myNewContentRevision).getContent();
                        }
                    });
                }
            }
        }
        return this.myNewContentRevision;
    }

    @Override
    @NotNull
    protected DiffRequestPresentable diffRequestForConflictingChanges(final @NotNull Project project, @NotNull AbstractFilePatchInProgress.PatchChange change, final @NotNull Getter<CharSequence> baseContents) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress", "diffRequestForConflictingChanges"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress", "diffRequestForConflictingChanges"));
        }
        if (baseContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseContents", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress", "diffRequestForConflictingChanges"));
        }
        Getter<ApplyPatchForBaseRevisionTexts> revisionTextsGetter = new Getter<ApplyPatchForBaseRevisionTexts>(){

            public ApplyPatchForBaseRevisionTexts get() {
                VirtualFile currentBase = TextFilePatchInProgress.this.getCurrentBase();
                return ApplyPatchForBaseRevisionTexts.create(project, currentBase, VcsUtil.getFilePath((VirtualFile)currentBase), (TextFilePatch)TextFilePatchInProgress.this.getPatch(), (Getter<CharSequence>)baseContents);
            }
        };
        MergedDiffRequestPresentable mergedDiffRequestPresentable = new MergedDiffRequestPresentable(project, revisionTextsGetter, this.getCurrentBase(), ((TextFilePatch)this.getPatch()).getAfterVersionId());
        if (mergedDiffRequestPresentable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress", "diffRequestForConflictingChanges"));
        }
        return mergedDiffRequestPresentable;
    }
}

