/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Block;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class NewLineBlocksIterator
implements Iterator<Block> {
    private final Document myDocument;
    private final int myTotalLines;
    private int myCurrentLineStartOffset;
    private int myCurrentDocumentLine;
    private Stack<Block> myStack = new Stack();

    public NewLineBlocksIterator(Block root, Document document) {
        this.myStack.add(root);
        this.myDocument = document;
        this.myTotalLines = this.myDocument.getLineCount();
        this.myCurrentDocumentLine = 0;
        this.myCurrentLineStartOffset = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.myCurrentDocumentLine < this.myTotalLines) {
            this.popUntilTopBlockStartOffsetGreaterOrEqual(this.myCurrentLineStartOffset);
            return !this.myStack.isEmpty();
        }
        return false;
    }

    @Override
    public Block next() {
        this.popUntilTopBlockStartOffsetGreaterOrEqual(this.myCurrentLineStartOffset);
        Block current = this.myStack.peek();
        TextRange currentBlockRange = current.getTextRange();
        this.myCurrentDocumentLine = this.myDocument.getLineNumber(currentBlockRange.getStartOffset());
        ++this.myCurrentDocumentLine;
        if (this.myCurrentDocumentLine < this.myTotalLines) {
            this.myCurrentLineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentDocumentLine);
            if (currentBlockRange.getEndOffset() < this.myCurrentLineStartOffset) {
                this.myStack.pop();
            } else {
                this.pushAll(current);
            }
        }
        return current;
    }

    private void popUntilTopBlockStartOffsetGreaterOrEqual(int lineStartOffset) {
        if (this.myStack.isEmpty()) {
            return;
        }
        Block current = this.myStack.peek();
        TextRange range = current.getTextRange();
        int currentStartOffset = range.getStartOffset();
        int currentEndOffset = range.getEndOffset();
        if (currentStartOffset < lineStartOffset) {
            this.myStack.pop();
            if (currentEndOffset > lineStartOffset) {
                this.pushAll(current);
            }
            this.popUntilTopBlockStartOffsetGreaterOrEqual(lineStartOffset);
        }
    }

    private void pushAll(Block current) {
        if (current instanceof AbstractBlock) {
            ((AbstractBlock)current).setBuildInjectedBlocks(false);
        }
        List blocks = current.getSubBlocks();
        ListIterator iterator = blocks.listIterator(blocks.size());
        while (iterator.hasPrevious()) {
            this.myStack.push((Block)iterator.previous());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

