/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.ChainedCallChunk;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.SyntheticBlockBuilder;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ChainMethodCallsBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myBlockWrap;
    private final Alignment myBlockAlignment;
    private final Indent myBlockIndent;
    private Wrap myWrap;
    private Alignment myChainedCallsAlignment;

    public ChainMethodCallsBlockBuilder(Alignment alignment, Wrap wrap, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        this.myBlockWrap = wrap;
        this.myBlockAlignment = alignment;
        this.myBlockIndent = indent;
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
    }

    public Block build(List<ASTNode> nodes) {
        List<Block> blocks = this.buildBlocksFrom(nodes);
        Indent indent = this.myBlockIndent != null ? this.myBlockIndent : Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        return new SyntheticCodeBlock(blocks, this.myBlockAlignment, this.mySettings, this.myJavaSettings, indent, this.myBlockWrap);
    }

    private List<Block> buildBlocksFrom(List<ASTNode> nodes) {
        List<ChainedCallChunk> methodCall = this.splitMethodCallOnChunksByDots(nodes);
        this.myWrap = null;
        this.myChainedCallsAlignment = null;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < methodCall.size(); ++i) {
            ChainedCallChunk currentCallChunk = methodCall.get(i);
            if (this.isMethodCall(currentCallChunk)) {
                if (this.myWrap == null) {
                    this.myWrap = this.createCallChunkWrap(i, methodCall);
                }
                if (this.myChainedCallsAlignment == null) {
                    this.myChainedCallsAlignment = this.createCallChunkAlignment(i, methodCall);
                }
            } else {
                this.myWrap = null;
                this.myChainedCallsAlignment = null;
            }
            SyntheticBlockBuilder builder = new SyntheticBlockBuilder(this.mySettings, this.myJavaSettings);
            blocks.add(builder.create(currentCallChunk.nodes, this.myWrap, this.myChainedCallsAlignment));
        }
        return blocks;
    }

    private Wrap createCallChunkWrap(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "createCallChunkWrap"));
        }
        if (this.mySettings.WRAP_FIRST_METHOD_IN_CALL_CHAIN) {
            ChainedCallChunk next;
            ChainedCallChunk chainedCallChunk = next = chunkIndex + 1 < methodCall.size() ? methodCall.get(chunkIndex + 1) : null;
            if (next != null && this.isMethodCall(next)) {
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)true);
            }
        }
        return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)false);
    }

    private boolean shouldAlignMethod(ChainedCallChunk currentMethodChunk, List<ChainedCallChunk> methodCall) {
        return this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && !currentMethodChunk.isEmpty() && !this.chunkIsFirstInChainMethodCall(currentMethodChunk, methodCall);
    }

    private boolean chunkIsFirstInChainMethodCall(@NotNull ChainedCallChunk callChunk, @NotNull List<ChainedCallChunk> methodCall) {
        if (callChunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callChunk", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "chunkIsFirstInChainMethodCall"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "chunkIsFirstInChainMethodCall"));
        }
        return !methodCall.isEmpty() && callChunk == methodCall.get(0);
    }

    @NotNull
    private List<ChainedCallChunk> splitMethodCallOnChunksByDots(@NotNull List<ASTNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "splitMethodCallOnChunksByDots"));
        }
        ArrayList<ChainedCallChunk> result = new ArrayList<ChainedCallChunk>();
        ArrayList<Object> current = new ArrayList<ASTNode>();
        for (ASTNode node : nodes) {
            if (node.getElementType() == JavaTokenType.DOT) {
                result.add(new ChainedCallChunk(current));
                current = new ArrayList();
            }
            current.add(node);
        }
        result.add(new ChainedCallChunk(current));
        ArrayList<ChainedCallChunk> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "splitMethodCallOnChunksByDots"));
        }
        return arrayList;
    }

    private Alignment createCallChunkAlignment(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "createCallChunkAlignment"));
        }
        ChainedCallChunk current = methodCall.get(chunkIndex);
        return this.shouldAlignMethod(current, methodCall) ? AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS, null) : null;
    }

    private boolean isMethodCall(@NotNull ChainedCallChunk callChunk) {
        if (callChunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callChunk", "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder", "isMethodCall"));
        }
        List<ASTNode> nodes = callChunk.nodes;
        return !nodes.isEmpty() && nodes.get(nodes.size() - 1).getElementType() == JavaElementType.EXPRESSION_LIST;
    }
}

