/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;

    public SyntheticBlockBuilder(@NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "<init>"));
        }
        if (javaSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSettings", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "<init>"));
        }
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
    }

    @NotNull
    public Block create(@NotNull List<ASTNode> subNodes, Wrap wrap, @Nullable Alignment alignment) {
        if (subNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subNodes", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "create"));
        }
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode firstNode = subNodes.get(0);
        if (firstNode.getElementType() == JavaTokenType.DOT) {
            AlignmentStrategy strategy = AlignmentStrategy.getNullStrategy();
            Block block = AbstractJavaBlock.newJavaBlock(firstNode, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, strategy);
            subBlocks.add(block);
            subNodes.remove(0);
            if (!subNodes.isEmpty()) {
                subBlocks.add(this.create(subNodes, wrap, null));
            }
            SyntheticCodeBlock syntheticCodeBlock = new SyntheticCodeBlock(subBlocks, alignment, this.mySettings, this.myJavaSettings, Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), wrap);
            if (syntheticCodeBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "create"));
            }
            return syntheticCodeBlock;
        }
        SyntheticCodeBlock syntheticCodeBlock = new SyntheticCodeBlock(this.createJavaBlocks(subNodes), alignment, this.mySettings, this.myJavaSettings, Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), null);
        if (syntheticCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "create"));
        }
        return syntheticCodeBlock;
    }

    @NotNull
    private List<Block> createJavaBlocks(@NotNull List<ASTNode> subNodes) {
        if (subNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subNodes", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "createJavaBlocks"));
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode node : subNodes) {
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
            result.add(AbstractJavaBlock.newJavaBlock(node, this.mySettings, this.myJavaSettings, indent, null, AlignmentStrategy.getNullStrategy()));
        }
        ArrayList<Block> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticBlockBuilder", "createJavaBlocks"));
        }
        return arrayList;
    }
}

