/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, final @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        final PsiClass psiClass = p.getPsiClass();
        final MultiMap methods = (MultiMap)ApplicationManager.getApplication().runReadAction((Computable)new Computable<MultiMap<String, PsiMethod>>(){

            public MultiMap<String, PsiMethod> compute() {
                MultiMap methods = MultiMap.create();
                for (PsiMethod method : psiClass.getMethods()) {
                    if (!PsiUtil.canBeOverriden((PsiMethod)method)) continue;
                    methods.putValue((Object)method.getName(), (Object)method);
                }
                return methods;
            }
        });
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                PsiSubstitutor substitutor = null;
                for (String name : methods.keySet()) {
                    if (inheritor.findMethodsByName(name, false).length == 0) continue;
                    for (PsiMethod method : methods.get((Object)name)) {
                        PsiClass superClass;
                        if (method.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)inheritor.getProject()).arePackagesTheSame((PsiElement)psiClass, (PsiElement)inheritor)) continue;
                        if (substitutor == null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY)) == null) {
                            return true;
                        }
                        MethodSignature signature = method.getSignature(substitutor);
                        PsiMethod inInheritor = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)signature, (boolean)false);
                        if (inInheritor != null && !inInheritor.hasModifierProperty("static") && !consumer.process((Object)Pair.create((Object)method, (Object)inInheritor))) {
                            return false;
                        }
                        if (!psiClass.isInterface() || inheritor.isInterface() || (superClass = inheritor.getSuperClass()) == null || superClass.isInheritor(psiClass, true) || (inInheritor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)signature, (boolean)true)) == null || inInheritor.hasModifierProperty("static") || consumer.process((Object)Pair.create((Object)method, (Object)inInheritor))) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)scope, (boolean)true).forEach((Processor)inheritorsProcessor);
    }
}

