/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.resolve;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodResolveHelper {
    private final Set<MethodSignature> myDuplicates;
    private final MethodCandidatesProcessor myProcessor;
    @Nullable
    private final PsiType[] myArgumentTypes;

    public JavaMethodResolveHelper(final @NotNull PsiElement argumentList, PsiFile containingFile, final @Nullable PsiType[] argumentTypes) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/psi/resolve/JavaMethodResolveHelper", "<init>"));
        }
        this.myDuplicates = new THashSet();
        this.myArgumentTypes = argumentTypes;
        final LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)argumentList);
        PsiConflictResolver resolver = argumentTypes == null ? DuplicateConflictResolver.INSTANCE : new JavaMethodsConflictResolver(argumentList, argumentTypes, languageLevel);
        this.myProcessor = new MethodResolverProcessor(argumentList, containingFile, new PsiConflictResolver[]{resolver}){

            @Override
            protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, boolean varargs) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/resolve/JavaMethodResolveHelper$1", "createCandidateInfo"));
                }
                if (substitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/resolve/JavaMethodResolveHelper$1", "createCandidateInfo"));
                }
                return JavaMethodResolveHelper.this.createCandidateInfo(method, substitutor, staticProblem, this.myCurrentFileContext, !accessible, argumentList, argumentTypes, languageLevel);
            }

            @Override
            protected boolean isAccepted(PsiMethod candidate) {
                return !candidate.isConstructor();
            }
        };
    }

    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, PsiElement currentFileContext, boolean accessProblem, PsiElement argumentList, PsiType[] argumentTypes, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/resolve/JavaMethodResolveHelper", "createCandidateInfo"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/resolve/JavaMethodResolveHelper", "createCandidateInfo"));
        }
        return new MethodCandidateInfo((PsiElement)method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, argumentTypes, PsiType.EMPTY_ARRAY, languageLevel);
    }

    public void addMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticError) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/resolve/JavaMethodResolveHelper", "addMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/resolve/JavaMethodResolveHelper", "addMethod"));
        }
        if (this.myDuplicates.add(method.getSignature(substitutor))) {
            this.myProcessor.addMethod(method, substitutor, staticError);
        }
    }

    @NotNull
    public ErrorType getResolveError() {
        List<CandidateInfo> candidates = this.getCandidates();
        if (candidates.size() != 1) {
            ErrorType errorType = ErrorType.RESOLVE;
            if (errorType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/resolve/JavaMethodResolveHelper", "getResolveError"));
            }
            return errorType;
        }
        if (!candidates.get(0).isStaticsScopeCorrect()) {
            ErrorType errorType = ErrorType.STATIC;
            if (errorType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/resolve/JavaMethodResolveHelper", "getResolveError"));
            }
            return errorType;
        }
        ErrorType errorType = this.getResolveError((MethodCandidateInfo)candidates.get(0));
        if (errorType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/resolve/JavaMethodResolveHelper", "getResolveError"));
        }
        return errorType;
    }

    protected List<CandidateInfo> getCandidates() {
        return Arrays.asList(this.myProcessor.getCandidates());
    }

    protected ErrorType getResolveError(MethodCandidateInfo info) {
        if (this.myArgumentTypes == null) {
            return ErrorType.NONE;
        }
        if (!info.isApplicable()) {
            boolean hasNulls = false;
            PsiParameter[] parameters = info.getElement().getParameterList().getParameters();
            if (this.myArgumentTypes.length == parameters.length) {
                for (int i = 0; i < this.myArgumentTypes.length; ++i) {
                    PsiType type = this.myArgumentTypes[i];
                    if (type == null) {
                        hasNulls = true;
                        continue;
                    }
                    if (parameters[i].getType().isAssignableFrom(type)) continue;
                    return ErrorType.RESOLVE;
                }
            }
            return hasNulls ? ErrorType.NONE : ErrorType.RESOLVE;
        }
        return ErrorType.NONE;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        this.myProcessor.handleEvent(event, associated);
    }

    public Collection<JavaMethodCandidateInfo> getMethods() {
        return ContainerUtil.mapNotNull(this.getCandidates(), (Function)new Function<JavaResolveResult, JavaMethodCandidateInfo>(){

            public JavaMethodCandidateInfo fun(JavaResolveResult javaResolveResult) {
                return new JavaMethodCandidateInfo((PsiMethod)javaResolveResult.getElement(), javaResolveResult.getSubstitutor());
            }
        });
    }

    public static enum ErrorType {
        NONE,
        STATIC,
        RESOLVE;

    }
}

