/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class ReassignVariableUtil {
    static final Key<SmartPsiElementPointer<PsiDeclarationStatement>> DECLARATION_KEY = Key.create((String)"var.type");
    static final Key<RangeMarker[]> OCCURRENCES_KEY = Key.create((String)"occurrences");

    private ReassignVariableUtil() {
    }

    @VisibleForTesting
    public static boolean reassign(Editor editor) {
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)editor.getUserData(DECLARATION_KEY);
        final PsiDeclarationStatement declaration = pointer != null ? (PsiDeclarationStatement)pointer.getElement() : null;
        PsiType type = ReassignVariableUtil.getVariableType(declaration);
        if (type != null) {
            VariablesProcessor proc = ReassignVariableUtil.findVariablesOfType(declaration, type);
            if (proc.size() > 0) {
                if (proc.size() == 1) {
                    ReassignVariableUtil.replaceWithAssignment(declaration, proc.getResult(0), editor);
                    return true;
                }
                DefaultListModel<PsiVariable> model = new DefaultListModel<PsiVariable>();
                for (int i = 0; i < proc.size(); ++i) {
                    model.addElement(proc.getResult(i));
                }
                JBList list = new JBList(model);
                list.setCellRenderer(new ListCellRendererWrapper(){

                    public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                        if (value instanceof PsiVariable) {
                            this.setText(((PsiVariable)value).getName());
                            this.setIcon(((PsiVariable)value).getIcon(0));
                        }
                    }
                });
                VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
                Point point = editor.visualPositionToXY(new VisualPosition(visualPosition.line + 1, visualPosition.column));
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose variable to reassign").setRequestFocus(true).setItemChoosenCallback(new Runnable((JList)list, editor){
                    final /* synthetic */ JList val$list;
                    final /* synthetic */ Editor val$editor;
                    {
                        this.val$list = jList;
                        this.val$editor = editor;
                    }

                    @Override
                    public void run() {
                        ReassignVariableUtil.replaceWithAssignment(declaration, (PsiVariable)this.val$list.getSelectedValue(), this.val$editor);
                    }
                }).createPopup().show(new RelativePoint((Component)editor.getContentComponent(), point));
            }
            return true;
        }
        return false;
    }

    @Nullable
    static PsiType getVariableType(@Nullable PsiDeclarationStatement declaration) {
        PsiElement[] declaredElements;
        if (declaration != null && (declaredElements = declaration.getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiVariable) {
            return ((PsiVariable)declaredElements[0]).getType();
        }
        return null;
    }

    static VariablesProcessor findVariablesOfType(final PsiDeclarationStatement declaration, final PsiType type) {
        PsiDeclarationStatement scope;
        VariablesProcessor proc = new VariablesProcessor(false){

            @Override
            protected boolean check(PsiVariable var, ResolveState state) {
                for (PsiElement element : declaration.getDeclaredElements()) {
                    if (element != var) continue;
                    return false;
                }
                return TypeConversionUtil.isAssignable((PsiType)var.getType(), (PsiType)type);
            }
        };
        for (scope = declaration; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiLambdaExpression || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return proc;
        }
        PsiScopesUtil.treeWalkUp(proc, (PsiElement)declaration, (PsiElement)scope);
        return proc;
    }

    static void replaceWithAssignment(final PsiDeclarationStatement declaration, final PsiVariable variable, Editor editor) {
        final PsiVariable var = (PsiVariable)declaration.getDeclaredElements()[0];
        final PsiExpression initializer = var.getInitializer();
        new WriteCommandAction(declaration.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
                String chosenVariableName = variable.getName();
                PsiStatement newDeclaration = elementFactory.createStatementFromText(chosenVariableName + " = " + initializer.getText() + ";", (PsiElement)declaration);
                Collection references = ReferencesSearch.search((PsiElement)var).findAll();
                newDeclaration = declaration.replace((PsiElement)newDeclaration);
                for (PsiReference reference : references) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof PsiExpression)) continue;
                    element.replace((PsiElement)elementFactory.createExpressionFromText(chosenVariableName, (PsiElement)newDeclaration));
                }
            }
        }.execute();
        ReassignVariableUtil.finishTemplate(editor);
    }

    private static void finishTemplate(Editor editor) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        InplaceRefactoring renamer = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
        if (templateState != null && renamer != null) {
            templateState.gotoEnd(true);
            editor.putUserData(InplaceRefactoring.INPLACE_RENAMER, null);
        }
    }
}

