/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.execution.lineMarker.RunLineMarkerInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunLineMarkerProvider
implements LineMarkerProvider {
    private static final Function<PsiElement, String> TOOLTIP_PROVIDER = new Function<PsiElement, String>(){

        public String fun(PsiElement element) {
            return "Run Test";
        }
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/testIntegration/TestRunLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (e instanceof PsiIdentifier) {
            TestFramework framework;
            PsiElement element = e.getParent();
            if (element instanceof PsiClass && (framework = TestFrameworks.detectFramework((PsiClass)((PsiClass)element))) != null && framework.isTestClass(element)) {
                return new RunLineMarkerInfo(e, framework.getIcon(), TOOLTIP_PROVIDER);
            }
            if (element instanceof PsiMethod && (framework = TestFrameworks.detectFramework((PsiClass)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)))) != null && framework.isTestMethod(element)) {
                return new RunLineMarkerInfo(e, framework.getIcon(), TOOLTIP_PROVIDER);
            }
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/testIntegration/TestRunLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testIntegration/TestRunLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }
}

