/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.ItemWrapperListRenderer;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.ui.popup.util.SplitterItem;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasterDetailPopupBuilder
implements MasterController {
    private static final Color BORDER_COLOR = Gray._135;
    private final Project myProject;
    private final DetailController myDetailController = new DetailController(this);
    private JComponent myChooserComponent;
    private Delegate myDelegate;
    private DetailView myDetailView;
    private JLabel myPathLabel;
    private JBPopup myPopup;
    private String myDimensionServiceKey = null;
    private boolean myAddDetailViewToEast = true;
    private ActionGroup myActions = null;
    private Consumer<PopupChooserBuilder> myPopupTuner = null;
    private Runnable myDoneRunnable = null;

    public MasterDetailPopupBuilder(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MasterDetailPopupBuilder setList(@NotNull JBList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setList"));
        }
        this.myChooserComponent = list;
        this.myDetailController.setList(list);
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    MasterDetailPopupBuilder.this.removeSelectedItems();
                } else if (e.getModifiersEx() == 0) {
                    MasterDetailPopupBuilder.this.myDelegate.handleMnemonic(e, MasterDetailPopupBuilder.this.myProject, MasterDetailPopupBuilder.this.myPopup);
                }
            }
        });
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                MasterDetailPopupBuilder.this.chooseItems(true);
            }
        }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)list);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                MasterDetailPopupBuilder.this.chooseItems(true);
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, (JComponent)list);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                MasterDetailPopupBuilder.this.myDetailController.updateDetailView();
            }
        });
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setList"));
        }
        return masterDetailPopupBuilder;
    }

    private void removeSelectedItems() {
        if (this.myChooserComponent instanceof JList) {
            Object[] values;
            JList list = (JList)this.myChooserComponent;
            ListModel listModel = list.getModel();
            int index = list.getSelectedIndex();
            if (index == -1 || index >= listModel.getSize()) {
                return;
            }
            for (Object value : values = list.getSelectedValues()) {
                ItemWrapper item = (ItemWrapper)value;
                if (!item.allowedToRemove()) continue;
                DefaultListModel model = listModel instanceof DefaultListModel ? (DefaultListModel)listModel : (DefaultListModel)((FilteringListModel)listModel).getOriginalModel();
                model.removeElement(item);
                if (model.getSize() > 0) {
                    if (model.getSize() == index) {
                        list.setSelectedIndex(model.getSize() - 1);
                    } else if (model.getSize() > index) {
                        list.setSelectedIndex(index);
                    }
                } else {
                    list.clearSelection();
                }
                item.removed(this.myProject);
            }
        } else {
            this.myDelegate.removeSelectedItemsInTree();
        }
    }

    private void chooseItems(boolean withEnterOrDoubleClick) {
        for (ItemWrapper item : this.getSelectedItems()) {
            if (!(item instanceof ItemWrapper)) continue;
            this.myDelegate.itemChosen(item, this.myProject, this.myPopup, withEnterOrDoubleClick);
        }
    }

    @NotNull
    public MasterDetailPopupBuilder setDelegate(@NotNull Delegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setDelegate"));
        }
        this.myDelegate = delegate;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setDelegate"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setDetailView(@NotNull DetailView detailView) {
        if (detailView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailView", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setDetailView"));
        }
        this.myDetailView = detailView;
        this.myDetailController.setDetailView(this.myDetailView);
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setDetailView"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setDimensionServiceKey"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setAddDetailViewToEast(boolean addDetailViewToEast) {
        this.myAddDetailViewToEast = addDetailViewToEast;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setAddDetailViewToEast"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setActionsGroup(@Nullable ActionGroup actions) {
        this.myActions = actions;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setActionsGroup"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setPopupTuner(@Nullable Consumer<PopupChooserBuilder> tuner) {
        this.myPopupTuner = tuner;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setPopupTuner"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setDoneRunnable(@Nullable Runnable doneRunnable) {
        this.myDoneRunnable = doneRunnable;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "setDoneRunnable"));
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public JBPopup createMasterDetailPopup() {
        String title;
        if (this.myChooserComponent instanceof JList) {
            ((JList)this.myChooserComponent).setCellRenderer(new ListItemRenderer(this.myProject, this.myDelegate));
        }
        if (this.myDetailView == null) {
            this.myDetailView = new DetailViewImpl(this.myProject);
        }
        this.myPathLabel = new JLabel(" ");
        this.myPathLabel.setHorizontalAlignment(4);
        this.myPathLabel.setFont(this.myPathLabel.getFont().deriveFont(10.0f));
        JPanel footerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOR);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        footerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        footerPanel.add(this.myPathLabel);
        Runnable itemCallback = new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)MasterDetailPopupBuilder.this.myProject).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        MasterDetailPopupBuilder.this.chooseItems(false);
                    }
                });
            }
        };
        JComponent toolBar = null;
        if (this.myActions != null) {
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("", this.myActions, true);
            actionToolbar.setReservePlaceAutoPopupIcon(false);
            actionToolbar.setMinimumButtonSize(new Dimension(20, 20));
            toolBar = actionToolbar.getComponent();
            toolBar.setOpaque(false);
        }
        PopupChooserBuilder builder = this.createInnerBuilder().setMovable(true).setResizable(true).setAutoselectOnMouseMove(false).setMayBeParent(true).setDimensionServiceKey(this.myDimensionServiceKey).setSettingButton(toolBar).setSouthComponent((JComponent)footerPanel).setItemChoosenCallback(itemCallback).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((ItemWrapper)o).speedSearchText();
            }
        });
        if (this.myPopupTuner != null) {
            this.myPopupTuner.consume((Object)builder);
        }
        if (this.myDoneRunnable != null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MasterDetailPopupBuilder.this.myDoneRunnable.run();
                }
            };
            if ((SystemInfo.isMacOSLion || SystemInfo.isMacOSMountainLion) && !UIUtil.isUnderDarcula()) {
                final JButton done = new JButton("Done");
                done.setMnemonic('o');
                done.addActionListener(actionListener);
                builder.setCommandButton((ActiveComponent)new ActiveComponent.Adapter(){

                    public JComponent getComponent() {
                        return done;
                    }
                });
            } else {
                IconButton close = new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered);
                builder.setCommandButton((ActiveComponent)new InplaceButton(close, actionListener));
            }
        }
        if ((title = this.myDelegate.getTitle()) != null) {
            builder.setTitle(title);
        }
        this.myPopup = builder.createPopup();
        builder.getScrollPane().setBorder(IdeBorderFactory.createBorder((int)4));
        this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                MasterDetailPopupBuilder.this.myDetailView.clearEditor();
            }
        });
        if (this.myDoneRunnable != null) {
            new AnAction("Done"){

                public void actionPerformed(AnActionEvent e) {
                    MasterDetailPopupBuilder.this.myDoneRunnable.run();
                }
            }.registerCustomShortcutSet(10, 128, this.myPopup.getContent());
        }
        JBPopup jBPopup = this.myPopup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder", "createMasterDetailPopup"));
        }
        return jBPopup;
    }

    private PopupChooserBuilder createInnerBuilder() {
        if (this.myChooserComponent instanceof JList) {
            return new MyPopupChooserBuilder((JList)this.myChooserComponent);
        }
        if (this.myChooserComponent instanceof JTree) {
            return new MyPopupChooserBuilder((JTree)this.myChooserComponent);
        }
        throw new IllegalStateException("Incorrect chooser component: " + this.myChooserComponent);
    }

    @Override
    public ItemWrapper[] getSelectedItems() {
        Object[] values = ArrayUtil.EMPTY_OBJECT_ARRAY;
        if (this.myChooserComponent instanceof JList) {
            values = ((JList)this.myChooserComponent).getSelectedValues();
        } else if (this.myChooserComponent instanceof JTree) {
            values = this.myDelegate.getSelectedItemsInTree();
        }
        ItemWrapper[] items = new ItemWrapper[values.length];
        for (int i = 0; i < values.length; ++i) {
            items[i] = (ItemWrapper)values[i];
        }
        return items;
    }

    @Override
    public JLabel getPathLabel() {
        return this.myPathLabel;
    }

    private String getSplitterProportionKey() {
        return this.myDimensionServiceKey != null ? this.myDimensionServiceKey + ".splitter" : null;
    }

    private class MyPopupChooserBuilder
    extends PopupChooserBuilder {
        public MyPopupChooserBuilder(JList list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$MyPopupChooserBuilder", "<init>"));
            }
            super(list);
        }

        private MyPopupChooserBuilder(JTree tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$MyPopupChooserBuilder", "<init>"));
            }
            super(tree);
        }

        protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component) {
            if (MasterDetailPopupBuilder.this.myAddDetailViewToEast) {
                JBSplitter splitPane = new JBSplitter(0.3f);
                splitPane.setSplitterProportionKey(MasterDetailPopupBuilder.this.getSplitterProportionKey());
                splitPane.setFirstComponent(component);
                splitPane.setSecondComponent((JComponent)MasterDetailPopupBuilder.this.myDetailView);
                contentPane.add((Component)splitPane, "Center");
            } else {
                super.addCenterComponentToContentPane(contentPane, component);
            }
        }
    }

    private static class ListItemRenderer
    extends JPanel
    implements ListCellRenderer {
        private final Project myProject;
        private final ColoredListCellRenderer myRenderer;
        private final Delegate myDelegate;

        private ListItemRenderer(Project project, Delegate delegate) {
            super(new BorderLayout());
            this.myProject = project;
            this.myDelegate = delegate;
            this.setBackground(UIUtil.getListBackground());
            JComponent accessory = this.myDelegate.createAccessoryView(project);
            if (accessory != null) {
                this.add((Component)accessory, "West");
            }
            this.myRenderer = new ItemWrapperListRenderer(this.myProject, accessory);
            this.add((Component)this.myRenderer, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SplitterItem) {
                String label = ((SplitterItem)value).getText();
                TitledSeparator separator = new TitledSeparator(label);
                separator.setBackground(UIUtil.getListBackground());
                separator.setForeground(UIUtil.getListForeground());
                return separator;
            }
            this.myRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.myRenderer.revalidate();
            return this;
        }
    }

    public static interface Delegate {
        @Nullable
        public String getTitle();

        public void handleMnemonic(KeyEvent var1, Project var2, JBPopup var3);

        @Nullable
        public JComponent createAccessoryView(Project var1);

        public Object[] getSelectedItemsInTree();

        public void itemChosen(ItemWrapper var1, Project var2, JBPopup var3, boolean var4);

        public void removeSelectedItemsInTree();
    }
}

