/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class GCUtil {
    private static final boolean ourHasBeanInfoCache = SystemInfo.isJavaVersionAtLeast((String)"1.7");

    public static void tryForceGC() {
        GCUtil.tryGcSoftlyReachableObjects();
        WeakReference<Object> weakReference = new WeakReference<Object>(new Object());
        do {
            System.gc();
        } while (weakReference.get() != null);
    }

    public static void tryGcSoftlyReachableObjects() {
        GCUtil.tryClearBeanInfoCache();
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)(100 + GCUtil.useReference(ref)));
        for (int i = 0; i < 100; ++i) {
            System.gc();
            if (q.poll() != null) break;
            TimeoutUtil.sleep((long)10L);
            long bytes = Math.min(Runtime.getRuntime().freeMemory() / 2L, 0x3FFFFFFFL);
            list.add(new SoftReference<byte[]>(new byte[(int)bytes]));
        }
        list.ensureCapacity(list.size() + GCUtil.useReference(ref));
    }

    private static int useReference(SoftReference<Object> ref) {
        Object o = ref.get();
        return o == null ? 0 : Math.abs(o.hashCode()) % 10;
    }

    private static void tryClearBeanInfoCache() {
        if (ourHasBeanInfoCache) {
            try {
                Class<?> aClass = Class.forName("java.beans.ThreadGroupContext");
                Method getContextMethod = aClass.getDeclaredMethod("getContext", new Class[0]);
                getContextMethod.setAccessible(true);
                Object contextForThreadGroup = getContextMethod.invoke(null, new Object[0]);
                Method clearBeanInfoCacheMethod = contextForThreadGroup.getClass().getDeclaredMethod("clearBeanInfoCache", new Class[0]);
                clearBeanInfoCacheMethod.setAccessible(true);
                clearBeanInfoCacheMethod.invoke(contextForThreadGroup, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

