/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class TaskQueue {
    private final AtomicInteger myDoWorkRequest = new AtomicInteger();
    private final AtomicInteger myUpdatesCount = new AtomicInteger();
    private final BlockingQueue<Runnable> myPendingWriteRequestsQueue = new LinkedBlockingQueue<Runnable>();
    private final BlockingQueue<Runnable> myTimestampUpdates = new LinkedBlockingQueue<Runnable>();
    private final int myLimit;
    private final int myStealLimit;
    private final int myTimeStampUpdateSizeLimit;

    public TaskQueue(int limit) {
        this.myLimit = limit;
        this.myStealLimit = Math.max(1, (int)((double)limit * 0.01));
        this.myTimeStampUpdateSizeLimit = 32;
    }

    void submit(final @NotNull Computable<Boolean> update, final @NotNull Runnable successRunnable) {
        int size;
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/indexing/TaskQueue", "submit"));
        }
        if (successRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successRunnable", "com/intellij/util/indexing/TaskQueue", "submit"));
        }
        int currentTasksCount = this.myUpdatesCount.incrementAndGet();
        this.myPendingWriteRequestsQueue.add(new Runnable(){

            @Override
            public void run() {
                try {
                    Boolean result = (Boolean)update.compute();
                    if (result == Boolean.TRUE) {
                        TaskQueue.this.myTimestampUpdates.add(successRunnable);
                    }
                }
                finally {
                    TaskQueue.this.myUpdatesCount.decrementAndGet();
                }
            }
        });
        if (currentTasksCount > this.myLimit) {
            Runnable runnable = (Runnable)this.myPendingWriteRequestsQueue.poll();
            int processed = 0;
            while (runnable != null) {
                runnable.run();
                if (++processed == this.myStealLimit) break;
                runnable = (Runnable)this.myPendingWriteRequestsQueue.poll();
            }
        }
        if ((size = this.myTimestampUpdates.size()) > this.myTimeStampUpdateSizeLimit) {
            this.applyTimeStamps(size);
        }
    }

    private void applyTimeStamps(final int max) {
        final Runnable runnable = (Runnable)this.myTimestampUpdates.poll();
        if (runnable == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                int updates = 0;
                Runnable r = runnable;
                while (r != null) {
                    r.run();
                    if (++updates == max) break;
                    r = (Runnable)TaskQueue.this.myTimestampUpdates.poll();
                }
            }
        });
    }

    public void ensureUpToDate() {
        try {
            if (Registry.is((String)"idea.concurrent.scanning.files.to.index")) {
                return;
            }
            while (this.myUpdatesCount.get() > 0) {
                Runnable runnable = this.myPendingWriteRequestsQueue.poll(10L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            this.applyTimeStamps(Integer.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void signalUpdateEnd() {
        this.myDoWorkRequest.decrementAndGet();
    }

    public void signalUpdateStart() {
        int workRequests = this.myDoWorkRequest.getAndIncrement();
        if (workRequests == 0) {
            if (Registry.is((String)"idea.concurrent.scanning.files.to.index")) {
                return;
            }
            this.myDoWorkRequest.incrementAndGet();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Runnable runnable;
                            if ((runnable = (Runnable)TaskQueue.this.myPendingWriteRequestsQueue.poll(2000L, TimeUnit.MILLISECONDS)) != null) {
                                runnable.run();
                                continue;
                            }
                            if (TaskQueue.this.myDoWorkRequest.compareAndSet(1, 0)) break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

