/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ElementProducer;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CollectionModelEditor<T, E extends CollectionItemEditor<T>>
implements ElementProducer<T> {
    protected static final Logger LOG = Logger.getInstance(CollectionModelEditor.class);
    protected final E itemEditor;
    protected final ModelHelper<T> helper;

    protected CollectionModelEditor(@NotNull E itemEditor) {
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/CollectionModelEditor", "<init>"));
        }
        this.helper = new ModelHelper();
        this.itemEditor = itemEditor;
    }

    public T createElement() {
        return (T)ReflectionUtil.newInstance(((CollectionItemEditor)this.itemEditor).getItemClass());
    }

    public boolean canCreateElement() {
        return true;
    }

    @NotNull
    protected abstract List<T> getItems();

    public final boolean isModified(@NotNull List<T> oldItems) {
        if (oldItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItems", "com/intellij/util/ui/CollectionModelEditor", "isModified"));
        }
        List<T> items = this.getItems();
        if (items.size() != oldItems.size()) {
            return true;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            if (items.get(i).equals(oldItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public void processModifiedItems(final @NotNull PairProcessor<T, T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/ui/CollectionModelEditor", "processModifiedItems"));
        }
        this.helper.process(new TObjectObjectProcedure<T, T>(){

            public boolean execute(T newItem, T oldItem) {
                return processor.process(newItem, oldItem);
            }
        });
    }

    public static class ModelHelper<T> {
        private final THashMap<T, T> modifiedToOriginal = new THashMap();

        public void clear() {
            this.modifiedToOriginal.clear();
        }

        public void remove(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "remove"));
            }
            this.modifiedToOriginal.remove(item);
        }

        public boolean isMutable(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "isMutable"));
            }
            return this.modifiedToOriginal.containsKey(item);
        }

        @NotNull
        public T getMutable(@NotNull T item, @NotNull CollectionItemEditor<T> itemEditor) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
            }
            if (itemEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
            }
            if (this.isMutable(item)) {
                T t = item;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
                }
                return t;
            }
            T mutable = itemEditor.clone(item, true);
            this.modifiedToOriginal.put(mutable, item);
            T t = mutable;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "getMutable"));
            }
            return t;
        }

        public boolean hasModifiedItems() {
            return !this.modifiedToOriginal.isEmpty();
        }

        public void process(@NotNull TObjectObjectProcedure<T, T> procedure) {
            if (procedure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/util/ui/CollectionModelEditor$ModelHelper", "process"));
            }
            this.modifiedToOriginal.forEachEntry(procedure);
        }
    }
}

