/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import gnu.trove.TObjectObjectProcedure;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListModelEditor<T>
extends CollectionModelEditor<T, ListItemEditor<T>> {
    private final CollectionListModel<T> model;
    private final ToolbarDecorator toolbarDecorator;
    private JBList list;

    public ListModelEditor(final @NotNull ListItemEditor<T> itemEditor) {
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/ListModelEditor", "<init>"));
        }
        super(itemEditor);
        this.model = new CollectionListModel<T>(){

            public void remove(int index) {
                Object item = this.getElementAt(index);
                super.remove(index);
                ListModelEditor.this.helper.remove(item);
            }

            public void removeAll() {
                super.removeAll();
                ListModelEditor.this.helper.clear();
            }
        };
        this.list = new JBList(this.model);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.list).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object lastItem;
                if (!ListModelEditor.this.model.isEmpty() && itemEditor.isEmpty(lastItem = ListModelEditor.this.model.getElementAt(ListModelEditor.this.model.getSize() - 1))) {
                    ListScrollingUtil.selectItem((JList)ListModelEditor.this.list, (int)ContainerUtil.indexOfIdentity((List)ListModelEditor.this.model.getItems(), (Object)lastItem));
                    return;
                }
                Object item = ListModelEditor.this.createElement();
                ListModelEditor.this.model.add(item);
                ListScrollingUtil.selectItem((JList)ListModelEditor.this.list, (int)ContainerUtil.indexOfIdentity((List)ListModelEditor.this.model.getItems(), item));
            }
        });
    }

    @NotNull
    public T getMutable(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/ListModelEditor", "getMutable"));
        }
        T mutable = this.helper.getMutable(item, this.itemEditor);
        if (mutable != item) {
            this.model.setElementAt(mutable, ContainerUtil.indexOfIdentity((List)this.model.getItems(), item));
        }
        T t = mutable;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "getMutable"));
        }
        return t;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.createPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "createComponent"));
        }
        return jPanel;
    }

    @NotNull
    public JBList getList() {
        JBList jBList = this.list;
        if (jBList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "getList"));
        }
        return jBList;
    }

    @NotNull
    public CollectionListModel<T> getModel() {
        CollectionListModel<T> collectionListModel = this.model;
        if (collectionListModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "getModel"));
        }
        return collectionListModel;
    }

    @Nullable
    public T getSelected() {
        return (T)this.list.getSelectedValue();
    }

    public void reset(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListModelEditor", "reset"));
        }
        this.model.replaceAll(items);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ListModelEditor.this.model.isEmpty()) {
                    ListModelEditor.this.list.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        List list = this.model.getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "getItems"));
        }
        return list;
    }

    @NotNull
    public List<T> apply() {
        final List<T> items = this.getItems();
        if (!this.helper.hasModifiedItems()) {
            List<T> list = items;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "apply"));
            }
            return list;
        }
        this.helper.process(new TObjectObjectProcedure<T, T>(){

            public boolean execute(T newItem, T oldItem) {
                XmlSerializerUtil.copyBean(newItem, oldItem);
                int index = ContainerUtil.indexOfIdentity((List)items, newItem);
                if (index == -1) {
                    CollectionModelEditor.LOG.error("Inconsistence model", new String[]{newItem.toString()});
                }
                ListModelEditor.this.model.setElementAt(oldItem, index);
                return true;
            }
        });
        this.helper.clear();
        List<T> list = this.getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "apply"));
        }
        return list;
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer {
        private MyListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            this.setBackground(UIUtil.getListBackground((boolean)selected));
            this.append(((ListItemEditor)ListModelEditor.this.itemEditor).getName(value));
        }
    }
}

