/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.collect.Ordering;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.RefPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchesPanel
extends JPanel {
    private final VcsLogDataHolder myDataHolder;
    private final VcsLogUiImpl myUI;
    private List<RefGroup> myRefGroups;
    private final RefPainter myRefPainter;
    @Nullable
    private Collection<VirtualFile> myRoots;
    private Map<Integer, RefGroup> myRefPositions;

    public BranchesPanel(@NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogUiImpl UI2, @NotNull RefsModel initialRefsModel) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        if (UI2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "UI", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        if (initialRefsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialRefsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        this.myRoots = null;
        this.myRefPositions = ContainerUtil.newHashMap();
        this.myDataHolder = dataHolder;
        this.myUI = UI2;
        this.myRefGroups = this.getRefsToDisplayOnPanel(initialRefsModel);
        this.myRefPainter = new RefPainter(this.myUI.getColorManager(), true);
        this.setPreferredSize(new Dimension(-1, 26));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!BranchesPanel.this.myUI.getMainFrame().areGraphActionsEnabled()) {
                    return;
                }
                RefGroup group = BranchesPanel.this.findRef(e);
                if (group == null) {
                    return;
                }
                if (group.getRefs().size() == 1) {
                    VcsRef ref = (VcsRef)group.getRefs().iterator().next();
                    BranchesPanel.this.myUI.jumpToCommit(ref.getCommitHash());
                } else {
                    RefPopupComponent view = new RefPopupComponent(group, BranchesPanel.this.myUI, BranchesPanel.this.myRefPainter);
                    JBPopup popup = view.getPopup();
                    popup.show(new RelativePoint((Component)BranchesPanel.this, new Point(e.getX(), BranchesPanel.this.getHeight())));
                }
            }
        });
        this.myUI.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refresh) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/BranchesPanel$2", "onChange"));
                }
                if (refresh) {
                    BranchesPanel.this.rebuild(dataPack.getRefs());
                }
            }
        });
    }

    @Nullable
    private RefGroup findRef(MouseEvent e) {
        List sortedPositions = Ordering.natural().sortedCopy(this.myRefPositions.keySet());
        int index = Ordering.natural().binarySearch(sortedPositions, (Object)e.getX());
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            return null;
        }
        return this.myRefPositions.get(sortedPositions.get(index));
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.myRefPositions = ContainerUtil.newHashMap();
        int paddingX = 0;
        for (RefGroup group : this.myRefGroups) {
            VirtualFile root = ((VcsRef)group.getRefs().iterator().next()).getRoot();
            if (this.myRoots != null && !this.myRoots.contains(root)) continue;
            Color rootIndicatorColor = this.myUI.getColorManager().getRootColor(root);
            Rectangle rectangle = this.myRefPainter.drawLabel((Graphics2D)g, group.getName(), paddingX, group.getBgColor(), rootIndicatorColor);
            paddingX += rectangle.width + 10;
            this.myRefPositions.put(rectangle.x, group);
        }
    }

    public void rebuild(@NotNull VcsLogRefs refsModel) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "rebuild"));
        }
        this.myRefGroups = this.getRefsToDisplayOnPanel(refsModel);
        this.getParent().repaint();
    }

    @NotNull
    private List<RefGroup> getRefsToDisplayOnPanel(@NotNull VcsLogRefs refsModel) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getRefsToDisplayOnPanel"));
        }
        Collection allRefs = refsModel.getBranches();
        ArrayList groups = ContainerUtil.newArrayList();
        for (Map.Entry entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            Collection refs = (Collection)entry.getValue();
            VcsLogProvider provider = this.myDataHolder.getLogProvider(root);
            VcsLogRefManager refManager = provider.getReferenceManager();
            groups.addAll(BranchesPanel.expandExpandableGroups(refManager.group(refs)));
        }
        ArrayList arrayList = groups;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getRefsToDisplayOnPanel"));
        }
        return arrayList;
    }

    private static Collection<RefGroup> expandExpandableGroups(List<RefGroup> refGroups) {
        ArrayList groups = ContainerUtil.newArrayList();
        for (RefGroup group : refGroups) {
            if (group.isExpanded()) {
                groups.addAll(ContainerUtil.map((Collection)group.getRefs(), (Function)new Function<VcsRef, RefGroup>(){

                    public RefGroup fun(VcsRef ref) {
                        return new SingletonRefGroup(ref);
                    }
                }));
                continue;
            }
            groups.add(group);
        }
        return groups;
    }

    public void onFiltersChange(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/ui/frame/BranchesPanel", "onFiltersChange"));
        }
        this.myRoots = VcsLogUtil.getAllVisibleRoots(this.myDataHolder.getRoots(), filters.getRootFilter(), filters.getStructureFilter());
        this.getParent().repaint();
    }

    private static class SingleRefComponent
    extends JPanel {
        private final RefPainter myRefPainter;
        private VcsRef myRef;
        public boolean mySelected;

        public SingleRefComponent(RefPainter refPainter) {
            this.myRefPainter = refPainter;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.mySelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.myRef != null) {
                this.myRefPainter.draw((Graphics2D)g, Collections.singletonList(this.myRef), 0, this.calcWidth());
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.calcWidth(), 22);
        }

        private int calcWidth() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            return metrics.stringWidth(this.myRef.getName());
        }

        public void setRef(@NotNull VcsRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/ui/frame/BranchesPanel$SingleRefComponent", "setRef"));
            }
            this.myRef = ref;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }
    }

    private static class RefPopupComponent
    extends JPanel {
        private final JBPopup myPopup;
        private final JBList myList;
        private final VcsLogUiImpl myUi;
        private final RefPainter myRefPainter;
        private final SingleRefComponent myRendererComponent;
        private final ListCellRenderer myCellRenderer;

        RefPopupComponent(RefGroup group, VcsLogUiImpl ui, RefPainter refPainter) {
            super(new BorderLayout());
            this.myUi = ui;
            this.myRefPainter = refPainter;
            this.myRendererComponent = new SingleRefComponent(this.myRefPainter);
            this.myCellRenderer = new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    RefPopupComponent.this.myRendererComponent.setRef((VcsRef)value);
                    RefPopupComponent.this.myRendererComponent.setSelected(isSelected);
                    return RefPopupComponent.this.myRendererComponent;
                }
            };
            this.myList = this.createList(group);
            this.myPopup = this.createPopup();
            this.add((Component)new JBScrollPane((Component)this.myList));
        }

        private JBList createList(RefGroup group) {
            JBList list = new JBList((ListModel)RefPopupComponent.createListModel(group));
            list.setCellRenderer(this.myCellRenderer);
            ListUtil.installAutoSelectOnMouseMove((JList)list);
            list.setSelectedIndex(0);
            list.setSelectionMode(0);
            this.jumpOnMouseClick(list);
            this.jumpOnEnter(list);
            return list;
        }

        private void jumpOnMouseClick(JBList list) {
            list.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RefPopupComponent.this.jumpToSelectedRef();
                }
            });
        }

        private void jumpOnEnter(JBList list) {
            list.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        RefPopupComponent.this.jumpToSelectedRef();
                    }
                }
            });
        }

        private JBPopup createPopup() {
            return JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this.myList).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setFocusable(true).setRequestFocus(true).setResizable(true).setDimensionServiceKey(this.myUi.getProject(), "Vcs.Log.Branch.Panel.RefGroup.Popup", false).createPopup();
        }

        private static DefaultListModel createListModel(RefGroup group) {
            DefaultListModel<VcsRef> model = new DefaultListModel<VcsRef>();
            for (VcsRef vcsRef : group.getRefs()) {
                model.addElement(vcsRef);
            }
            return model;
        }

        @NotNull
        JBPopup getPopup() {
            JBPopup jBPopup = this.myPopup;
            if (jBPopup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel$RefPopupComponent", "getPopup"));
            }
            return jBPopup;
        }

        private void jumpToSelectedRef() {
            this.myPopup.cancel();
            VcsRef selectedRef = (VcsRef)this.myList.getSelectedValue();
            if (selectedRef != null) {
                this.myUi.jumpToCommit(selectedRef.getCommitHash());
            }
        }
    }
}

