/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class SubtractionInCompareToInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SubtractionInCompareToInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SubtractionInCompareToInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SubtractionInCompareToVisitor();
    }

    private static class SubtractionInCompareToVisitor
    extends BaseInspectionVisitor {
        private SubtractionInCompareToVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            PsiClass comparatorClass;
            PsiClass functionalInterface;
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.MINUS)) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class});
            if (lambdaExpression != null && (functionalInterface = PsiUtil.resolveClassInType((PsiType)lambdaExpression.getFunctionalInterfaceType())) != null && "java.util.Comparator".equals(functionalInterface.getQualifiedName())) {
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (method == null) {
                return;
            }
            if (MethodUtils.isCompareTo(method)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
            if ((comparatorClass = ClassUtils.findClass("java.util.Comparator", (PsiElement)expression)) == null) {
                return;
            }
            PsiMethod[] methods = comparatorClass.findMethodsByName("compare", false);
            assert (methods.length == 1);
            PsiMethod compareMethod = methods[0];
            if (!PsiSuperMethodUtil.isSuperMethod((PsiMethod)method, (PsiMethod)compareMethod)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

