/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;

public class ByteBufUtilEx {
    public static int writeUtf8(ByteBuf buf, CharSequence seq) {
        return ByteBufUtilEx.writeUtf8(buf, seq, 0, seq.length());
    }

    public static int writeUtf8(ByteBuf buf, CharSequence seq, int start, int end) {
        int oldWriterIndex;
        AbstractByteBuf buffer;
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        if (seq == null) {
            throw new NullPointerException("seq");
        }
        int len = end - start;
        int maxSize = len * 3;
        buf.ensureWritable(maxSize);
        if (buf instanceof AbstractByteBuf) {
            buffer = (AbstractByteBuf)buf;
            oldWriterIndex = buffer.writerIndex;
        } else {
            ByteBuf underlying = buf.unwrap();
            if (underlying instanceof AbstractByteBuf) {
                buffer = (AbstractByteBuf)underlying;
                oldWriterIndex = buf.writerIndex();
            } else {
                byte[] bytes = seq.toString().getBytes(CharsetUtil.UTF_8);
                buf.writeBytes(bytes);
                return bytes.length;
            }
        }
        int writerIndex = oldWriterIndex;
        for (int i = start; i < end; ++i) {
            char c = seq.charAt(i);
            if (c < '\u0080') {
                buffer._setByte(writerIndex++, (int)((byte)c));
                continue;
            }
            if (c < '\u0800') {
                buffer._setByte(writerIndex++, (int)((byte)(0xC0 | c >> 6)));
                buffer._setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
                continue;
            }
            buffer._setByte(writerIndex++, (int)((byte)(0xE0 | c >> 12)));
            buffer._setByte(writerIndex++, (int)((byte)(0x80 | c >> 6 & 0x3F)));
            buffer._setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
        }
        if (buf == buffer) {
            buffer.writerIndex = writerIndex;
        } else {
            buf.writerIndex(writerIndex);
        }
        return writerIndex - oldWriterIndex;
    }

    public static void readUtf8(@NotNull ByteBuf buf, int byteCount, @NotNull CharBuffer charBuffer) throws IOException {
        int c;
        int count;
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "io/netty/buffer/ByteBufUtilEx", "readUtf8"));
        }
        if (charBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charBuffer", "io/netty/buffer/ByteBufUtilEx", "readUtf8"));
        }
        AbstractByteBuf buffer = ByteBufUtilEx.getBuf(buf);
        int readerIndex = buf.readerIndex();
        int byteIndex = readerIndex;
        int charIndex = charBuffer.position();
        char[] chars = charBuffer.array();
        for (count = 0; count < byteCount && (c = buffer._getByte(byteIndex++) & 0xFF) <= 127; ++count) {
            chars[charIndex++] = (char)c;
        }
        byteIndex = readerIndex + count;
        block6: while (count < byteCount) {
            c = buffer._getByte(byteIndex++) & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chars[charIndex++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    byte char2;
                    if ((count += 2) > byteCount) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    if (((char2 = buffer._getByte(byteIndex++)) & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chars[charIndex++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > byteCount) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = buffer._getByte(byteIndex++);
                    byte char3 = buffer._getByte(byteIndex++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chars[charIndex++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        if (buf == buffer) {
            buffer.readerIndex = readerIndex + byteCount;
        } else {
            buf.readerIndex(readerIndex + byteCount);
        }
        charBuffer.position(charIndex);
    }

    @NotNull
    static AbstractByteBuf getBuf(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "io/netty/buffer/ByteBufUtilEx", "getBuf"));
        }
        if (buffer instanceof AbstractByteBuf) {
            AbstractByteBuf abstractByteBuf = (AbstractByteBuf)buffer;
            if (abstractByteBuf == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/netty/buffer/ByteBufUtilEx", "getBuf"));
            }
            return abstractByteBuf;
        }
        AbstractByteBuf abstractByteBuf = (AbstractByteBuf)((WrappedByteBuf)buffer).buf;
        if (abstractByteBuf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/netty/buffer/ByteBufUtilEx", "getBuf"));
        }
        return abstractByteBuf;
    }
}

