/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Processor;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;

public abstract class ScriptManagerBaseEx<SCRIPT extends ScriptBase>
extends ScriptManagerBase<SCRIPT> {
    protected final ConcurrentMap<String, SCRIPT> idToScript = ContainerUtil.newConcurrentMap();

    @Override
    public final void forEachScript(@NotNull Processor<Script> scriptProcessor) {
        if (scriptProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptProcessor", "org/jetbrains/debugger/ScriptManagerBaseEx", "forEachScript"));
        }
        for (ScriptBase script : this.idToScript.values()) {
            if (scriptProcessor.process((Object)script)) continue;
            return;
        }
    }

    @Nullable
    public SCRIPT findScriptById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/debugger/ScriptManagerBaseEx", "findScriptById"));
        }
        return (SCRIPT)((ScriptBase)this.idToScript.get(id));
    }

    public void clear(@NotNull DebugEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/debugger/ScriptManagerBaseEx", "clear"));
        }
        this.idToScript.clear();
        listener.scriptsCleared();
    }

    @Override
    @Nullable
    public final Script findScriptByUrl(@NotNull String rawUrl) {
        if (rawUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawUrl", "org/jetbrains/debugger/ScriptManagerBaseEx", "findScriptByUrl"));
        }
        return this.findScriptByUrl(this.rawUrlToOurUrl(rawUrl));
    }

    @Override
    @Nullable
    public final Script findScriptByUrl(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/ScriptManagerBaseEx", "findScriptByUrl"));
        }
        for (ScriptBase script : this.idToScript.values()) {
            if (!url.equalsIgnoreParameters(script.getUrl())) continue;
            return script;
        }
        return null;
    }

    @NotNull
    protected Url rawUrlToOurUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/ScriptManagerBaseEx", "rawUrlToOurUrl"));
        }
        Url url2 = Urls.parseEncoded(url);
        if (url2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptManagerBaseEx", "rawUrlToOurUrl"));
        }
        return url2;
    }
}

