/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

public class HeaderAnnotator
implements Annotator {
    private final HeaderParserRepository myRepository;

    public HeaderAnnotator(@NotNull HeaderParserRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator", "<init>"));
        }
        this.myRepository = repository;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator", "annotate"));
        }
        if (psiElement instanceof Header) {
            Header header = (Header)psiElement;
            String name = header.getName();
            if (!HeaderAnnotator.isValidName(name)) {
                holder.createAnnotation(HighlightSeverity.ERROR, header.getNameElement().getTextRange(), ManifestBundle.message("header.name.invalid", new Object[0]));
            } else {
                HeaderParser headerParser = this.myRepository.getHeaderParser(name);
                if (headerParser != null) {
                    headerParser.annotate(header, holder);
                }
            }
        }
    }

    private static boolean isValidName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '-' || c == '_' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }
}

