/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.theoryinpractice.testng.util.TestNGUtil;
import icons.TestngIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestNGFramework
extends JavaTestFramework {
    @NotNull
    public String getName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGFramework", "getName"));
        }
        return "TestNG";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TestngIcons.TestNG;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGFramework", "getIcon"));
        }
        return icon;
    }

    protected String getMarkerClassFQName() {
        return "org.testng.annotations.Test";
    }

    @NotNull
    public String getLibraryPath() {
        String string;
        try {
            string = PathUtil.getJarPathForClass(Class.forName("org.testng.annotations.Test"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGFramework", "getLibraryPath"));
        }
        return string;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (canBePotential) {
            return this.isUnderTestSources(clazz);
        }
        return TestNGUtil.isTestNGClass(clazz);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/theoryinpractice/testng/TestNGFramework", "findSetUpMethod"));
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.testng.annotations.BeforeMethod", (boolean)false)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/theoryinpractice/testng/TestNGFramework", "findTearDownMethod"));
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.testng.annotations.AfterMethod", (boolean)false)) continue;
            return each;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiModifierList modifierList;
        PsiMethod[] methods;
        PsiClass superClass;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String setUpName = "setUp";
        PsiMethod patternMethod = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod inClass = clazz.findMethodBySignature(patternMethod, false);
        if (inClass != null) {
            int exit;
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)manager.getProject(), (String)("Method '" + setUpName + "' already exist but is not annotated as @BeforeMethod."), (String)CommonBundle.getWarningTitle(), (String)"Annotate", (String)"Create new method", (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                new AddAnnotationFix(BeforeMethod.class.getName(), (PsiModifierListOwner)inClass, new String[0]).invoke(inClass.getProject(), null, inClass.getContainingFile());
                return inClass;
            }
            if (exit == 1) {
                inClass = null;
                int i = 0;
                while (clazz.findMethodBySignature(patternMethod, false) != null) {
                    patternMethod.setName(setUpName + ++i);
                }
                setUpName = patternMethod.getName();
            }
        }
        if ((superClass = clazz.getSuperClass()) != null && (methods = superClass.findMethodsBySignature(patternMethod, false)).length > 0 && !(modifierList = methods[0].getModifierList()).hasModifierProperty("private")) {
            void var11_17;
            String string = "@" + BeforeMethod.class.getName() + "\n";
            if (modifierList.hasModifierProperty("protected")) {
                String string2 = string + "protected ";
            } else if (modifierList.hasModifierProperty("public")) {
                String string3 = string + "public ";
            }
            patternMethod = factory.createMethodFromText((String)var11_17 + "void " + setUpName + "() throws Exception {\nsuper." + setUpName + "();\n}", null);
        }
        PsiMethod[] psiMethods = clazz.getMethods();
        PsiMethod testMethod = null;
        for (PsiMethod psiMethod : psiMethods) {
            if (inClass == null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)BeforeMethod.class.getName(), (boolean)false)) {
                inClass = psiMethod;
            }
            if (testMethod != null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)Test.class.getName(), (boolean)false) || psiMethod.hasModifierProperty("private")) continue;
            testMethod = psiMethod;
        }
        if (inClass == null) {
            void var11_21;
            if (testMethod != null) {
                PsiMethod psiMethod = (PsiMethod)clazz.addBefore((PsiElement)patternMethod, testMethod);
            } else {
                PsiMethod psiMethod = (PsiMethod)clazz.add((PsiElement)patternMethod);
            }
            JavaCodeStyleManager.getInstance((Project)clazz.getProject()).shortenClassReferences((PsiElement)clazz);
            return var11_21;
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public char getMnemonic() {
        return 'N';
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG Test Class.java");
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG SetUp Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG TearDown Method.java");
    }

    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG Test Method.java");
    }

    @Nullable
    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG Parameters Method.java");
    }

    public boolean isTestMethod(PsiElement element) {
        return element instanceof PsiMethod && TestNGUtil.hasTest((PsiModifierListOwner)element);
    }
}

