/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.LinkedHashSet;
import java.util.Set;

public class TestNGPatternConfigurationProducer
extends AbstractPatternBasedConfigurationProducer<TestNGConfiguration> {
    public TestNGPatternConfigurationProducer() {
        super((ConfigurationType)TestNGConfigurationType.getInstance());
    }

    protected boolean isTestClass(PsiClass psiClass) {
        return TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
    }

    protected boolean isTestMethod(boolean checkAbstract, PsiElement psiElement) {
        return psiElement instanceof PsiModifierListOwner && TestNGUtil.hasTest((PsiModifierListOwner)psiElement);
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement element = this.checkPatterns(context, classes);
        if (element == null) {
            return false;
        }
        sourceElement.set((Object)element);
        TestData data = configuration.getPersistantData();
        data.setPatterns(classes);
        data.TEST_OBJECT = TestType.PATTERN.getType();
        data.setScope(this.setupPackageConfiguration(context, configuration, data.getScope()));
        configuration.setGeneratedName();
        return true;
    }

    protected Module findModule(TestNGConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.data.getPatterns();
        return this.findModule(configuration, contextModule, patterns);
    }

    public boolean isConfigurationFromContext(TestNGConfiguration testNGConfiguration, ConfigurationContext context) {
        String type = testNGConfiguration.getPersistantData().TEST_OBJECT;
        if (Comparing.equal((String)type, (String)TestType.PATTERN.getType())) {
            return this.isConfiguredFromContext(context, testNGConfiguration.getPersistantData().getPatterns());
        }
        return false;
    }
}

