/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.TrackRunningTestUtil;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.ClassUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.ListTableModel;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestNGConsoleProperties;
import com.theoryinpractice.testng.model.TestNGResultsTableModel;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.model.TestTreeBuilder;
import com.theoryinpractice.testng.model.TestTreeStructure;
import com.theoryinpractice.testng.model.TreeRootNode;
import com.theoryinpractice.testng.ui.TestNGConsoleView;
import com.theoryinpractice.testng.ui.TestNGTestTreeView;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGResults
extends TestResultsPanel
implements TestFrameworkRunningModel {
    @NonNls
    private static final String TESTNG_SPLITTER_PROPERTY = "TestNG.Splitter.Proportion";
    private final TableView resultsTable;
    private final TestNGResultsTableModel model;
    private final TestNGConfiguration configuration;
    private TestNGTestTreeView tree;
    private final Project project;
    private int count;
    private int total = 0;
    private final Set<TestProxy> failed = new HashSet<TestProxy>();
    private final Map<TestResultMessage, List<TestProxy>> started = new HashMap<TestResultMessage, List<TestProxy>>();
    private TestProxy failedToStart = null;
    private long start;
    private long end;
    private TestTreeBuilder treeBuilder;
    private final TreeRootNode rootNode;
    private static final String NO_PACKAGE = "No Package";
    private OpenSourceSelectionListener openSourceListener;
    private int myStatus = 1001;
    private Set<String> startedMethods = new HashSet<String>();
    private TestProxy myLastSelected;
    private TestsProgressAnimator animator;

    public TestNGResults(JComponent component, TestNGConfiguration configuration, TestNGConsoleView console, ExecutionEnvironment environment) {
        super(component, console.getConsole().createConsoleActions(), console.getProperties(), environment, TESTNG_SPLITTER_PROPERTY, 0.5f);
        this.configuration = configuration;
        this.project = configuration.getProject();
        this.model = new TestNGResultsTableModel(this.project);
        this.resultsTable = new TableView((ListTableModel)this.model);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Object result = TestNGResults.this.resultsTable.getSelectedObject();
                if (result instanceof TestResultMessage) {
                    String testClass = ((TestResultMessage)result).getTestClass();
                    PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)TestNGResults.this.project), (String)testClass);
                    if (psiClass != null) {
                        PsiMethod[] psiMethods;
                        String method = ((TestResultMessage)result).getMethod();
                        if (method != null && (psiMethods = psiClass.findMethodsByName(method, false)).length > 0) {
                            psiMethods[0].navigate(true);
                        }
                        psiClass.navigate(true);
                        return true;
                    }
                }
                return false;
            }
        }.installOn((Component)this.resultsTable);
        this.rootNode = new TreeRootNode();
        console.getUnboundOutput().addChild(this.rootNode);
    }

    protected JComponent createTestTreeView() {
        this.tree = new TestNGTestTreeView();
        TestTreeStructure structure = new TestTreeStructure(this.project, (Object)this.rootNode);
        this.tree.attachToModel(this);
        this.treeBuilder = new TestTreeBuilder((JTree)((Object)this.tree), (AbstractTreeStructure)structure);
        Disposer.register((Disposable)this, (Disposable)this.treeBuilder);
        this.animator = new TestsProgressAnimator((AbstractTestTreeBuilder)this.treeBuilder);
        this.openSourceListener = new OpenSourceSelectionListener();
        this.tree.getSelectionModel().addTreeSelectionListener(this.openSourceListener);
        TrackRunningTestUtil.installStopListeners((JTree)((Object)this.tree), (Disposable)this, (Pass)new Pass<AbstractTestProxy>(){

            public void pass(AbstractTestProxy abstractTestProxy) {
                TestNGResults.this.myLastSelected = (TestProxy)abstractTestProxy;
            }
        });
        return this.tree;
    }

    protected ToolbarPanel createToolbarPanel() {
        ToolbarPanel panel = new ToolbarPanel(this.getProperties(), this.myEnvironment, (JComponent)((Object)this));
        panel.setModel((TestFrameworkRunningModel)this);
        return panel;
    }

    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    protected JComponent createStatisticsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.resultsTable), "Center");
        return panel;
    }

    private void updateStatusLine() {
        this.myStatusLine.setText(this.getStatusLine());
    }

    public int getStatus() {
        return this.myStatus;
    }

    public String getStatusLine() {
        StringBuffer sb = new StringBuffer();
        if (this.end == 0L && this.start > 0L) {
            sb.append("Running: ");
        } else {
            if (this.failed.size() > 0) {
                sb.append("Failed: ").append(this.failed.size()).append("   ");
            }
            sb.append("Done: ");
        }
        sb.append(this.count).append(" of ").append(this.total);
        if (this.end == 0L) {
            if (this.failed.size() > 0) {
                sb.append("   Failed: ").append(this.failed.size());
            }
        } else {
            long time = this.end - this.start;
            sb.append(" (").append(time == 0L ? "0.0 s" : NumberFormat.getInstance().format((double)time / 1000.0) + " s").append(")  ");
        }
        return sb.toString();
    }

    public String getTime() {
        long time = this.end - this.start;
        return time == 0L ? "0.0 s" : NumberFormat.getInstance().format((double)time / 1000.0) + " s";
    }

    public TestProxy testStarted(TestResultMessage result) {
        return this.testStarted(result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestProxy testStarted(TestResultMessage result, boolean registerDups) {
        TestProxy classNode = this.getPackageClassNodeFor(result);
        TestProxy proxy = new TestProxy();
        proxy.setParent(classNode);
        proxy.setResultMessage(result);
        Map<TestResultMessage, List<TestProxy>> map = this.started;
        synchronized (map) {
            if (registerDups) {
                List<TestProxy> dups = this.started.get(result);
                if (dups == null) {
                    dups = new ArrayList<TestProxy>();
                    this.started.put(result, dups);
                }
                dups.add(proxy);
            }
        }
        String testMethodDescriptor = result.getTestClass() + TestProxy.toDisplayText(result, this.project);
        if (this.startedMethods.contains(testMethodDescriptor)) {
            ++this.total;
        } else {
            this.startedMethods.add(testMethodDescriptor);
        }
        this.animator.setCurrentTestCase((AbstractTestProxy)proxy);
        this.treeBuilder.addItem(classNode, proxy);
        ++this.count;
        if (this.count > this.total) {
            this.total = this.count;
        }
        if (this.myLastSelected == proxy) {
            this.myLastSelected = null;
        }
        if (this.myLastSelected == null && TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.selectTest(proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestResult(final TestResultMessage result, int exceptionMark) {
        PsiMethod[] methods;
        PsiElement element;
        TestProxy testCase;
        Map<TestResultMessage, List<TestProxy>> map = this.started;
        synchronized (map) {
            List<TestProxy> dups = this.started.get(result);
            testCase = dups == null || dups.isEmpty() ? null : dups.remove(0);
        }
        if (testCase == null && (element = this.getPackageClassNodeFor(result).getPsiElement()) instanceof PsiClass && (methods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return ((PsiClass)element).findMethodsByName(result.getMethod(), true);
            }
        })).length > 0 && methods[0] != null && !AnnotationUtil.isAnnotated((PsiModifierListOwner)methods[0], Arrays.asList(TestNGUtil.CONFIG_ANNOTATIONS_FQN))) {
            block3: for (List<TestProxy> proxies : this.started.values()) {
                if (proxies == null) continue;
                for (TestProxy proxy : proxies) {
                    if (!methods[0].equals(proxy.getPsiElement())) continue;
                    testCase = proxy;
                    continue block3;
                }
            }
            if (testCase == null) {
                testCase = this.testStarted(result, false);
                testCase.appendStacktrace(result);
            }
        }
        if (testCase != null) {
            testCase.setResultMessage(result);
            testCase.setTearDownFailure(this.failedToStart != null);
            this.failedToStart = null;
            if (result.getResult() == 1002) {
                this.failed.add(testCase);
            }
            this.model.addTestResult(result);
        } else {
            testCase = new TestProxy(TestProxy.toDisplayText(result, this.project));
            testCase.appendStacktrace(result);
            if (this.failedToStart != null) {
                this.failedToStart.addChild(testCase);
                this.failedToStart.setTearDownFailure(true);
            } else {
                this.failedToStart = testCase;
            }
        }
        testCase.setExceptionMark(exceptionMark);
        AbstractTestProxy.flushOutput((AbstractTestProxy)testCase);
        if (result.getResult() == 1002) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
            this.myStatus = 1002;
        } else if (result.getResult() == 1003 && this.myStatus == 1001) {
            this.myStatus = 1003;
        }
        this.myStatusLine.setFraction((double)this.count / (double)this.total);
        this.updateStatusLine();
        TestsUIUtil.showIconProgress((Project)this.project, (int)this.count, (int)this.total, (int)this.failed.size());
    }

    private TestProxy getPackageClassNodeFor(final TestResultMessage result) {
        TestProxy owner = this.treeBuilder.getRoot();
        String packageName1 = StringUtil.getPackageName((String)result.getTestClass());
        String packageName = packageName1.length() == 0 ? NO_PACKAGE : packageName1;
        if ((owner = this.getChildNodeNamed(owner, packageName)).getPsiElement() == null) {
            owner.setPsiElement((PsiElement)JavaPsiFacade.getInstance((Project)this.project).findPackage(packageName));
        }
        if ((owner = this.getChildNodeNamed(owner, StringUtil.getShortName((String)result.getTestClass()))).getPsiElement() == null) {
            final TestProxy finalOwner = owner;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    finalOwner.setPsiElement((PsiElement)ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)TestNGResults.this.project), (String)result.getTestClass()));
                }
            });
        }
        return owner;
    }

    private TestProxy getChildNodeNamed(TestProxy currentNode, String node) {
        for (TestProxy child : currentNode.getChildren()) {
            if (!child.getName().equals(node)) continue;
            return child;
        }
        TestProxy child = new TestProxy(node);
        this.treeBuilder.addItem(currentNode, child);
        return child;
    }

    public void selectTest(TestProxy proxy) {
        if (proxy == null) {
            return;
        }
        this.treeBuilder.select((Object)proxy, null);
    }

    public void setTotal(int total) {
        this.total += total;
    }

    public void start() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        this.treeBuilder.select((Object)this.rootNode);
        this.rootNode.setInProgress(true);
        this.rootNode.setStarted(true);
    }

    public void finish(final boolean started) {
        if (this.start > 0L) {
            this.end = System.currentTimeMillis();
        }
        LvcsHelper.addLabel((TestFrameworkRunningModel)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestNGResults.this.animator.stopMovie();
                TestNGResults.this.updateStatusLine();
                if (TestNGResults.this.total > TestNGResults.this.count || TestNGResults.this.myStatus == 1003) {
                    TestNGResults.this.myStatusLine.setStatusColor(ColorProgressBar.YELLOW);
                } else if (TestNGResults.this.myStatus == 1002) {
                    TestNGResults.this.myStatusLine.setStatusColor(ColorProgressBar.RED);
                } else {
                    TestNGResults.this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
                }
                TestNGResults.this.rootNode.setInProgress(false);
                if (TestNGConsoleProperties.SELECT_FIRST_DEFECT.value((AbstractProperty.AbstractPropertyContainer)TestNGResults.this.myProperties)) {
                    TestNGResults.this.selectTest(TestNGResults.this.rootNode.getFirstDefect());
                } else {
                    DefaultMutableTreeNode node = TestNGResults.this.treeBuilder.getNodeForElement((Object)TestNGResults.this.rootNode);
                    if (node != null && TestNGResults.this.myLastSelected == null) {
                        TestNGResults.this.tree.getSelectionModel().setSelectionPath(new TreePath(node));
                    }
                }
                TestNGResults.this.tree.repaint();
                if (TestNGResults.this.total > 0 || !ResetConfigurationModuleAdapter.tryWithAnotherModule((ModuleBasedConfiguration)TestNGResults.this.configuration, (boolean)TestNGResults.this.getProperties().isDebug())) {
                    TestsUIUtil.notifyByBalloon((Project)TestNGResults.this.project, (boolean)started, (AbstractTestProxy)TestNGResults.this.rootNode, (TestConsoleProperties)TestNGResults.this.getProperties(), (String)("in " + TestNGResults.this.getTime()));
                }
            }
        });
    }

    public void setFilter(Filter filter) {
        this.getTreeStructure().setFilter(filter);
        this.treeBuilder.updateFromRoot();
    }

    public boolean isRunning() {
        return this.rootNode.isInProgress();
    }

    public TestTreeView getTreeView() {
        return this.tree;
    }

    public TestTreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public boolean hasTestSuites() {
        return this.rootNode.getChildren().size() > 0;
    }

    public TestProxy getRoot() {
        return this.rootNode;
    }

    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectTest((TestProxy)testProxy);
    }

    public TestTreeStructure getTreeStructure() {
        return (TestTreeStructure)this.treeBuilder.getTreeStructure();
    }

    public void rebuildTree() {
        this.treeBuilder.updateFromRoot();
        this.tree.invalidate();
    }

    public void dispose() {
        super.dispose();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.openSourceListener);
        TestsUIUtil.clearIconProgress((Project)this.project);
    }

    public TestProxy getFailedToStart() {
        return this.failedToStart;
    }

    public void setFailedToStart(TestProxy failedToStart) {
        this.failedToStart = failedToStart;
    }

    public boolean hasFinishedTests() {
        return this.count > 0;
    }

    private class OpenSourceSelectionListener
    implements TreeSelectionListener {
        private OpenSourceSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getPath();
            if (path == null) {
                return;
            }
            TestProxy proxy = (TestProxy)TestNGResults.this.tree.getSelectedTest();
            if (proxy == null) {
                return;
            }
            if (ScrollToTestSourceAction.isScrollEnabled((TestFrameworkRunningModel)TestNGResults.this)) {
                OpenSourceUtil.openSourcesFrom((DataProvider)TestNGResults.this.tree, (boolean)false);
            }
        }
    }
}

