/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.SimpleNameResolver;
import io.netty.resolver.dns.DnsNameResolverContext;
import io.netty.resolver.dns.DnsQueryContext;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.OneTimeTask;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class DnsNameResolver
extends SimpleNameResolver<InetSocketAddress> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
    static final InetSocketAddress ANY_LOCAL_ADDR = new InetSocketAddress(0);
    private static final InternetProtocolFamily[] DEFAULT_RESOLVE_ADDRESS_TYPES = new InternetProtocolFamily[2];
    private static final DatagramDnsResponseDecoder DECODER;
    private static final DatagramDnsQueryEncoder ENCODER;
    final Iterable<InetSocketAddress> nameServerAddresses;
    final ChannelFuture bindFuture;
    final DatagramChannel ch;
    final AtomicReferenceArray<DnsQueryContext> promises = new AtomicReferenceArray(65536);
    final ConcurrentMap<DnsQuestion, DnsCacheEntry> queryCache = PlatformDependent.newConcurrentHashMap();
    private final DnsResponseHandler responseHandler = new DnsResponseHandler();
    private volatile long queryTimeoutMillis = 5000L;
    private volatile int minTtl;
    private volatile int maxTtl = Integer.MAX_VALUE;
    private volatile int negativeTtl;
    private volatile int maxTriesPerQuery = 2;
    private volatile InternetProtocolFamily[] resolveAddressTypes = DEFAULT_RESOLVE_ADDRESS_TYPES;
    private volatile boolean recursionDesired = true;
    private volatile int maxQueriesPerResolve = 8;
    private volatile int maxPayloadSize;

    public DnsNameResolver(EventLoop eventLoop, Class<? extends DatagramChannel> channelType, InetSocketAddress nameServerAddress) {
        this(eventLoop, channelType, ANY_LOCAL_ADDR, nameServerAddress);
    }

    public DnsNameResolver(EventLoop eventLoop, Class<? extends DatagramChannel> channelType, InetSocketAddress localAddress, InetSocketAddress nameServerAddress) {
        this(eventLoop, new ReflectiveChannelFactory<DatagramChannel>(channelType), localAddress, nameServerAddress);
    }

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress nameServerAddress) {
        this(eventLoop, channelFactory, ANY_LOCAL_ADDR, nameServerAddress);
    }

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress, InetSocketAddress nameServerAddress) {
        this(eventLoop, channelFactory, localAddress, DnsServerAddresses.singleton(nameServerAddress));
    }

    public DnsNameResolver(EventLoop eventLoop, Class<? extends DatagramChannel> channelType, Iterable<InetSocketAddress> nameServerAddresses) {
        this(eventLoop, channelType, ANY_LOCAL_ADDR, nameServerAddresses);
    }

    public DnsNameResolver(EventLoop eventLoop, Class<? extends DatagramChannel> channelType, InetSocketAddress localAddress, Iterable<InetSocketAddress> nameServerAddresses) {
        this(eventLoop, new ReflectiveChannelFactory<DatagramChannel>(channelType), localAddress, nameServerAddresses);
    }

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, Iterable<InetSocketAddress> nameServerAddresses) {
        this(eventLoop, channelFactory, ANY_LOCAL_ADDR, nameServerAddresses);
    }

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress, Iterable<InetSocketAddress> nameServerAddresses) {
        super(eventLoop);
        if (channelFactory == null) {
            throw new NullPointerException("channelFactory");
        }
        if (nameServerAddresses == null) {
            throw new NullPointerException("nameServerAddresses");
        }
        if (!nameServerAddresses.iterator().hasNext()) {
            throw new NullPointerException("nameServerAddresses is empty");
        }
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.nameServerAddresses = nameServerAddresses;
        this.bindFuture = this.newChannel(channelFactory, localAddress);
        this.ch = (DatagramChannel)this.bindFuture.channel();
        this.setMaxPayloadSize(4096);
    }

    private ChannelFuture newChannel(ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress) {
        Bootstrap b = new Bootstrap();
        b.group(this.executor());
        b.channelFactory(channelFactory);
        b.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(DECODER, ENCODER, DnsNameResolver.this.responseHandler);
            }
        });
        ChannelFuture bindFuture = b.bind(localAddress);
        bindFuture.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                DnsNameResolver.this.clearCache();
            }
        });
        return bindFuture;
    }

    public int minTtl() {
        return this.minTtl;
    }

    public int maxTtl() {
        return this.maxTtl;
    }

    public DnsNameResolver setTtl(int minTtl, int maxTtl) {
        if (minTtl < 0) {
            throw new IllegalArgumentException("minTtl: " + minTtl + " (expected: >= 0)");
        }
        if (maxTtl < 0) {
            throw new IllegalArgumentException("maxTtl: " + maxTtl + " (expected: >= 0)");
        }
        if (minTtl > maxTtl) {
            throw new IllegalArgumentException("minTtl: " + minTtl + ", maxTtl: " + maxTtl + " (expected: 0 <= minTtl <= maxTtl)");
        }
        this.maxTtl = maxTtl;
        this.minTtl = minTtl;
        return this;
    }

    public int negativeTtl() {
        return this.negativeTtl;
    }

    public DnsNameResolver setNegativeTtl(int negativeTtl) {
        if (negativeTtl < 0) {
            throw new IllegalArgumentException("negativeTtl: " + negativeTtl + " (expected: >= 0)");
        }
        this.negativeTtl = negativeTtl;
        return this;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public DnsNameResolver setQueryTimeoutMillis(long queryTimeoutMillis) {
        if (queryTimeoutMillis < 0L) {
            throw new IllegalArgumentException("queryTimeoutMillis: " + queryTimeoutMillis + " (expected: >= 0)");
        }
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this;
    }

    public int maxTriesPerQuery() {
        return this.maxTriesPerQuery;
    }

    public DnsNameResolver setMaxTriesPerQuery(int maxTriesPerQuery) {
        if (maxTriesPerQuery < 1) {
            throw new IllegalArgumentException("maxTries: " + maxTriesPerQuery + " (expected: > 0)");
        }
        this.maxTriesPerQuery = maxTriesPerQuery;
        return this;
    }

    public List<InternetProtocolFamily> resolveAddressTypes() {
        return Arrays.asList(this.resolveAddressTypes);
    }

    InternetProtocolFamily[] resolveAddressTypesUnsafe() {
        return this.resolveAddressTypes;
    }

    public DnsNameResolver setResolveAddressTypes(InternetProtocolFamily ... resolveAddressTypes) {
        if (resolveAddressTypes == null) {
            throw new NullPointerException("resolveAddressTypes");
        }
        ArrayList<InternetProtocolFamily> list = new ArrayList<InternetProtocolFamily>(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolveAddressTypes) {
            if (f == null) break;
            if (list.contains((Object)f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolveAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this;
    }

    public DnsNameResolver setResolveAddressTypes(Iterable<InternetProtocolFamily> resolveAddressTypes) {
        if (resolveAddressTypes == null) {
            throw new NullPointerException("resolveAddressTypes");
        }
        ArrayList<InternetProtocolFamily> list = new ArrayList<InternetProtocolFamily>(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolveAddressTypes) {
            if (f == null) break;
            if (list.contains((Object)f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolveAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public DnsNameResolver setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public DnsNameResolver setMaxQueriesPerResolve(int maxQueriesPerResolve) {
        if (maxQueriesPerResolve <= 0) {
            throw new IllegalArgumentException("maxQueriesPerResolve: " + maxQueriesPerResolve + " (expected: > 0)");
        }
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public DnsNameResolver setMaxPayloadSize(int maxPayloadSize) {
        if (maxPayloadSize <= 0) {
            throw new IllegalArgumentException("maxPayloadSize: " + maxPayloadSize + " (expected: > 0)");
        }
        if (this.maxPayloadSize == maxPayloadSize) {
            return this;
        }
        this.maxPayloadSize = maxPayloadSize;
        this.ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(maxPayloadSize));
        return this;
    }

    public DnsNameResolver clearCache() {
        Iterator i = this.queryCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            i.remove();
            ((DnsCacheEntry)e.getValue()).release();
        }
        return this;
    }

    public boolean clearCache(DnsQuestion question) {
        DnsCacheEntry e = (DnsCacheEntry)this.queryCache.remove(question);
        if (e != null) {
            e.release();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.ch.close();
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    @Override
    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        String hostname = IDN.toASCII(DnsNameResolver.hostname(unresolvedAddress));
        int port = unresolvedAddress.getPort();
        DnsNameResolverContext ctx = new DnsNameResolverContext(this, hostname, port, promise);
        ctx.resolve();
    }

    private static String hostname(InetSocketAddress addr) {
        if (PlatformDependent.javaVersion() < 7) {
            return addr.getHostName();
        }
        return addr.getHostString();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nameServerAddresses, question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nameServerAddresses, question, promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(Iterable<InetSocketAddress> nameServerAddresses, DnsQuestion question) {
        if (nameServerAddresses == null) {
            throw new NullPointerException("nameServerAddresses");
        }
        if (question == null) {
            throw new NullPointerException("question");
        }
        EventLoop eventLoop = this.ch.eventLoop();
        DnsCacheEntry cachedResult = (DnsCacheEntry)this.queryCache.get(question);
        if (cachedResult != null) {
            if (cachedResult.response != null) {
                return eventLoop.newSucceededFuture(cachedResult.response.retain());
            }
            return eventLoop.newFailedFuture(cachedResult.cause);
        }
        return this.query0(nameServerAddresses, question, eventLoop.newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(Iterable<InetSocketAddress> nameServerAddresses, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        if (nameServerAddresses == null) {
            throw new NullPointerException("nameServerAddresses");
        }
        if (question == null) {
            throw new NullPointerException("question");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        DnsCacheEntry cachedResult = (DnsCacheEntry)this.queryCache.get(question);
        if (cachedResult != null) {
            if (cachedResult.response != null) {
                return DnsNameResolver.cast(promise).setSuccess(cachedResult.response.retain());
            }
            return DnsNameResolver.cast(promise).setFailure(cachedResult.cause);
        }
        return this.query0(nameServerAddresses, question, promise);
    }

    private Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(Iterable<InetSocketAddress> nameServerAddresses, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(promise);
        try {
            new DnsQueryContext(this, nameServerAddresses, question, castPromise).query();
            return castPromise;
        }
        catch (Exception e) {
            return castPromise.setFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cache(final DnsQuestion question, DnsCacheEntry entry, long delaySeconds) {
        DnsCacheEntry oldEntry = this.queryCache.put(question, entry);
        if (oldEntry != null) {
            oldEntry.release();
        }
        boolean scheduled = false;
        try {
            entry.expirationFuture = this.ch.eventLoop().schedule(new OneTimeTask(){

                @Override
                public void run() {
                    DnsNameResolver.this.clearCache(question);
                }
            }, delaySeconds, TimeUnit.SECONDS);
            scheduled = true;
        }
        finally {
            if (!scheduled) {
                this.clearCache(question);
                entry.release();
            }
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    private static AddressedEnvelope<DnsResponse, InetSocketAddress> cast(AddressedEnvelope<?, ?> envelope) {
        return envelope;
    }

    static {
        if ("true".equalsIgnoreCase(SystemPropertyUtil.get("java.net.preferIPv6Addresses"))) {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv6;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv4;
            logger.debug("-Djava.net.preferIPv6Addresses: true");
        } else {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv4;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv6;
            logger.debug("-Djava.net.preferIPv6Addresses: false");
        }
        DECODER = new DatagramDnsResponseDecoder();
        ENCODER = new DatagramDnsQueryEncoder();
    }

    static final class DnsCacheEntry {
        final AddressedEnvelope<DnsResponse, InetSocketAddress> response;
        final Throwable cause;
        volatile ScheduledFuture<?> expirationFuture;

        DnsCacheEntry(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> response) {
            this.response = response.retain();
            this.cause = null;
        }

        DnsCacheEntry(Throwable cause) {
            this.cause = cause;
            this.response = null;
        }

        void release() {
            ScheduledFuture<?> expirationFuture;
            AddressedEnvelope<DnsResponse, InetSocketAddress> response = this.response;
            if (response != null) {
                ReferenceCountUtil.safeRelease(response);
            }
            if ((expirationFuture = this.expirationFuture) != null) {
                expirationFuture.cancel(false);
            }
        }
    }

    private final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private DnsResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                DnsQueryContext qCtx;
                DatagramDnsResponse res = (DatagramDnsResponse)msg;
                int queryId = res.id();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} RECEIVED: [{}: {}], {}", DnsNameResolver.this.ch, queryId, res.sender(), res);
                }
                if ((qCtx = DnsNameResolver.this.promises.get(queryId)) == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Received a DNS response with an unknown ID: {}", (Object)queryId);
                    }
                    return;
                }
                if (res.count(DnsSection.QUESTION) != 1) {
                    logger.warn("Received a DNS response with invalid number of questions: {}", (Object)res);
                    return;
                }
                DnsQuestion q = qCtx.question();
                if (!q.equals(res.recordAt(DnsSection.QUESTION))) {
                    logger.warn("Received a mismatching DNS response: {}", (Object)res);
                    return;
                }
                ScheduledFuture<?> timeoutFuture = qCtx.timeoutFuture();
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if (res.code() == DnsResponseCode.NOERROR) {
                    this.cache(q, res);
                    DnsNameResolver.this.promises.set(queryId, null);
                    Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> qPromise = qCtx.promise();
                    if (qPromise.setUncancellable()) {
                        qPromise.setSuccess(DnsNameResolver.cast(res.retain()));
                    }
                } else {
                    qCtx.retry(res.sender(), "response code: " + res.code() + " with " + res.count(DnsSection.ANSWER) + " answer(s) and " + res.count(DnsSection.AUTHORITY) + " authority resource(s)");
                }
            }
            finally {
                ReferenceCountUtil.safeRelease(msg);
            }
        }

        private void cache(DnsQuestion question, AddressedEnvelope<? extends DnsResponse, InetSocketAddress> res) {
            int maxTtl = DnsNameResolver.this.maxTtl();
            if (maxTtl == 0) {
                return;
            }
            long ttl = Long.MAX_VALUE;
            DnsResponse resc = res.content();
            int answerCount = resc.count(DnsSection.ANSWER);
            for (int i = 0; i < answerCount; ++i) {
                Object r = resc.recordAt(DnsSection.ANSWER, i);
                long rTtl = r.timeToLive();
                if (ttl <= rTtl) continue;
                ttl = rTtl;
            }
            ttl = Math.max((long)DnsNameResolver.this.minTtl(), Math.min((long)maxTtl, ttl));
            DnsNameResolver.this.cache(question, new DnsCacheEntry(res), ttl);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("Unexpected exception: ", cause);
        }
    }
}

