/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GitVFSListener
extends VcsVFSListener {
    private final AtomicInteger myEventsSuppressLevel = new AtomicInteger(0);
    private final Git myGit;

    public GitVFSListener(Project project, GitVcs vcs, Git git) {
        super(project, (AbstractVcs)vcs);
        this.myGit = git;
    }

    public void setEventsSuppressed(boolean value) {
        if (value) {
            this.myEventsSuppressLevel.incrementAndGet();
        } else {
            int v = this.myEventsSuppressLevel.decrementAndGet();
            assert (v >= 0);
        }
    }

    protected boolean isEventIgnored(VirtualFileEvent event, boolean putInDirty) {
        return super.isEventIgnored(event, putInDirty) || this.myEventsSuppressLevel.get() != 0;
    }

    protected String getAddTitle() {
        return GitBundle.getString("vfs.listener.add.title");
    }

    protected String getSingleFileAddTitle() {
        return GitBundle.getString("vfs.listener.add.single.title");
    }

    protected String getSingleFileAddPromptTemplate() {
        return GitBundle.getString("vfs.listener.add.single.prompt");
    }

    protected void executeAdd(final List<VirtualFile> addedFiles, final Map<VirtualFile, VirtualFile> copiedFiles) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(addedFiles, true);
        }
        catch (VcsException e) {
            throw new RuntimeException("The exception is not expected here", e);
        }
        final HashSet retainedFiles = new HashSet();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.getString("vfs.listener.checking.ignored"), false){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/vfs/GitVFSListener$1", "run"));
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    VirtualFile root = (VirtualFile)e.getKey();
                    List files = (List)e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(GitVFSListener.this.myGit.untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GitVFSListener.this.gitVcs().showMessages(ex.getMessage());
                            }
                        });
                    }
                }
                addedFiles.retainAll(retainedFiles);
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GitVFSListener.this.originalExecuteAdd(addedFiles, copiedFiles);
                    }
                });
            }
        });
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        this.performAdding(ObjectsConvertor.vf2fp(new ArrayList<VirtualFile>(addedFiles)));
    }

    private GitVcs gitVcs() {
        return (GitVcs)this.myVcs;
    }

    private void performAdding(Collection<FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.getString("add.adding"), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) throws VcsException {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/vfs/GitVFSListener$2", "execute"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/vfs/GitVFSListener$2", "execute"));
                }
                LOG.debug("Git: adding files: " + files);
                GitFileUtils.addPaths(GitVFSListener.this.myProject, root, files);
                VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return Collections.emptyList();
            }
        });
    }

    protected String getDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.title");
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.single.title");
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.getString("vfs.listener.delete.single.prompt");
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
        this.performBackgroundOperation(filesToDelete, GitBundle.getString("remove.removing"), new LongOperationPerRootExecutor(){
            HashSet<File> filesToRefresh = new HashSet();

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<FilePath> files) throws VcsException {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/vfs/GitVFSListener$3", "execute"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/vfs/GitVFSListener$3", "execute"));
                }
                File rootFile = new File(root.getPath());
                GitFileUtils.delete(GitVFSListener.this.myProject, root, files, "--ignore-unmatch");
                if (GitVFSListener.this.myProject != null && !GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
                for (FilePath p : files) {
                    for (File f = p.getIOFile(); f != null && !f.equals(rootFile); f = f.getParentFile()) {
                        this.filesToRefresh.add(f);
                    }
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return this.filesToRefresh;
            }
        });
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        ArrayList<FilePath> added = new ArrayList<FilePath>();
        ArrayList<FilePath> removed = new ArrayList<FilePath>();
        for (VcsVFSListener.MovedFileInfo info : movedFiles) {
            if (GitFileUtils.shouldIgnoreCaseChange(info.myNewPath, info.myOldPath)) continue;
            added.add(VcsUtil.getFilePath((String)info.myNewPath));
            removed.add(VcsUtil.getFilePath((String)info.myOldPath));
        }
        this.performAdding(added);
        this.performDeletion(removed);
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected Collection<FilePath> selectFilePathsToDelete(List<FilePath> deletedFiles) {
        return deletedFiles;
    }

    private void performBackgroundOperation(@NotNull Collection<FilePath> files, @NotNull String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/vfs/GitVFSListener", "performBackgroundOperation"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationTitle", "git4idea/vfs/GitVFSListener", "performBackgroundOperation"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "git4idea/vfs/GitVFSListener", "performBackgroundOperation"));
        }
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files, true);
        }
        catch (VcsException e) {
            this.gitVcs().showMessages(e.getMessage());
            return;
        }
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$4", "run"));
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        executor.execute((VirtualFile)e.getKey(), (List)e.getValue());
                    }
                    catch (VcsException ex) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GitVFSListener.this.gitVcs().showMessages(ex.getMessage());
                            }
                        });
                    }
                }
                LocalFileSystem.getInstance().refreshIoFiles(executor.getFilesToRefresh());
            }
        });
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<FilePath> var2) throws VcsException;

        public Collection<File> getFilesToRefresh();
    }
}

