/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitDebuggerRunner
extends GenericDebuggerRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/junit/JUnitDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/execution/junit/JUnitDebuggerRunner", "canRun"));
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof JUnitConfiguration;
    }

    @NotNull
    public String getRunnerId() {
        if ("JUnitDebug" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitDebuggerRunner", "getRunnerId"));
        }
        return "JUnitDebug";
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(final @NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/junit/JUnitDebuggerRunner", "createContentDescriptor"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/junit/JUnitDebuggerRunner", "createContentDescriptor"));
        }
        final RunContentDescriptor res = super.createContentDescriptor(state, environment);
        final ServerSocket socket = ((JavaTestFrameworkRunnableState)state).getForkSocket();
        if (socket != null) {
            Thread thread = new Thread("junit debugger runner"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Socket accept = socket.accept();
                        try {
                            DataInputStream stream = new DataInputStream(accept.getInputStream());
                            try {
                                int read = stream.readInt();
                                while (read != -1) {
                                    final DebugProcess process = DebuggerManager.getInstance((Project)environment.getProject()).getDebugProcess(res.getProcessHandler());
                                    if (process == null) {
                                        break;
                                    }
                                    RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", String.valueOf(read), true);
                                    DefaultDebugEnvironment env = new DefaultDebugEnvironment(environment, state, connection, true);
                                    SwingUtilities.invokeLater(new Runnable((DebugEnvironment)env, accept){
                                        final /* synthetic */ DebugEnvironment val$env;
                                        final /* synthetic */ Socket val$accept;
                                        {
                                            this.val$env = debugEnvironment;
                                            this.val$accept = socket;
                                        }

                                        @Override
                                        public void run() {
                                            try {
                                                ((DebugProcessImpl)process).reattach(this.val$env);
                                                this.val$accept.getOutputStream().write(0);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    read = stream.readInt();
                                }
                            }
                            finally {
                                stream.close();
                            }
                        }
                        finally {
                            accept.close();
                        }
                    }
                    catch (EOFException accept) {
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        return res;
    }
}

