/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.PsiLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;

public class PsiClassLocator
implements PsiLocator {
    private final String myName;
    private final String myPackage;

    private PsiClassLocator(String name, String aPackage) {
        this.myName = name;
        this.myPackage = aPackage;
    }

    public static PsiClassLocator fromQualifiedName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1 || lastDot == name.length() || name.endsWith("]") && name.contains("[")) {
            return new PsiClassLocator(name, "");
        }
        return new PsiClassLocator(name.substring(lastDot + 1), name.substring(0, lastDot));
    }

    public Location<PsiClass> getLocation(Project project, GlobalSearchScope searchScope) {
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)this.getQualifiedName(), (GlobalSearchScope)searchScope);
        return psiClass != null ? new PsiLocation(project, (PsiElement)psiClass) : null;
    }

    public String getPackage() {
        return this.myPackage;
    }

    public String getName() {
        return this.myName;
    }

    public String getQualifiedName() {
        return StringUtil.getQualifiedName((String)this.myPackage, (String)this.myName);
    }
}

