/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer<U, V>
implements Serializer<Map<U, V>> {
    private final Serializer<U> keySerializer;
    private final Serializer<V> valueSerializer;

    public MapSerializer(Serializer<U> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public Map<U, V> read(Decoder decoder) throws Exception {
        int size = decoder.readInt();
        LinkedHashMap<U, V> valueMap = new LinkedHashMap<U, V>(size);
        for (int i = 0; i < size; ++i) {
            U key = this.keySerializer.read(decoder);
            V value = this.valueSerializer.read(decoder);
            valueMap.put(key, value);
        }
        return valueMap;
    }

    @Override
    public void write(Encoder encoder, Map<U, V> value) throws Exception {
        encoder.writeInt(value.size());
        for (Map.Entry<U, V> entry : value.entrySet()) {
            try {
                this.keySerializer.write(encoder, entry.getKey());
                this.valueSerializer.write(encoder, entry.getValue());
            }
            catch (Exception e) {
                throw new EntrySerializationException(entry.getKey(), entry.getValue(), e);
            }
        }
    }

    public static class EntrySerializationException
    extends RuntimeException {
        private final Object key;
        private final Object value;

        EntrySerializationException(Object key, Object value, Exception cause) {
            super(String.format("Unable to write entry with key: '%s' and value: '%s'.", key, value), cause);
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

