/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltinsPackage$ReflectionTypes$33cea835;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.NamePackage$FqNamesUtil$0690fd89;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionTypes {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ReadOnlyProperty<? super Object, ? extends JetScope> kotlinReflectScope$delegate;
    @NotNull
    private final ClassLookup kClass$delegate;
    @NotNull
    private final ClassLookup kTopLevelVariable$delegate;
    @NotNull
    private final ClassLookup kMutableTopLevelVariable$delegate;
    @NotNull
    private final ClassLookup kMemberProperty$delegate;
    @NotNull
    private final ClassLookup kMutableMemberProperty$delegate;
    @NotNull
    private final ClassLookup kTopLevelExtensionProperty$delegate;
    @NotNull
    private final ClassLookup kMutableTopLevelExtensionProperty$delegate;
    private final ModuleDescriptor module;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReflectionTypes.class);
        OBJECT$ = Companion = kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes$Companion.access$init$0();
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("kotlinReflectScope"), new PropertyMetadataImpl("kClass"), new PropertyMetadataImpl("kTopLevelVariable"), new PropertyMetadataImpl("kMutableTopLevelVariable"), new PropertyMetadataImpl("kMemberProperty"), new PropertyMetadataImpl("kMutableMemberProperty"), new PropertyMetadataImpl("kTopLevelExtensionProperty"), new PropertyMetadataImpl("kMutableTopLevelExtensionProperty")};
    }

    private final JetScope getKotlinReflectScope() {
        return this.kotlinReflectScope$delegate.get(this, $propertyMetadata[0]);
    }

    @NotNull
    public final ClassDescriptor find(@JetValueParameter(name="className") @NotNull String className) {
        ClassDescriptor classDescriptor;
        ClassifierDescriptor classifierDescriptor;
        ClassifierDescriptor classifierDescriptor2;
        Intrinsics.checkParameterIsNotNull(className, "className");
        Name name = Name.identifier(className);
        JetScope jetScope = this.getKotlinReflectScope();
        if (jetScope != null) {
            Name name2 = name;
            Intrinsics.checkExpressionValueIsNotNull(name2, "name");
            classifierDescriptor2 = jetScope.getClassifier(name2);
        } else {
            classifierDescriptor2 = classifierDescriptor = null;
        }
        if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        if ((classDescriptor = (ClassDescriptor)classifierDescriptor) == null) {
            classDescriptor = ErrorUtils.createErrorClass(BuiltinsPackage$ReflectionTypes$33cea835.getKOTLIN_REFLECT_FQ_NAME().child(name).asString());
        }
        return classDescriptor;
    }

    @NotNull
    public final ClassDescriptor getKFunction(@JetValueParameter(name="n") int n) {
        return this.find("KFunction" + n);
    }

    @NotNull
    public final ClassDescriptor getKExtensionFunction(@JetValueParameter(name="n") int n) {
        return this.find("KExtensionFunction" + n);
    }

    @NotNull
    public final ClassDescriptor getKMemberFunction(@JetValueParameter(name="n") int n) {
        return this.find("KMemberFunction" + n);
    }

    @NotNull
    public final ClassDescriptor getkClass() {
        return this.kClass$delegate.get(this, $propertyMetadata[1]);
    }

    @NotNull
    public final ClassDescriptor getkTopLevelVariable() {
        return this.kTopLevelVariable$delegate.get(this, $propertyMetadata[2]);
    }

    @NotNull
    public final ClassDescriptor getkMutableTopLevelVariable() {
        return this.kMutableTopLevelVariable$delegate.get(this, $propertyMetadata[3]);
    }

    @NotNull
    public final ClassDescriptor getkMemberProperty() {
        return this.kMemberProperty$delegate.get(this, $propertyMetadata[4]);
    }

    @NotNull
    public final ClassDescriptor getkMutableMemberProperty() {
        return this.kMutableMemberProperty$delegate.get(this, $propertyMetadata[5]);
    }

    @NotNull
    public final ClassDescriptor getkTopLevelExtensionProperty() {
        return this.kTopLevelExtensionProperty$delegate.get(this, $propertyMetadata[6]);
    }

    @NotNull
    public final ClassDescriptor getkMutableTopLevelExtensionProperty() {
        return this.kMutableTopLevelExtensionProperty$delegate.get(this, $propertyMetadata[7]);
    }

    @NotNull
    public final JetType getKClassType(@JetValueParameter(name="annotations") @NotNull Annotations annotations2, @JetValueParameter(name="type") @NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor descriptor2 = this.getkClass();
        if (ErrorUtils.isError(descriptor2)) {
            JetType jetType = descriptor2.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "descriptor.getDefaultType()");
            return jetType;
        }
        List<TypeProjectionImpl> arguments2 = KotlinPackage.listOf(new TypeProjectionImpl(Variance.INVARIANT, type2));
        return new JetTypeImpl(annotations2, descriptor2.getTypeConstructor(), false, arguments2, descriptor2.getMemberScope(arguments2));
    }

    @NotNull
    public final JetType getKFunctionType(@JetValueParameter(name="annotations") @NotNull Annotations annotations2, @JetValueParameter(name="receiverType", type="?") @Nullable JetType receiverType, @JetValueParameter(name="parameterTypes") @NotNull List<? extends JetType> parameterTypes, @JetValueParameter(name="returnType") @NotNull JetType returnType, @JetValueParameter(name="extensionFunction") boolean extensionFunction) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(parameterTypes, "parameterTypes");
        Intrinsics.checkParameterIsNotNull(returnType, "returnType");
        int arity = parameterTypes.size();
        ClassDescriptor classDescriptor2 = extensionFunction ? this.getKExtensionFunction(arity) : (classDescriptor = receiverType != null ? this.getKMemberFunction(arity) : this.getKFunction(arity));
        if (ErrorUtils.isError(classDescriptor)) {
            JetType jetType = classDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "classDescriptor.getDefaultType()");
            return jetType;
        }
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType);
        return new JetTypeImpl(annotations2, classDescriptor.getTypeConstructor(), false, arguments2, classDescriptor.getMemberScope(arguments2));
    }

    @NotNull
    public final JetType getKPropertyType(@JetValueParameter(name="annotations") @NotNull Annotations annotations2, @JetValueParameter(name="receiverType", type="?") @Nullable JetType receiverType, @JetValueParameter(name="returnType") @NotNull JetType returnType, @JetValueParameter(name="extensionProperty") boolean extensionProperty, @JetValueParameter(name="mutable") boolean mutable) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(returnType, "returnType");
        ClassDescriptor classDescriptor2 = mutable ? (extensionProperty ? this.getkMutableTopLevelExtensionProperty() : (receiverType != null ? this.getkMutableMemberProperty() : this.getkMutableTopLevelVariable())) : (extensionProperty ? this.getkTopLevelExtensionProperty() : (classDescriptor = receiverType != null ? this.getkMemberProperty() : this.getkTopLevelVariable()));
        if (ErrorUtils.isError(classDescriptor)) {
            JetType jetType = classDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "classDescriptor.getDefaultType()");
            return jetType;
        }
        ArrayList<TypeProjectionImpl> arguments2 = new ArrayList<TypeProjectionImpl>(2);
        if (receiverType != null) {
            arguments2.add(new TypeProjectionImpl(receiverType));
        }
        arguments2.add(new TypeProjectionImpl(returnType));
        return new JetTypeImpl(annotations2, classDescriptor.getTypeConstructor(), false, (List<? extends TypeProjection>)arguments2, classDescriptor.getMemberScope((List<? extends TypeProjection>)arguments2));
    }

    public ReflectionTypes(@JetValueParameter(name="module") @NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        this.module = module;
        this.kotlinReflectScope$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<JetScope>(this){
            final /* synthetic */ ReflectionTypes this$0;

            @Nullable
            public final JetScope invoke() {
                PackageViewDescriptor packageViewDescriptor = ReflectionTypes.access$getModule$0(this.this$0).getPackage(BuiltinsPackage$ReflectionTypes$33cea835.getKOTLIN_REFLECT_FQ_NAME());
                return packageViewDescriptor != null ? packageViewDescriptor.getMemberScope() : null;
            }
            {
                this.this$0 = reflectionTypes;
                super(0);
            }
        });
        this.kClass$delegate = ClassLookup.INSTANCE$;
        this.kTopLevelVariable$delegate = ClassLookup.INSTANCE$;
        this.kMutableTopLevelVariable$delegate = ClassLookup.INSTANCE$;
        this.kMemberProperty$delegate = ClassLookup.INSTANCE$;
        this.kMutableMemberProperty$delegate = ClassLookup.INSTANCE$;
        this.kTopLevelExtensionProperty$delegate = ClassLookup.INSTANCE$;
        this.kMutableTopLevelExtensionProperty$delegate = ClassLookup.INSTANCE$;
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModule$0(@JetValueParameter(name="$this", type="?") ReflectionTypes $this) {
        return $this.module;
    }

    private static final class ClassLookup {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final ClassLookup INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(ClassLookup.class);
            new ClassLookup();
        }

        @NotNull
        public final ClassDescriptor get(@JetValueParameter(name="types") @NotNull ReflectionTypes types, @JetValueParameter(name="property") @NotNull PropertyMetadata property) {
            Intrinsics.checkParameterIsNotNull(types, "types");
            Intrinsics.checkParameterIsNotNull(property, "property");
            return types.find(KotlinPackage.capitalize(property.getName()));
        }

        ClassLookup() {
            INSTANCE$ = this;
        }
    }

    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        public final boolean isReflectionType(@JetValueParameter(name="type") @NotNull JetType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                return false;
            }
            ClassifierDescriptor descriptor2 = classifierDescriptor;
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
            return fqName2.isSafe() && NamePackage$FqNamesUtil$0690fd89.isSubpackageOf(fqName2.toSafe(), BuiltinsPackage$ReflectionTypes$33cea835.getKOTLIN_REFLECT_FQ_NAME());
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }
}

