/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor$$TImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.PlatformToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.ImportPath;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor,
ModuleParameters {
    public static final /* synthetic */ KClass $kotlinClass;
    private boolean isSealed;
    private final List<ModuleDescriptorImpl> dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private final ReadOnlyProperty<? super Object, ? extends CompositePackageFragmentProvider> packageFragmentProviderForWholeModuleWithDependencies$delegate;
    private final LinkedHashSet<ModuleDescriptor> friendModules;
    private final StorageManager storageManager;
    private final ModuleParameters moduleParameters;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(ModuleDescriptorImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("packageFragmentProviderForWholeModuleWithDependencies")};
    }

    public final void seal() {
        if (this.isSealed) {
            return;
        }
        boolean value = this.dependencies.contains(this);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Module " + this.getId() + " is not contained in his own dependencies, this is probably a misconfiguration";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.isSealed = true;
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        return this.packageFragmentProviderForWholeModuleWithDependencies$delegate.get(this, $propertyMetadata[0]);
    }

    public final boolean getIsInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    public final void addDependencyOnModule(@JetValueParameter(name="dependency") @NotNull ModuleDescriptorImpl dependency) {
        Intrinsics.checkParameterIsNotNull(dependency, "dependency");
        boolean value = !this.isSealed;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Can't modify dependencies of sealed module " + this.getId();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        value = this.dependencies.contains(dependency) ^ true;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Trying to add dependency on module " + dependency.getId() + " a second time for module " + this.getId() + ", this is probably a misconfiguration";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.dependencies.add(dependency);
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "getName().toString()");
        return string;
    }

    public final void initialize(@JetValueParameter(name="providerForModuleContent") @NotNull PackageFragmentProvider providerForModuleContent) {
        Intrinsics.checkParameterIsNotNull(providerForModuleContent, "providerForModuleContent");
        boolean value = !this.getIsInitialized();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Attempt to initialize module " + this.getId() + " twice";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.packageFragmentProviderForModuleContent = providerForModuleContent;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@JetValueParameter(name="fqName") @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<PackageFragmentDescriptor> fragments = this.getPackageFragmentProviderForWholeModuleWithDependencies().getPackageFragments(fqName2);
        return !fragments.isEmpty() ? new PackageViewDescriptorImpl(this, fqName2, fragments) : (PackageViewDescriptorImpl)null;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@JetValueParameter(name="fqName") @NotNull FqName fqName2, @JetValueParameter(name="nameFilter") @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        return this.getPackageFragmentProviderForWholeModuleWithDependencies().getSubPackagesOf(fqName2, nameFilter);
    }

    @Override
    public boolean isFriend(@JetValueParameter(name="other") @NotNull ModuleDescriptor other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return Intrinsics.areEqual(other, this) || this.friendModules.contains(other);
    }

    public final void addFriend(@JetValueParameter(name="friend") @NotNull ModuleDescriptorImpl friend) {
        Intrinsics.checkParameterIsNotNull(friend, "friend");
        boolean value = Intrinsics.areEqual(friend, this) ^ true;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Attempt to make module " + this.getId() + " a friend to itself";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        value = !this.isSealed;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Attempt to add friend module " + friend.getId() + " to sealed module " + this.getId();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.friendModules.add(friend);
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "KotlinBuiltIns.getInstance()");
        return kotlinBuiltIns;
    }

    public ModuleDescriptorImpl(@JetValueParameter(name="moduleName") @NotNull Name moduleName, @JetValueParameter(name="storageManager") @NotNull StorageManager storageManager, @JetValueParameter(name="moduleParameters") @NotNull ModuleParameters moduleParameters) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(moduleParameters, "moduleParameters");
        super(Annotations.Companion.getEMPTY(), moduleName);
        this.storageManager = storageManager;
        this.moduleParameters = moduleParameters;
        if (!moduleName.isSpecial()) {
            throw (Throwable)new IllegalArgumentException("Module name must be special: " + moduleName);
        }
        this.dependencies = new ArrayList();
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<CompositePackageFragmentProvider>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CompositePackageFragmentProvider invoke() {
                void var3_3;
                Collection<PackageFragmentProvider> collection;
                void $receiver;
                CompositePackageFragmentProvider compositePackageFragmentProvider;
                this.this$0.seal();
                Iterable $receiver2 = ModuleDescriptorImpl.access$getDependencies$1(this.this$0);
                for (T element : $receiver2) {
                    void value;
                    ModuleDescriptorImpl dependency = (ModuleDescriptorImpl)element;
                    boolean bl = dependency.getIsInitialized();
                    if (!KotlinPackage.getASSERTIONS_ENABLED() || value != false) continue;
                    String message = "Dependency module " + ModuleDescriptorImpl.access$getId$0(dependency) + " was not initialized by the time contents of dependent module " + ModuleDescriptorImpl.access$getId$0(this.this$0) + " were queried";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                $receiver2 = ModuleDescriptorImpl.access$getDependencies$1(this.this$0);
                CompositePackageFragmentProvider compositePackageFragmentProvider2 = compositePackageFragmentProvider;
                CompositePackageFragmentProvider compositePackageFragmentProvider3 = compositePackageFragmentProvider;
                Iterable iterable = $receiver2;
                Collection destination = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
                for (T item : $receiver) {
                    PackageFragmentProvider packageFragmentProvider;
                    void it;
                    ModuleDescriptorImpl message = (ModuleDescriptorImpl)item;
                    collection = destination;
                    if (ModuleDescriptorImpl.access$getPackageFragmentProviderForModuleContent$2((ModuleDescriptorImpl)it) == null) {
                        Intrinsics.throwNpe();
                    }
                    collection.add(packageFragmentProvider);
                }
                collection = (List)var3_3;
                compositePackageFragmentProvider2((List<? extends PackageFragmentProvider>)collection);
                return compositePackageFragmentProvider3;
            }
            {
                this.this$0 = moduleDescriptorImpl;
                super(0);
            }
        });
        this.friendModules = new LinkedHashSet();
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor$$TImpl.getContainingDeclaration(this);
    }

    @Override
    public <R, D> R accept(@JetValueParameter(name="visitor") DeclarationDescriptorVisitor<R, D> visitor, @JetValueParameter(name="data") D data2) {
        return ModuleDescriptor$$TImpl.accept(this, visitor, data2);
    }

    @Override
    @NotNull
    public ModuleDescriptor substitute(@JetValueParameter(name="substitutor") @NotNull TypeSubstitutor substitutor) {
        Intrinsics.checkParameterIsNotNull(substitutor, "substitutor");
        return ModuleDescriptor$$TImpl.substitute(this, substitutor);
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports() {
        return this.moduleParameters.getDefaultImports();
    }

    @Override
    @NotNull
    public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
        return this.moduleParameters.getPlatformToKotlinClassMap();
    }

    @NotNull
    public static final /* synthetic */ List<ModuleDescriptorImpl> access$getDependencies$1(@JetValueParameter(name="$this", type="?") ModuleDescriptorImpl $this) {
        return $this.dependencies;
    }

    @Nullable
    public static final /* synthetic */ PackageFragmentProvider access$getPackageFragmentProviderForModuleContent$2(@JetValueParameter(name="$this", type="?") ModuleDescriptorImpl $this) {
        return $this.packageFragmentProviderForModuleContent;
    }

    public static final /* synthetic */ void access$setPackageFragmentProviderForModuleContent$2(@JetValueParameter(name="$this", type="?") ModuleDescriptorImpl $this, @JetValueParameter(name="<set-?>", type="?") @Nullable PackageFragmentProvider packageFragmentProvider) {
        $this.packageFragmentProviderForModuleContent = packageFragmentProvider;
    }
}

