/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.intellij.rt.execution.junit.ComparisonFailureData;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.MapSerializerUtil;
import org.testng.TestNGExpectedPatterns;
import org.testng.internal.IResultListener;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEATestNGRemoteListener
implements ISuiteListener,
IResultListener {
    private final PrintStream myPrintStream;
    private final List<String> myCurrentSuites = new ArrayList<String>();
    private final Map<String, Integer> myInvocationCounts = new HashMap<String, Integer>();
    private final Map<ExposedTestResult, String> myParamsMap = new HashMap<ExposedTestResult, String>();

    public IDEATestNGRemoteListener() {
        this.myPrintStream = System.out;
    }

    public IDEATestNGRemoteListener(PrintStream printStream) {
        this.myPrintStream = printStream;
    }

    public synchronized void onStart(ISuite suite) {
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
        if (suite != null) {
            this.myPrintStream.println("##teamcity[rootName name = '" + suite.getName() + "' location = 'file://" + suite.getXmlSuite().getFileName() + "']");
        }
    }

    public synchronized void onFinish(ISuite suite) {
        for (int i = this.myCurrentSuites.size() - 1; i >= 0; --i) {
            this.onSuiteFinish(this.myCurrentSuites.remove(i));
        }
        this.myCurrentSuites.clear();
    }

    public synchronized void onConfigurationSuccess(ITestResult result) {
        this.onConfigurationSuccess(new DelegatedResult(result));
    }

    public synchronized void onConfigurationFailure(ITestResult result) {
        this.onConfigurationFailure(new DelegatedResult(result));
    }

    public synchronized void onConfigurationSkip(ITestResult itr) {
    }

    public synchronized void onTestStart(ITestResult result) {
        this.onTestStart(new DelegatedResult(result));
    }

    public synchronized void onTestSuccess(ITestResult result) {
        this.onTestFinished(new DelegatedResult(result));
    }

    public synchronized void onTestFailure(ITestResult result) {
        this.onTestFailure(new DelegatedResult(result));
    }

    public synchronized void onTestSkipped(ITestResult result) {
        this.onTestSkipped(new DelegatedResult(result));
    }

    public synchronized void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            throwable.printStackTrace();
        }
        this.onTestSuccess(result);
    }

    public synchronized void onStart(ITestContext context) {
    }

    public synchronized void onFinish(ITestContext context) {
    }

    public void onTestStart(ExposedTestResult result) {
        Object[] parameters = result.getParameters();
        String qualifiedName = result.getClassName() + result.getMethodName();
        Integer invocationCount = this.myInvocationCounts.get(qualifiedName);
        if (invocationCount == null) {
            invocationCount = 0;
        }
        String paramString = IDEATestNGRemoteListener.getParamsString(parameters, invocationCount);
        this.onTestStart(result, paramString, invocationCount, false);
        this.myInvocationCounts.put(qualifiedName, invocationCount + 1);
    }

    public void onConfigurationSuccess(ExposedTestResult result) {
        this.onTestStart(result, null, -1, true);
        this.onTestFinished(result);
    }

    public void onConfigurationFailure(ExposedTestResult result) {
        this.onTestStart(result, null, -1, true);
        this.onTestFailure(result);
    }

    public boolean onSuiteStart(String classFQName, boolean provideLocation) {
        return this.onSuiteStart(Collections.singletonList(classFQName), null, provideLocation);
    }

    public boolean onSuiteStart(List<String> parentsHierarchy, ExposedTestResult result, boolean provideLocation) {
        int i;
        String currentParent;
        String currentClass;
        int idx;
        for (idx = 0; idx < this.myCurrentSuites.size() && idx < parentsHierarchy.size() && (currentClass = this.myCurrentSuites.get(idx)).equals(IDEATestNGRemoteListener.getShortName(currentParent = parentsHierarchy.get(parentsHierarchy.size() - 1 - idx))); ++idx) {
        }
        for (i = this.myCurrentSuites.size() - 1; i >= idx; --i) {
            currentClass = this.myCurrentSuites.remove(i);
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + IDEATestNGRemoteListener.escapeName(currentClass) + "']");
        }
        for (i = idx; i < parentsHierarchy.size(); ++i) {
            String fileName;
            String testName;
            String fqName = parentsHierarchy.get(parentsHierarchy.size() - 1 - i);
            String currentClassName = IDEATestNGRemoteListener.getShortName(fqName);
            String location = "java:suite://" + IDEATestNGRemoteListener.escapeName(fqName);
            if (result != null && fqName.equals(testName = result.getXmlTestName()) && (fileName = result.getFileName()) != null) {
                location = "file://" + fileName;
            }
            this.myPrintStream.println("\n##teamcity[testSuiteStarted name ='" + IDEATestNGRemoteListener.escapeName(currentClassName) + (provideLocation ? "' locationHint = '" + location : "") + "']");
            this.myCurrentSuites.add(currentClassName);
        }
        return false;
    }

    public void onSuiteFinish(String suiteName) {
        this.myPrintStream.println("##teamcity[testSuiteFinished name='" + IDEATestNGRemoteListener.escapeName(suiteName) + "']");
    }

    private void onTestStart(ExposedTestResult result, String paramString, Integer invocationCount, boolean config) {
        if (!config) {
            this.myPrintStream.println("##teamcity[testCount count='1']");
        }
        this.myParamsMap.put(result, paramString);
        this.onSuiteStart(result.getTestHierarchy(), result, true);
        String className = result.getClassName();
        String methodName = result.getMethodName();
        String location = className + "." + methodName + (invocationCount >= 0 ? "[" + invocationCount + "]" : "");
        this.myPrintStream.println("\n##teamcity[testStarted name='" + IDEATestNGRemoteListener.escapeName(IDEATestNGRemoteListener.getShortName(className) + "." + methodName + (paramString != null ? paramString : "")) + "' locationHint='java:test://" + IDEATestNGRemoteListener.escapeName(location) + (config ? "' config='true" : "") + "']");
    }

    public void onTestFailure(ExposedTestResult result) {
        ComparisonFailureData notification;
        if (!this.myParamsMap.containsKey(result)) {
            this.onTestStart(result);
        }
        Throwable ex = result.getThrowable();
        String methodName = this.getTestMethodNameWithParams(result);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", methodName);
        String failureMessage = ex.getMessage();
        try {
            notification = TestNGExpectedPatterns.createExceptionNotification(failureMessage);
        }
        catch (Throwable e) {
            notification = null;
        }
        ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)this.getTrace(ex), (String)failureMessage, attrs, (Throwable)ex);
        this.myPrintStream.println(MapSerializerUtil.asString("testFailed", attrs));
        this.onTestFinished(result);
    }

    public void onTestSkipped(ExposedTestResult result) {
        if (!this.myParamsMap.containsKey(result)) {
            this.onTestStart(result);
        }
        this.myPrintStream.println("\n##teamcity[testIgnored name='" + IDEATestNGRemoteListener.escapeName(this.getTestMethodNameWithParams(result)) + "']");
        this.onTestFinished(result);
    }

    public void onTestFinished(ExposedTestResult result) {
        long duration = result.getDuration();
        this.myPrintStream.println("\n##teamcity[testFinished name='" + IDEATestNGRemoteListener.escapeName(this.getTestMethodNameWithParams(result)) + (duration > 0L ? "' duration='" + Long.toString(duration) : "") + "']");
    }

    private synchronized String getTestMethodNameWithParams(ExposedTestResult result) {
        String methodName = IDEATestNGRemoteListener.getShortName(result.getClassName()) + "." + result.getMethodName();
        String paramString = this.myParamsMap.get(result);
        if (paramString != null) {
            methodName = methodName + paramString;
        }
        return methodName;
    }

    private static String getParamsString(Object[] parameters, int invocationCount) {
        String paramString = "";
        if (parameters.length > 0) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(parameters[i]);
            }
            paramString = "[" + buf.toString() + "]";
        }
        if (invocationCount > 0) {
            paramString = paramString + " (" + invocationCount + ")";
        }
        return paramString.length() > 0 ? paramString : null;
    }

    protected String getTrace(Throwable tr) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        tr.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    protected static String getShortName(String fqName) {
        int lastPointIdx = fqName.lastIndexOf(46);
        if (lastPointIdx >= 0) {
            return fqName.substring(lastPointIdx + 1);
        }
        return fqName;
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr(str, MapSerializerUtil.STD_ESCAPER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatedResult
    implements ExposedTestResult {
        private final ITestResult myResult;

        public DelegatedResult(ITestResult result) {
            this.myResult = result;
        }

        @Override
        public Object[] getParameters() {
            return this.myResult.getParameters();
        }

        @Override
        public String getMethodName() {
            return this.myResult.getMethod().getMethodName();
        }

        @Override
        public String getClassName() {
            return this.myResult.getMethod().getTestClass().getName();
        }

        @Override
        public long getDuration() {
            return this.myResult.getEndMillis() - this.myResult.getStartMillis();
        }

        @Override
        public List<String> getTestHierarchy() {
            XmlTest xmlTest = this.myResult.getTestClass().getXmlTest();
            List<String> hierarchy = xmlTest != null ? Arrays.asList(this.getClassName(), xmlTest.getName()) : Collections.singletonList(this.getClassName());
            return hierarchy;
        }

        @Override
        public String getFileName() {
            XmlTest xmlTest = this.myResult.getTestClass().getXmlTest();
            return xmlTest != null ? xmlTest.getSuite().getFileName() : null;
        }

        @Override
        public String getXmlTestName() {
            XmlTest xmlTest = this.myResult.getTestClass().getXmlTest();
            return xmlTest != null ? xmlTest.getName() : null;
        }

        @Override
        public Throwable getThrowable() {
            return this.myResult.getThrowable();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myResult.equals(((DelegatedResult)o).myResult);
        }

        public int hashCode() {
            return this.myResult.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExposedTestResult {
        public Object[] getParameters();

        public String getMethodName();

        public String getClassName();

        public long getDuration();

        public List<String> getTestHierarchy();

        public String getFileName();

        public String getXmlTestName();

        public Throwable getThrowable();
    }
}

