/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestDetector
extends Detector
implements Detector.XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ManifestDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue ORDER = Issue.create("ManifestOrder", "Incorrect order of elements in manifest", "The <application> tag should appear after the elements which declare which version you need, which features you need, which libraries you need, and so on. In the past there have been subtle bugs (such as themes not getting applied correctly) when the `<application>` tag appears before some of these other elements, so it's best to order your manifest in the logical dependency order.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USES_SDK = Issue.create("UsesMinSdkAttributes", "Minimum SDK and target SDK attributes not defined", "The manifest should contain a `<uses-sdk>` element which defines the minimum API Level required for the application to run, as well as the target version (the highest API level you have tested the version for.)", Category.CORRECTNESS, 9, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/uses-sdk-element.html");
    public static final Issue TARGET_NEWER = Issue.create("OldTargetApi", "Target SDK attribute is not targeting latest version", "When your application runs on a version of Android that is more recent than your `targetSdkVersion` specifies that it has been tested with, various compatibility modes kick in. This ensures that your application continues to work, but it may look out of place. For example, if the `targetSdkVersion` is less than 14, your app may get an option button in the UI.\n\nTo fix this issue, set the `targetSdkVersion` to the highest available value. Then test your app to make sure everything works correctly. You may want to consult the compatibility notes to see what changes apply to each version you are adding support for: http://developer.android.com/reference/android/os/Build.VERSION_CODES.html", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/android/os/Build.VERSION_CODES.html");
    public static final Issue MULTIPLE_USES_SDK = Issue.create("MultipleUsesSdk", "Multiple `<uses-sdk>` elements in the manifest", "The `<uses-sdk>` element should appear just once; the tools will *not* merge the contents of all the elements so if you split up the attributes across multiple elements, only one of them will take effect. To fix this, just merge all the attributes from the various elements into a single <uses-sdk> element.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/uses-sdk-element.html");
    public static final Issue WRONG_PARENT = Issue.create("WrongManifestParent", "Wrong manifest parent", "The `<uses-library>` element should be defined as a direct child of the `<application>` tag, not the `<manifest>` tag or an `<activity>` tag. Similarly, a `<uses-sdk>` tag much be declared at the root level, and so on. This check looks for incorrect declaration locations in the manifest, and complains if an element is found in the wrong place.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    public static final Issue DUPLICATE_ACTIVITY = Issue.create("DuplicateActivity", "Activity registered more than once", "An activity should only be registered once in the manifest. If it is accidentally registered more than once, then subtle errors can occur, since attribute declarations from the two elements are not merged, so you may accidentally remove previous declarations.", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
    public static final Issue ALLOW_BACKUP = Issue.create("AllowBackup", "Missing `allowBackup` attribute", "The allowBackup attribute determines if an application's data can be backed up and restored. It is documented at http://developer.android.com/reference/android/R.attr.html#allowBackup\n\nBy default, this flag is set to `true`. When this flag is set to `true`, application data can be backed up and restored by the user using `adb backup` and `adb restore`.\n\nThis may have security consequences for an application. `adb backup` allows users who have enabled USB debugging to copy application data off of the device. Once backed up, all application data can be read by the user. `adb restore` allows creation of application data from a source specified by the user. Following a restore, applications should not assume that the data, file permissions, and directory permissions were created by the application itself.\n\nSetting `allowBackup=\"false\"` opts an application out of both backup and restore.\n\nTo fix this warning, decide whether your application should support backup, and explicitly set `android:allowBackup=(true|false)\"`", Category.SECURITY, 3, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/android/R.attr.html#allowBackup");
    public static final Issue UNIQUE_PERMISSION = Issue.create("UniquePermission", "Permission names are not unique", "The unqualified names or your permissions must be unique. The reason for this is that at build time, the `aapt` tool will generate a class named `Manifest` which contains a field for each of your permissions. These fields are named using your permission unqualified names (i.e. the name portion after the last dot).\n\nIf more than one permission maps to the same field name, that field will arbitrarily name just one of them.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue SET_VERSION = Issue.create("MissingVersion", "Missing application name/version", "You should define the version information for your application.\n`android:versionCode`: An integer value that represents the version of the application code, relative to other versions.\n\n`android:versionName`: A string value that represents the release version of the application code, as it should be shown to users.", Category.CORRECTNESS, 2, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/tools/publishing/versioning.html#appversioning");
    public static final Issue ILLEGAL_REFERENCE = Issue.create("IllegalResourceRef", "Name and version must be integer or string, not resource", "For the `versionCode` attribute, you have to specify an actual integer literal; you cannot use an indirection with a `@dimen/name` resource. Similarly, the `versionName` attribute should be an actual string, not a string resource url.", Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION);
    public static final Issue DUPLICATE_USES_FEATURE = Issue.create("DuplicateUsesFeature", "Feature declared more than once", "A given feature should only be declared once in the manifest.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
    public static final Issue APPLICATION_ICON = Issue.create("MissingApplicationIcon", "Missing application icon", "You should set an icon for the application as whole because there is no default. This attribute must be set as a reference to a drawable resource containing the image (for example `@drawable/icon`).", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/tools/publishing/preparing.html#publishing-configure");
    public static final Issue DEVICE_ADMIN = Issue.create("DeviceAdmin", "Malformed Device Admin", "If you register a broadcast receiver which acts as a device admin, you must also register an `<intent-filter>` for the action `android.app.action.DEVICE_ADMIN_ENABLED`, without any `<data>`, such that the device admin can be activated/deactivated.\n\nTo do this, add\n`<intent-filter>`\n    `<action android:name=\"android.app.action.DEVICE_ADMIN_ENABLED\" />`\n`</intent-filter>`\nto your `<receiver>`.", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue MOCK_LOCATION = Issue.create("MockLocation", "Using mock location provider in production", "Using a mock location provider (by requiring the permission `android.permission.ACCESS_MOCK_LOCATION`) should *only* be done in debug builds (or from tests). In Gradle projects, that means you should only request this permission in a test or debug source set specific manifest file.\n\nTo fix this, create a new manifest file in the debug folder and move the `<uses-permission>` element there. A typical path to a debug manifest override file in a Gradle project is src/debug/AndroidManifest.xml.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    public static final Issue GRADLE_OVERRIDES = Issue.create("GradleOverrides", "Value overridden by Gradle build script", "The value of (for example) `minSdkVersion` is only used if it is not specified in the `build.gradle` build scripts. When specified in the Gradle build scripts, the manifest value is ignored and can be misleading, so should be removed to avoid ambiguity.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
    public static final Issue MIPMAP = Issue.create("MipmapIcons", "Use Mipmap Launcher Icons", "Launcher icons should be provided in the `mipmap` resource directory. This is the same as the `drawable` resource directory, except resources in the `mipmap` directory will not get stripped out when creating density-specific APKs.\n\nIn certain cases, the Launcher app may use a higher resolution asset (than would normally be computed for the device) to display large app shortcuts. If drawables for densities other than the device's resolution have been stripped out, then the app shortcut could appear blurry.\n\nTo fix this, move your launcher icons from `drawable-`dpi to `mipmap-`dpi and change references from @drawable/ and R.drawable to @mipmap/ and R.mipmap.\nIn Android Studio this lint warning has a quickfix to perform this automatically.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION);
    public static final String MOCK_LOCATION_PERMISSION = "android.permission.ACCESS_MOCK_LOCATION";
    private boolean mSeenApplication;
    private int mSeenUsesSdk;
    private Set<String> mActivities;
    private Set<String> mUsesFeatures;
    private Map<String, String> mPermissionNames;
    private Location.Handle mApplicationTagHandle;
    private boolean mSeenAppIcon;
    private boolean mSeenAllowBackup;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        this.mSeenApplication = false;
        this.mSeenUsesSdk = 0;
        this.mActivities = new HashSet<String>();
        this.mUsesFeatures = new HashSet<String>();
    }

    @Override
    public void afterCheckFile(@NonNull Context context) {
        XmlContext xmlContext = (XmlContext)context;
        Element element = xmlContext.document.getDocumentElement();
        if (element != null) {
            ManifestDetector.checkDocumentElement(xmlContext, element);
        }
        if (this.mSeenUsesSdk == 0 && context.isEnabled(USES_SDK) && !context.getMainProject().isGradleProject()) {
            context.report(USES_SDK, Location.create(context.file), "Manifest should specify a minimum API level with `<uses-sdk android:minSdkVersion=\"?\" />`; if it really supports all versions of Android set it to 1.");
        }
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        Location location;
        if (!this.mSeenAllowBackup && context.isEnabled(ALLOW_BACKUP) && !context.getProject().isLibrary() && context.getMainProject().getMinSdk() >= 4) {
            location = this.getMainApplicationTagLocation(context);
            context.report(ALLOW_BACKUP, location, "Should explicitly set `android:allowBackup` to `true` or `false` (it's `true` by default, and that can have some security implications for the application's data)");
        }
        if (!context.getMainProject().isLibrary() && !this.mSeenAppIcon && context.isEnabled(APPLICATION_ICON)) {
            location = this.getMainApplicationTagLocation(context);
            context.report(APPLICATION_ICON, location, "Should explicitly set `android:icon`, there is no default");
        }
    }

    @Nullable
    private Location getMainApplicationTagLocation(@NonNull Context context) {
        if (this.mApplicationTagHandle != null) {
            return this.mApplicationTagHandle.resolve();
        }
        List<File> manifestFiles = context.getMainProject().getManifestFiles();
        if (!manifestFiles.isEmpty()) {
            return Location.create(manifestFiles.get(0));
        }
        return null;
    }

    private static void checkDocumentElement(XmlContext context, Element element) {
        String pkg;
        Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionCode");
        if (codeNode != null && codeNode.getValue().startsWith("@") && context.isEnabled(ILLEGAL_REFERENCE)) {
            context.report(ILLEGAL_REFERENCE, element, context.getLocation(codeNode), "The `android:versionCode` cannot be a resource url, it must be a literal integer");
        } else if (codeNode == null && context.isEnabled(SET_VERSION) && !context.getMainProject().isGradleProject()) {
            context.report(SET_VERSION, element, context.getLocation(element), "Should set `android:versionCode` to specify the application version");
        }
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionName");
        if (nameNode == null && context.isEnabled(SET_VERSION) && !context.getMainProject().isGradleProject()) {
            context.report(SET_VERSION, element, context.getLocation(element), "Should set `android:versionName` to specify the application version");
        }
        ManifestDetector.checkOverride(context, element, "versionCode");
        ManifestDetector.checkOverride(context, element, "versionName");
        Attr pkgNode = element.getAttributeNode("package");
        if (pkgNode != null && (pkg = pkgNode.getValue()).contains("${") && context.getMainProject().isGradleProject()) {
            context.report(GRADLE_OVERRIDES, pkgNode, context.getLocation(pkgNode), "Cannot use placeholder for the package in the manifest; set `applicationId` in `build.gradle` instead");
        }
    }

    private static void checkOverride(XmlContext context, Element element, String attributeName) {
        Variant variant;
        Project project = context.getProject();
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (project.isGradleProject() && attribute != null && context.isEnabled(GRADLE_OVERRIDES) && (variant = project.getCurrentVariant()) != null) {
            ProductFlavor flavor = variant.getMergedFlavor();
            String gradleValue = null;
            if ("minSdkVersion".equals(attributeName)) {
                try {
                    ApiVersion minSdkVersion = flavor.getMinSdkVersion();
                    gradleValue = minSdkVersion != null ? minSdkVersion.getApiString() : null;
                }
                catch (Throwable minSdkVersion) {}
            } else if ("targetSdkVersion".equals(attributeName)) {
                try {
                    ApiVersion targetSdkVersion = flavor.getTargetSdkVersion();
                    gradleValue = targetSdkVersion != null ? targetSdkVersion.getApiString() : null;
                }
                catch (Throwable targetSdkVersion) {}
            } else if ("versionCode".equals(attributeName)) {
                Integer versionCode = flavor.getVersionCode();
                if (versionCode != null) {
                    gradleValue = versionCode.toString();
                }
            } else if ("versionName".equals(attributeName)) {
                gradleValue = flavor.getVersionName();
            } else {
                assert (false) : attributeName;
                return;
            }
            if (gradleValue != null) {
                String manifestValue = attribute.getValue();
                String message = String.format("This `%1$s` value (`%2$s`) is not used; it is always overridden by the value specified in the Gradle build script (`%3$s`)", attributeName, manifestValue, gradleValue);
                context.report(GRADLE_OVERRIDES, attribute, context.getLocation(attribute), message);
            }
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "uses-permission", "permission", "permission-tree", "permission-group", "uses-sdk", "uses-configuration", "uses-feature", "supports-screens", "compatible-screens", "supports-gl-texture", "uses-library", "activity", "service", "provider", "receiver");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        Attr name;
        String name2;
        Attr nameNode;
        String tag = element.getTagName();
        Node parentNode = element.getParentNode();
        boolean isReceiver = tag.equals("receiver");
        if (isReceiver) {
            ManifestDetector.checkDeviceAdmin(context, element);
        }
        if (tag.equals("uses-library") || tag.equals("activity") || tag.equals("service") || tag.equals("provider") || isReceiver) {
            if (!"application".equals(parentNode.getNodeName()) && context.isEnabled(WRONG_PARENT)) {
                context.report(WRONG_PARENT, element, context.getLocation(element), String.format("The `<%1$s>` element must be a direct child of the <application> element", tag));
            }
            if (tag.equals("activity")) {
                String name3;
                Attr nameNode2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameNode2 != null && !(name3 = nameNode2.getValue()).isEmpty()) {
                    String pkg = context.getMainProject().getPackage();
                    if (name3.charAt(0) == '.') {
                        name3 = pkg + name3;
                    } else if (name3.indexOf(46) == -1) {
                        name3 = pkg + '.' + name3;
                    }
                    if (this.mActivities.contains(name3)) {
                        String message = String.format("Duplicate registration for activity `%1$s`", name3);
                        context.report(DUPLICATE_ACTIVITY, element, context.getLocation(nameNode2), message);
                    } else {
                        this.mActivities.add(name3);
                    }
                }
                ManifestDetector.checkMipmapIcon(context, element);
            }
            return;
        }
        if (parentNode != element.getOwnerDocument().getDocumentElement() && context.isEnabled(WRONG_PARENT)) {
            context.report(WRONG_PARENT, element, context.getLocation(element), String.format("The `<%1$s>` element must be a direct child of the `<manifest>` root element", tag));
        }
        if (tag.equals("uses-sdk")) {
            ++this.mSeenUsesSdk;
            if (this.mSeenUsesSdk == 2) {
                Location location = context.getLocation(element);
                NodeList elements = element.getOwnerDocument().getElementsByTagName("uses-sdk");
                Location secondary = null;
                for (int i = elements.getLength() - 1; i >= 0; --i) {
                    Element e = (Element)elements.item(i);
                    if (e == element) continue;
                    Location l = context.getLocation(e);
                    l.setSecondary(secondary);
                    l.setMessage("Also appears here");
                    secondary = l;
                }
                location.setSecondary(secondary);
                if (context.isEnabled(MULTIPLE_USES_SDK)) {
                    context.report(MULTIPLE_USES_SDK, element, location, "There should only be a single `<uses-sdk>` element in the manifest: merge these together");
                }
                return;
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                if (context.isEnabled(USES_SDK) && !context.getMainProject().isGradleProject()) {
                    context.report(USES_SDK, element, context.getLocation(element), "`<uses-sdk>` tag should specify a minimum API level with `android:minSdkVersion=\"?\"`");
                }
            } else {
                Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
                if (codeNode != null && codeNode.getValue().startsWith("@") && context.isEnabled(ILLEGAL_REFERENCE)) {
                    context.report(ILLEGAL_REFERENCE, element, context.getLocation(codeNode), "The `android:minSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)");
                }
                ManifestDetector.checkOverride(context, element, "minSdkVersion");
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                if (context.isEnabled(USES_SDK) && !context.getMainProject().isGradleProject()) {
                    context.report(USES_SDK, element, context.getLocation(element), "`<uses-sdk>` tag should specify a target API level (the highest verified version; when running on later versions, compatibility behaviors may be enabled) with `android:targetSdkVersion=\"?\"`");
                }
            } else {
                Attr targetSdkVersionNode;
                ManifestDetector.checkOverride(context, element, "targetSdkVersion");
                if (context.isEnabled(TARGET_NEWER) && (targetSdkVersionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                    String target = targetSdkVersionNode.getValue();
                    try {
                        int api = Integer.parseInt(target);
                        if (api < context.getClient().getHighestKnownApiLevel()) {
                            context.report(TARGET_NEWER, element, context.getLocation(targetSdkVersionNode), "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the `android.os.Build.VERSION_CODES` javadoc for details.");
                        }
                    }
                    catch (NumberFormatException api) {
                        // empty catch block
                    }
                }
            }
            if ((nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null && nameNode.getValue().startsWith("@") && context.isEnabled(ILLEGAL_REFERENCE)) {
                context.report(ILLEGAL_REFERENCE, element, context.getLocation(nameNode), "The `android:targetSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)");
            }
        }
        if (tag.equals("permission") && (nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null) {
            name2 = nameNode.getValue();
            String base = name2.substring(name2.lastIndexOf(46) + 1);
            if (this.mPermissionNames == null) {
                this.mPermissionNames = Maps.newHashMap();
            } else if (this.mPermissionNames.containsKey(base)) {
                Node node;
                String prevName = this.mPermissionNames.get(base);
                Location location = context.getLocation(nameNode);
                NodeList siblings = element.getParentNode().getChildNodes();
                int n = siblings.getLength();
                for (int i = 0; i < n && (node = siblings.item(i)) != element; ++i) {
                    String b;
                    if (node.getNodeType() != 1) continue;
                    Element sibling = (Element)node;
                    String suffix = '.' + base;
                    if (!sibling.getTagName().equals("permission") || !(b = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).endsWith(suffix)) continue;
                    Location prevLocation = context.getLocation(node);
                    prevLocation.setMessage("Previous permission here");
                    location.setSecondary(prevLocation);
                    break;
                }
                String message = String.format("Permission name `%1$s` is not unique (appears in both `%2$s` and `%3$s`)", base, prevName, name2);
                context.report(UNIQUE_PERMISSION, element, location, message);
            }
            this.mPermissionNames.put(base, name2);
        }
        if (tag.equals("uses-permission") && (name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && name.getValue().equals(MOCK_LOCATION_PERMISSION) && context.getMainProject().isGradleProject() && !ManifestDetector.isDebugOrTestManifest(context, context.file) && context.isEnabled(MOCK_LOCATION)) {
            String message = "Mock locations should only be requested in a test or debug-specific manifest file (typically `src/debug/AndroidManifest.xml`)";
            Location location = context.getLocation(name);
            context.report(MOCK_LOCATION, element, location, message);
        }
        if (tag.equals("application")) {
            this.mSeenApplication = true;
            boolean recordLocation = false;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "allowBackup") || context.getDriver().isSuppressed(context, ALLOW_BACKUP, element)) {
                this.mSeenAllowBackup = true;
            } else {
                recordLocation = true;
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon") || context.getDriver().isSuppressed(context, APPLICATION_ICON, element)) {
                ManifestDetector.checkMipmapIcon(context, element);
                this.mSeenAppIcon = true;
            } else {
                recordLocation = true;
            }
            if (recordLocation && !context.getProject().isLibrary() && (this.mApplicationTagHandle == null || ManifestDetector.isMainManifest(context, context.file))) {
                this.mApplicationTagHandle = context.createLocationHandle(element);
            }
        } else if (this.mSeenApplication) {
            if (context.isEnabled(ORDER)) {
                context.report(ORDER, element, context.getLocation(element), String.format("`<%1$s>` tag appears after `<application>` tag", tag));
            }
            this.mSeenApplication = false;
        }
        if (tag.equals("uses-feature") && (nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && !(name2 = nameNode.getValue()).isEmpty()) {
            if (this.mUsesFeatures.contains(name2)) {
                String message = String.format("Duplicate declaration of uses-feature `%1$s`", name2);
                context.report(DUPLICATE_USES_FEATURE, element, context.getLocation(nameNode), message);
            } else {
                this.mUsesFeatures.add(name2);
            }
        }
    }

    private static void checkMipmapIcon(@NonNull XmlContext context, @NonNull Element element) {
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "icon");
        if (attribute == null) {
            return;
        }
        String icon = attribute.getValue();
        if (icon.startsWith("@drawable/")) {
            if ("activity".equals(element.getTagName()) && !ManifestDetector.isLaunchableActivity(element)) {
                return;
            }
            if (context.isEnabled(MIPMAP) && context.getProject().getApplicableDensities() != null) {
                context.report(MIPMAP, element, context.getLocation(attribute), "Should use `@mipmap` instead of `@drawable` for launcher icons");
            }
        }
    }

    private static boolean isLaunchableActivity(@NonNull Element element) {
        if (!"activity".equals(element.getTagName())) {
            return false;
        }
        for (Element child : LintUtils.getChildren(element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            for (Element innerChild : LintUtils.getChildren(child)) {
                if (!innerChild.getTagName().equals("category")) continue;
                String categoryString = innerChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                return "android.intent.category.LAUNCHER".equals(categoryString);
            }
        }
        return false;
    }

    private static boolean isMainManifest(XmlContext context, File manifestFile) {
        if (!context.getProject().isGradleProject()) {
            return true;
        }
        AndroidProject model = context.getProject().getGradleProjectModel();
        return model == null || manifestFile.equals(model.getDefaultConfig().getSourceProvider().getManifestFile());
    }

    private static boolean isDebugOrTestManifest(@NonNull XmlContext context, @NonNull File manifestFile) {
        AndroidProject model = context.getProject().getGradleProjectModel();
        if (model != null) {
            if (manifestFile.equals(model.getDefaultConfig().getSourceProvider().getManifestFile())) {
                return false;
            }
            for (BuildTypeContainer container : model.getBuildTypes()) {
                if (!container.getBuildType().isDebuggable() || !manifestFile.equals(container.getSourceProvider().getManifestFile())) continue;
                return true;
            }
            for (BuildTypeContainer container : model.getProductFlavors()) {
                for (SourceProviderContainer extra : container.getExtraSourceProviders()) {
                    String artifactName = extra.getArtifactName();
                    if (!"_android_test_".equals(artifactName) || !manifestFile.equals(extra.getSourceProvider().getManifestFile())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void checkDeviceAdmin(XmlContext context, Element element) {
        List<Element> children = LintUtils.getChildren(element);
        boolean requiredIntentFilterFound = false;
        boolean deviceAdmin = false;
        Attr locationNode = null;
        for (Element child : children) {
            String name;
            Attr valueNode;
            String tagName = child.getTagName();
            if (tagName.equals("intent-filter") && !requiredIntentFilterFound) {
                boolean dataFound = false;
                boolean actionFound = false;
                for (Element filterChild : LintUtils.getChildren(child)) {
                    String filterTag = filterChild.getTagName();
                    if (filterTag.equals("action")) {
                        String name2 = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!"android.app.action.DEVICE_ADMIN_ENABLED".equals(name2)) continue;
                        actionFound = true;
                        continue;
                    }
                    if (!filterTag.equals("data")) continue;
                    dataFound = true;
                }
                if (!actionFound || dataFound) continue;
                requiredIntentFilterFound = true;
                continue;
            }
            if (!tagName.equals("meta-data") || (valueNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !"android.app.device_admin".equals(name = valueNode.getValue())) continue;
            deviceAdmin = true;
            locationNode = valueNode;
        }
        if (deviceAdmin && !requiredIntentFilterFound && context.isEnabled(DEVICE_ADMIN)) {
            context.report(DEVICE_ADMIN, locationNode, context.getLocation(locationNode), "You must have an intent filter for action `android.app.action.DEVICE_ADMIN_ENABLED`");
        }
    }
}

