/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.stats.Distribution;
import com.android.tools.idea.stats.DistributionService;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImagePreview {
    private JBLabel myReleaseName;
    private JBLabel myReleaseIcon;
    private JBLabel myApiLevel;
    private JBLabel myAndroidVersion;
    private JBLabel myAbi;
    private JBLabel myWarningMessage;
    private HyperlinkLabel myErrorInstructionsLink;
    private HyperlinkLabel myDocumentationLink;
    private JBLabel myVendor;
    private JPanel myRootPanel;
    private JPanel myMainPanel;
    private JSeparator mySeparator;
    private AvdWizardConstants.SystemImageDescription myImageDescription;
    private static final String NO_SYSTEM_IMAGE_SELECTED = "No System Image Selected";
    private static final String MAIN_CONTENT = "main";
    private static final String NO_IMAGE_CONTENT = "none";
    private static HaxmState ourHaxmState = HaxmState.NOT_INITIALIZED;

    public SystemImagePreview() {
        this.$$$setupUI$$$();
        this.myRootPanel.setLayout(new CardLayout());
        this.myReleaseName.setFont(AvdWizardConstants.TITLE_FONT);
        this.myApiLevel.setFont(AvdWizardConstants.TITLE_FONT);
        this.myAndroidVersion.setFont(AvdWizardConstants.TITLE_FONT);
        this.myVendor.setFont(AvdWizardConstants.TITLE_FONT);
        this.myErrorInstructionsLink.setOpaque(false);
        this.myDocumentationLink.setOpaque(false);
        this.myWarningMessage.setFont(AvdWizardConstants.TITLE_FONT);
        this.myWarningMessage.setForeground((Color)JBColor.RED);
        this.myAbi.setFont(AvdWizardConstants.TITLE_FONT);
        this.myRootPanel.add((Component)this.myMainPanel, MAIN_CONTENT);
        JPanel nonePanel = new JPanel(new BorderLayout());
        JBLabel noneLabel = new JBLabel(NO_SYSTEM_IMAGE_SELECTED);
        noneLabel.setHorizontalAlignment(0);
        nonePanel.add((Component)noneLabel, "Center");
        nonePanel.setBackground((Color)JBColor.WHITE);
        this.myRootPanel.add((Component)nonePanel, NO_IMAGE_CONTENT);
        this.myMainPanel.setBackground((Color)JBColor.WHITE);
        this.mySeparator.setForeground((Color)JBColor.BLACK);
    }

    public void setImage(@Nullable AvdWizardConstants.SystemImageDescription image) {
        if (image == null || !image.isRemote()) {
            this.myImageDescription = image;
            ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, NO_IMAGE_CONTENT);
        }
        if (image != null && !image.isRemote()) {
            HaxmState haxmState;
            Icon icon;
            ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, MAIN_CONTENT);
            Distribution distribution = DistributionService.getInstance().getDistributionForApiLevel(image.getVersion().getApiLevel());
            String codeName = SystemImagePreview.getCodeName(this.myImageDescription);
            if (codeName != null) {
                this.myReleaseName.setText(codeName);
            }
            if ((icon = SystemImagePreview.getIcon(codeName)) != null) {
                this.myReleaseIcon.setIcon(icon);
            }
            if (distribution != null) {
                this.myDocumentationLink.setHtmlText("<a>? - See documentation for Android " + distribution.getVersion().toShortString() + " APIs</a>");
                this.myDocumentationLink.setHyperlinkTarget(distribution.getUrl());
            }
            this.myApiLevel.setText(this.myImageDescription.getVersion().getApiString());
            this.myAndroidVersion.setText(this.myImageDescription.getVersionName());
            String tag = this.myImageDescription.getTag().getId();
            String vendorName = tag.equals("android-wear") || tag.equals("android-tv") ? "Android" : this.myImageDescription.getVendor();
            this.myVendor.setText("<html>" + vendorName + "</html>");
            this.myAbi.setText(this.myImageDescription.getAbiType());
            StringBuilder myWarningText = new StringBuilder("<html>");
            if (this.myImageDescription.getVersion().getApiLevel() < 8) {
                myWarningText.append("This API Level is Deprecated<br>");
            }
            if ((haxmState = SystemImagePreview.getHaxmState(false)) == HaxmState.NOT_INSTALLED) {
                if (!this.myImageDescription.getAbiType().startsWith(Abi.X86.toString())) {
                    myWarningText.append("Consider installing HAXM<br>");
                    myWarningText.append("for better emulation speed");
                } else {
                    myWarningText.append("HAXM is required for running<br>");
                    myWarningText.append("x86 System Images<br>");
                }
                this.myErrorInstructionsLink.setHtmlText("<a>HAXM installation instructions</a>");
                this.myErrorInstructionsLink.setHyperlinkTarget("http://developer.android.com/tools/devices/emulator.html#acceleration");
                this.myErrorInstructionsLink.setVisible(true);
            } else if (haxmState == HaxmState.NOT_LATEST) {
                myWarningText.append("Newer HAXM Version Available");
                this.myErrorInstructionsLink.setVisible(true);
                this.myErrorInstructionsLink.setHtmlText("<a>HAXM installation instructions</a>");
                this.myErrorInstructionsLink.setHyperlinkTarget("http://developer.android.com/tools/devices/emulator.html#acceleration");
            } else {
                this.myErrorInstructionsLink.setVisible(false);
            }
            this.myWarningMessage.setText(myWarningText.toString());
        }
    }

    @Nullable
    public static String getCodeName(@NotNull AvdWizardConstants.SystemImageDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/avdmanager/SystemImagePreview", "getCodeName"));
        }
        return SdkVersionInfo.getCodeName((int)description.getVersion().getApiLevel());
    }

    @Nullable
    public static Icon getIcon(@Nullable String codename) {
        if (codename == null) {
            return null;
        }
        Icon icon = null;
        try {
            icon = IconLoader.findIcon((String)String.format("/icons/versions/%1$s.png", codename), AndroidIcons.class);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (icon != null) {
            return icon;
        }
        int size = 128;
        BufferedImage image = UIUtil.createImage((int)size, (int)size, (int)2);
        Graphics g = ((Image)image).getGraphics();
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        Font f = UIUtil.getLabelFont();
        Font font = new Font(f.getName(), f.getStyle() | 1, 100);
        g.setColor(JBColor.background());
        g.fillRect(0, 0, size, size);
        g.setColor(JBColor.foreground());
        g.setFont(font);
        int height = g.getFontMetrics().getHeight();
        int width = g.getFontMetrics().stringWidth("?");
        g.drawString("?", (size - width) / 2, height + (size - height) / 2);
        return new ImageIcon(image);
    }

    private static HaxmState getHaxmState(boolean forceRefresh) {
        if (ourHaxmState == HaxmState.NOT_INITIALIZED || forceRefresh) {
            ourHaxmState = SystemImagePreview.computeHaxmState();
        }
        return ourHaxmState;
    }

    private static HaxmState computeHaxmState() {
        try {
            if (SystemInfo.isMac) {
                Pattern pattern;
                Matcher matcher;
                String output = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"/usr/sbin/kextstat", "-l", "-b", "com.intel.kext.intelhaxm"}));
                if (output != null && !output.isEmpty() && (matcher = (pattern = Pattern.compile("com\\.intel\\.kext\\.intelhaxm( \\((.+)\\))?")).matcher(output)).find()) {
                    if (matcher.groupCount() >= 2) {
                        String version = matcher.group(2);
                        try {
                            FullRevision revision = FullRevision.parseRevision((String)version);
                            FullRevision current = new FullRevision(1, 1, 1);
                            if (revision.compareTo(current) < 0) {
                                return HaxmState.NOT_LATEST;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return HaxmState.INSTALLED;
                }
                return HaxmState.NOT_INSTALLED;
            }
            if (SystemInfo.isWindows) {
                ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"sc", "query", "intelhaxm"}));
                return Iterables.all((Iterable)processOutput.getStdoutLines(), (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return input == null || !input.contains("does not exist");
                    }
                }) ? HaxmState.INSTALLED : HaxmState.NOT_INSTALLED;
            }
            if (SystemInfo.isUnix) {
                ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"kvm-ok"}));
                return Iterables.any((Iterable)processOutput.getStdoutLines(), (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return input != null && input.contains("KVM acceleration can be used");
                    }
                }) ? HaxmState.INSTALLED : HaxmState.NOT_INSTALLED;
            }
            assert (!SystemInfo.isLinux);
            return HaxmState.NOT_INSTALLED;
        }
        catch (ExecutionException e) {
            return HaxmState.NOT_INSTALLED;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel hyperlinkLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JBLabel jBLabel7;
        JSeparator jSeparator;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(16, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 16, 3, 0, 3, 3, 3, null, null, null));
        this.mySeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15), null, 0, 0, null, null));
        this.myReleaseName = jBLabel7 = new JBLabel();
        jPanel3.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(14, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setEnabled(true);
        jPanel4.setOpaque(false);
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 14, 1, 0, 3, 3, 7, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), null, 0, 0, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("API Level");
        Font font = jBLabel8.getFont();
        jBLabel8.setFont(new Font(font.getName(), font.getStyle(), 10));
        jPanel4.add((Component)jBLabel8, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myApiLevel = jBLabel6 = new JBLabel();
        jPanel4.add((Component)jBLabel6, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("Android");
        Font font2 = jBLabel9.getFont();
        jBLabel9.setFont(new Font(font2.getName(), font2.getStyle(), 10));
        jPanel4.add((Component)jBLabel9, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAndroidVersion = jBLabel5 = new JBLabel();
        jPanel4.add((Component)jBLabel5, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("System Image");
        Font font3 = jBLabel10.getFont();
        jBLabel10.setFont(new Font(font3.getName(), font3.getStyle(), 10));
        jPanel4.add((Component)jBLabel10, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAbi = jBLabel4 = new JBLabel();
        jPanel4.add((Component)jBLabel4, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWarningMessage = jBLabel3 = new JBLabel();
        jPanel4.add((Component)jBLabel3, new GridConstraints(10, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(9, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myErrorInstructionsLink = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel2, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(12, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myDocumentationLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel, new GridConstraints(13, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myVendor = jBLabel2 = new JBLabel();
        jPanel4.add((Component)jBLabel2, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 2, null, new Dimension(150, -1), new Dimension(150, -1)));
        this.myReleaseIcon = jBLabel = new JBLabel();
        jBLabel.setVerticalAlignment(1);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 9, 1, 9, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    static enum HaxmState {
        NOT_INITIALIZED,
        INSTALLED,
        NOT_INSTALLED,
        NOT_LATEST;

    }
}

