/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.PsiResourceItem;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class StringResourceParser {
    public static StringResourceData parse(final @NotNull AndroidFacet facet, final @NotNull LocalResourceRepository repository) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringResourceParser", "parse"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/editors/strings/StringResourceParser", "parse"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringResourceParser.parseUnderReadLock(facet, repository);
        }
        return (StringResourceData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<StringResourceData>(){

            public StringResourceData compute() {
                return StringResourceParser.parseUnderReadLock(facet, repository);
            }
        });
    }

    private static StringResourceData parseUnderReadLock(AndroidFacet facet, LocalResourceRepository repository) {
        ArrayList keys = Lists.newArrayList((Iterable)repository.getItemsOfType(ResourceType.STRING));
        Collections.sort(keys);
        HashSet untranslatableKeys = Sets.newHashSet();
        TreeSet locales = Sets.newTreeSet(Locale.LANGUAGE_CODE_COMPARATOR);
        HashMap defaultValues = Maps.newHashMapWithExpectedSize((int)keys.size());
        HashBasedTable translations = HashBasedTable.create();
        for (String key : keys) {
            List items = repository.getResourceItem(ResourceType.STRING, key);
            if (items == null) continue;
            for (ResourceItem item : items) {
                FolderConfiguration config;
                LanguageQualifier languageQualifier;
                XmlTag tag;
                if (item instanceof PsiResourceItem && (tag = ((PsiResourceItem)item).getTag()) != null && "false".equals(tag.getAttributeValue("translatable"))) {
                    untranslatableKeys.add(key);
                }
                LanguageQualifier languageQualifier2 = languageQualifier = (config = item.getConfiguration()) == null ? null : config.getEffectiveLanguage();
                if (languageQualifier == null) {
                    defaultValues.put(key, item);
                    continue;
                }
                Locale locale = Locale.create(languageQualifier, config.getEffectiveRegion());
                locales.add(locale);
                translations.put((Object)key, (Object)locale, (Object)item);
            }
        }
        return new StringResourceData(facet, keys, untranslatableKeys, locales, defaultValues, (Table<String, Locale, ResourceItem>)translations);
    }
}

