/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.messages.AbstractNavigatable;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.structure.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ProjectSyncMessages {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    @NotNull
    public static ProjectSyncMessages getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getInstance"));
        }
        ProjectSyncMessages projectSyncMessages = (ProjectSyncMessages)ServiceManager.getService((Project)project, ProjectSyncMessages.class);
        if (projectSyncMessages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getInstance"));
        }
        return projectSyncMessages;
    }

    public int getErrorCount() {
        return this.myNotificationManager.getMessageCount(null, NotificationSource.PROJECT_SYNC, NotificationCategory.ERROR, GradleConstants.SYSTEM_ID);
    }

    public ProjectSyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "<init>"));
        }
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public void removeMessages(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "removeMessages"));
        }
        this.myNotificationManager.clearNotifications(groupName, NotificationSource.PROJECT_SYNC, GradleConstants.SYSTEM_ID);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getMessageCount"));
        }
        return this.myNotificationManager.getMessageCount(groupName, NotificationSource.PROJECT_SYNC, null, GradleConstants.SYSTEM_ID);
    }

    public void add(@NotNull Message message, NotificationHyperlink ... hyperlinks) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        Navigatable navigatable = message.getNavigatable();
        String title = message.getGroupName();
        String errorMsg = StringUtil.join((String[])message.getText(), (String)"\n");
        VirtualFile file = message.getFile();
        String filePath = file != null ? FileUtil.toSystemDependentName((String)file.getPath()) : null;
        NotificationData notification = new NotificationData(title, errorMsg, NotificationCategory.convert((int)message.getType().getValue()), NotificationSource.PROJECT_SYNC, filePath, message.getLine(), message.getColumn(), false);
        notification.setNavigatable(navigatable);
        if (hyperlinks.length > 0) {
            AbstractSyncErrorHandler.updateNotification(notification, this.myProject, title, errorMsg, hyperlinks);
        }
        this.myNotificationManager.showNotification(GradleConstants.SYSTEM_ID, notification);
    }

    public boolean isEmpty() {
        return this.myNotificationManager.getMessageCount(NotificationSource.PROJECT_SYNC, null, GradleConstants.SYSTEM_ID) == 0;
    }

    public void reportSyncIssues(@NotNull Collection<SyncIssue> syncIssues, @NotNull Module module) {
        if (syncIssues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssues", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportSyncIssues"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportSyncIssues"));
        }
        if (syncIssues.isEmpty()) {
            return;
        }
        boolean hasSyncErrors = false;
        VirtualFile buildFile = ProjectSyncMessages.getBuildFile(module);
        block3: for (SyncIssue syncIssue : syncIssues) {
            if (syncIssue.getSeverity() == 2) {
                hasSyncErrors = true;
            }
            switch (syncIssue.getType()) {
                case 2: {
                    this.reportUnresolvedDependency(syncIssue.getData(), module, buildFile);
                    continue block3;
                }
            }
            String group = "Gradle Sync Issue";
            String text = syncIssue.getMessage();
            Message.Type severity = syncIssue.getType() == 2 ? Message.Type.ERROR : Message.Type.WARNING;
            Message msg = buildFile != null ? new Message(module.getProject(), group, severity, buildFile, -1, -1, text) : new Message(group, severity, AbstractNavigatable.NOT_NAVIGATABLE, text);
            this.add(msg, new NotificationHyperlink[0]);
        }
        if (hasSyncErrors) {
            this.myProject.putUserData(Projects.HAS_SYNC_ERRORS, (Object)true);
        }
    }

    public void reportUnresolvedDependencies(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolvedDependencies", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependencies"));
        }
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = ProjectSyncMessages.getBuildFile(module);
        for (String dep : unresolvedDependencies) {
            this.reportUnresolvedDependency(dep, module, buildFile);
        }
        this.myProject.putUserData(Projects.HAS_SYNC_ERRORS, (Object)true);
    }

    @Nullable
    private static VirtualFile getBuildFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getBuildFile"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleProject() != null) {
            IdeaGradleProject gradleProject = gradleFacet.getGradleProject();
            return gradleProject.getBuildFile();
        }
        return null;
    }

    private void reportUnresolvedDependency(@NotNull String dependency, @NotNull Module module, @Nullable VirtualFile buildFile) {
        GradleCoordinate coordinate;
        Message msg;
        String group;
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependency"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependency"));
        }
        ArrayList hyperlinks = Lists.newArrayList();
        if (dependency.startsWith("com.android.support")) {
            group = "Unresolved Android dependencies";
            hyperlinks.add(new InstallRepositoryHyperlink(SdkMavenRepository.ANDROID));
        } else if (dependency.startsWith("com.google.android.gms")) {
            group = "Unresolved Android dependencies";
            hyperlinks.add(new InstallRepositoryHyperlink(SdkMavenRepository.GOOGLE));
        } else {
            group = "Unresolved dependencies";
        }
        String text = "Failed to resolve: " + dependency;
        if (buildFile != null) {
            TextRange textRange;
            int lineNumber = -1;
            int column = -1;
            Document document = FileDocumentManager.getInstance().getDocument(buildFile);
            if (document != null && (textRange = GradleUtil.findDependency(dependency, document.getText())) != null && (lineNumber = document.getLineNumber(textRange.getStartOffset())) > -1) {
                int lineStartOffset = document.getLineStartOffset(lineNumber);
                column = textRange.getStartOffset() - lineStartOffset;
            }
            msg = new Message(module.getProject(), group, Message.Type.ERROR, buildFile, lineNumber, column, text);
            String hyperlinkText = lineNumber > -1 ? "Show in File" : "Open File";
            hyperlinks.add(new OpenFileHyperlink(buildFile.getPath(), hyperlinkText, lineNumber, column));
        } else {
            msg = new Message(group, Message.Type.ERROR, AbstractNavigatable.NOT_NAVIGATABLE, text);
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio() && (coordinate = GradleCoordinate.parseCoordinateString((String)dependency)) != null) {
            hyperlinks.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        this.add(msg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    private static class InstallRepositoryHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final SdkMavenRepository myRepository;

        InstallRepositoryHyperlink(@NotNull SdkMavenRepository repository) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "<init>"));
            }
            super("install.m2.repo", "Install Repository and sync project");
            this.myRepository = repository;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            requested.add(this.myRepository.getPackageDescription());
            SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
            wizard.init();
            wizard.setTitle("Install Missing Components");
            if (wizard.showAndGet()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }

    private static class ShowDependencyInProjectStructureHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Module myModule;
        @NotNull
        private final GradleCoordinate myDependency;

        ShowDependencyInProjectStructureHyperlink(@NotNull Module module, @NotNull GradleCoordinate dependency) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$ShowDependencyInProjectStructureHyperlink", "<init>"));
            }
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$ShowDependencyInProjectStructureHyperlink", "<init>"));
            }
            super("open.dependency.in.project.structure", "Show in Project Structure dialog");
            this.myModule = module;
            this.myDependency = dependency;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$ShowDependencyInProjectStructureHyperlink", "execute"));
            }
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openAndSelectDependency(this.myModule, this.myDependency);
            }
        }
    }
}

