/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.FirstRunWizardStep;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkLocationStep
extends FirstRunWizardStep {
    private static final String MAC_JDKS_DIR = "/Library/Java/JavaVirtualMachines/";
    private static final String WINDOWS_JDKS_DIR = "C:\\Program Files\\Java";
    private static final String LINUX_SDK_DIR = "/usr/lib/jvm";
    private final AtomicBoolean myJdkDetectionInProgress;
    private final ScopedStateStore.Key<String> myPathKey;
    @NotNull
    private final FirstRunWizardMode myMode;
    private JPanel myContents;
    private TextFieldWithBrowseButton myJdkPath;
    private JButton myDownloadPageLink;
    private JLabel myError;
    private JButton myDetectButton;
    private JLabel myDetectLabel;
    private boolean myUserInput;

    public JdkLocationStep(@NotNull ScopedStateStore.Key<String> pathKey, @NotNull FirstRunWizardMode mode) {
        if (pathKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathKey", "com/android/tools/idea/welcome/JdkLocationStep", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/JdkLocationStep", "<init>"));
        }
        super("Java Settings");
        this.$$$setupUI$$$();
        this.myJdkDetectionInProgress = new AtomicBoolean();
        this.myUserInput = false;
        this.myPathKey = pathKey;
        this.myMode = mode;
        this.myDownloadPageLink.setText(JdkLocationStep.getLinkText());
        WelcomeUIUtils.makeButtonAHyperlink(this.myDownloadPageLink, "http://www.oracle.com/technetwork/java/javase/downloads/jdk7-downloads-1880260.html");
        this.myDownloadPageLink.getParent().invalidate();
        this.setComponent(this.myContents);
        this.myError.setForeground((Color)JBColor.red);
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myJdkPath.addBrowseFolderListener("Select JDK Location", "Select compatible JDK location", null, folderDescriptor);
        this.myError.setText(null);
        this.myDetectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkLocationStep.this.myDetectButton.setEnabled(false);
                ProgressManager.getInstance().run((Task)new DetectJdkTask());
            }
        });
    }

    private static String getLinkText() {
        if (SystemInfo.isMac) {
            return "Mac OS X x64";
        }
        if (SystemInfo.isLinux) {
            return SystemInfo.is32Bit ? "Linux x86" : "Linux x64";
        }
        if (SystemInfo.isWindows) {
            return SystemInfo.is32Bit ? "Windows x86" : "Windows x64";
        }
        return SystemInfo.OS_NAME;
    }

    private static boolean isJdk7(@NotNull File path) {
        JavaSdkVersion version;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/welcome/JdkLocationStep", "isJdk7"));
        }
        String jdkVersion = JavaSdk.getJdkVersion((String)path.getAbsolutePath());
        return jdkVersion == null || (version = JavaSdk.getInstance().getVersion(jdkVersion)) == null || version.isAtLeast(JavaSdkVersion.JDK_1_7);
    }

    @Nullable
    public static String validateJdkLocation(@Nullable File location) {
        if (location == null) {
            return "Path is empty";
        }
        if (!JdkUtil.checkForJdk((File)location)) {
            return "Path specified is not a valid JDK location";
        }
        if (!JdkLocationStep.isJdk7(location)) {
            return "JDK 7.0 or newer is required";
        }
        return null;
    }

    @NotNull
    private static Iterable<String> getCandidatePaths() {
        Iterable iterable = Iterables.concat(JdkLocationStep.deduceFromJavaHome(), JdkLocationStep.deduceFromPath(), JdkLocationStep.deduceFromCurrentJvm(), JdkLocationStep.getOsSpecificCandidatePaths());
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getCandidatePaths"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<String> deduceFromJavaHome() {
        String javaHome = System.getenv("JAVA_HOME");
        Set<Object> set = Strings.isNullOrEmpty((String)javaHome) ? Collections.emptySet() : Collections.singleton(javaHome);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "deduceFromJavaHome"));
        }
        return set;
    }

    @NotNull
    private static Iterable<String> deduceFromPath() {
        String[] pathEntries;
        String path = System.getenv("PATH");
        if (Strings.isNullOrEmpty((String)path)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "deduceFromPath"));
            }
            return list;
        }
        for (String entry : pathEntries = path.split(File.pathSeparator)) {
            Iterable<String> iterable;
            if (Strings.isNullOrEmpty((String)entry)) continue;
            File javaParentDir = new File(entry);
            File javaFile = new File(javaParentDir, "java");
            if (!javaParentDir.isDirectory() || !javaFile.isFile()) continue;
            try {
                File canonicalJavaFile = javaFile.getCanonicalFile();
                iterable = JdkLocationStep.forJavaBinParent(canonicalJavaFile.getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "deduceFromPath"));
            }
            return iterable;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "deduceFromPath"));
        }
        return list;
    }

    @NotNull
    private static Iterable<String> deduceFromCurrentJvm() {
        String javaHome = System.getProperty("java.home");
        Iterable<String> iterable = Strings.isNullOrEmpty((String)javaHome) ? Collections.emptySet() : JdkLocationStep.forJavaBinParent(new File(javaHome));
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "deduceFromCurrentJvm"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<String> forJavaBinParent(@NotNull File javaBinParent) {
        if (javaBinParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaBinParent", "com/android/tools/idea/welcome/JdkLocationStep", "forJavaBinParent"));
        }
        if (!javaBinParent.isDirectory()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "forJavaBinParent"));
            }
            return set;
        }
        if (!"jre".equals(javaBinParent.getName())) {
            Set<String> set = Collections.singleton(javaBinParent.getAbsolutePath());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "forJavaBinParent"));
            }
            return set;
        }
        File parentFile = javaBinParent.getParentFile();
        if (parentFile.isDirectory()) {
            Set<String> set = Collections.singleton(parentFile.getAbsolutePath());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "forJavaBinParent"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "forJavaBinParent"));
        }
        return set;
    }

    @NotNull
    private static Iterable<String> getOsSpecificCandidatePaths() {
        if (SystemInfo.isMac) {
            Iterable<String> iterable = JdkLocationStep.getMacCandidateJdks();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getOsSpecificCandidatePaths"));
            }
            return iterable;
        }
        if (SystemInfo.isWindows) {
            Iterable<String> iterable = JdkLocationStep.getWindowsCandidateJdks();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getOsSpecificCandidatePaths"));
            }
            return iterable;
        }
        if (SystemInfo.isLinux) {
            Iterable<String> iterable = JdkLocationStep.getLinuxCandidateJdks();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getOsSpecificCandidatePaths"));
            }
            return iterable;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getOsSpecificCandidatePaths"));
        }
        return list;
    }

    @NotNull
    private static Iterable<String> getMacCandidateJdks() {
        Iterable<String> iterable = JdkLocationStep.getCandidatePaths(MAC_JDKS_DIR, "/Contents/Home");
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getMacCandidateJdks"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<String> getWindowsCandidateJdks() {
        Iterable<String> iterable = JdkLocationStep.getCandidatePaths(WINDOWS_JDKS_DIR, "");
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getWindowsCandidateJdks"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<String> getLinuxCandidateJdks() {
        Iterable<String> iterable = JdkLocationStep.getCandidatePaths(LINUX_SDK_DIR, "");
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getLinuxCandidateJdks"));
        }
        return iterable;
    }

    private static Iterable<String> getCandidatePaths(String basedir, final String suffix) {
        final File location = new File(basedir);
        if (location.isDirectory()) {
            return Iterables.transform(Arrays.asList(location.list()), (Function)new Function<String, String>(){

                public String apply(@Nullable String dir) {
                    return new File(location, dir + suffix).getAbsolutePath();
                }
            });
        }
        return Collections.emptyList();
    }

    @Override
    public boolean validate() {
        String path = this.myState.get(this.myPathKey);
        if (!StringUtil.isEmpty((String)path)) {
            this.myUserInput = true;
        }
        File userInput = StringUtil.isEmptyOrSpaces((String)path) ? null : new File(path);
        String message = JdkLocationStep.validateJdkLocation(userInput);
        if (this.myUserInput) {
            this.setErrorHtml(message);
        }
        return StringUtil.isEmpty((String)message);
    }

    @Override
    public void init() {
        this.register(this.myPathKey, this.myJdkPath);
        this.autoDetectJdkPath();
    }

    private void autoDetectJdkPath() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!JdkLocationStep.this.myJdkDetectionInProgress.compareAndSet(false, true)) {
                    return;
                }
                try {
                    final String path = JdkLocationStep.detectJdkPath(null);
                    if (path != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String jdkPath = (String)JdkLocationStep.this.myState.get(JdkLocationStep.this.myPathKey);
                                if (!Strings.isNullOrEmpty((String)jdkPath)) {
                                    JdkLocationStep.this.myState.put(JdkLocationStep.this.myPathKey, path);
                                }
                            }
                        });
                    }
                }
                finally {
                    JdkLocationStep.this.myJdkDetectionInProgress.set(false);
                }
            }
        });
    }

    @Override
    public boolean isStepVisible() {
        return !this.myMode.hasValidJdkLocation();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkPath;
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getMessageLabel"));
        }
        return jLabel;
    }

    @Nullable
    private static String detectJdkPath(@Nullable AtomicBoolean cancellationFlag) {
        String topVersion = null;
        String chosenPath = null;
        for (String path : JdkLocationStep.getCandidatePaths()) {
            if (cancellationFlag != null && cancellationFlag.get()) {
                return null;
            }
            if (!StringUtil.isEmpty((String)JdkLocationStep.validateJdkLocation(new File(path)))) continue;
            String version = JavaSdk.getInstance().getVersionString(path);
            if (topVersion != null && version != null && topVersion.compareTo(version) >= 0) continue;
            topVersion = version;
            chosenPath = path;
        }
        return chosenPath;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JLabel jLabel2;
        JButton jButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html>Android Studio requires Java Development Kit (JDK) 7.0 or newer.</html>");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 2, null, new Dimension(800, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Java Development Kit (JDK) version 7.0.");
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("or download and install JDK for your operating system and architecture: ");
        Component component = jPanel2.add(jLabel5);
        this.myDownloadPageLink = jButton2 = new JButton();
        jButton2.setHorizontalAlignment(2);
        jButton2.setText("Button");
        Component component2 = jPanel2.add(jButton2);
        this.myDetectLabel = jLabel2 = new JLabel();
        jLabel2.setText(" and press ");
        Component component3 = jPanel2.add(jLabel2);
        this.myDetectButton = jButton = new JButton();
        jButton.setText("Detect");
        Component component4 = jPanel2.add(jButton);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myError = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Up to date JDK was not detected. Please select JDK location:");
        jPanel.add((Component)jLabel6, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }

    private class DetectJdkTask
    extends Task.Modal {
        private final AtomicBoolean myCancelled;
        private String myPath;

        public DetectJdkTask() {
            super(null, "Detect JDK", true);
            this.myCancelled = new AtomicBoolean(false);
            this.myPath = null;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/JdkLocationStep$DetectJdkTask", "run"));
            }
            indicator.setIndeterminate(true);
            if (JdkLocationStep.this.myJdkDetectionInProgress.compareAndSet(false, true)) {
                try {
                    this.myPath = JdkLocationStep.detectJdkPath(this.myCancelled);
                }
                finally {
                    JdkLocationStep.this.myJdkDetectionInProgress.set(false);
                }
            }
            while (JdkLocationStep.this.myJdkDetectionInProgress.get()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void onSuccess() {
            if (this.myPath == null) {
                String message = AndroidBundle.message("android.wizard.jdk.autodetect.result.not.found", new Object[0]);
                ExternalSystemUiUtil.showBalloon((JComponent)JdkLocationStep.this.myJdkPath, (MessageType)MessageType.INFO, (String)message);
            } else {
                JdkLocationStep.this.myState.put(JdkLocationStep.this.myPathKey, this.myPath);
            }
            JdkLocationStep.this.myDetectButton.setEnabled(true);
            super.onSuccess();
        }

        public void onCancel() {
            JdkLocationStep.this.myDetectButton.setEnabled(true);
            this.myCancelled.set(true);
        }
    }
}

