/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.assetstudiolib.ActionBarIconGenerator;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.builder.model.SourceProvider;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.ImageComponent;
import com.android.tools.idea.wizard.StringEvaluator;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.collect.Iterators;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetSetStep
extends TemplateWizardStep
implements Disposable {
    private static final Logger LOG = Logger.getInstance(AssetSetStep.class);
    private static final int CLIPART_ICON_SIZE = 32;
    private static final int CLIPART_DIALOG_BORDER = 10;
    private static final int DIALOG_HEADER = 20;
    public static final String ATTR_ICON_RESOURCE = "icon_resource";
    private static final String V11 = "V11";
    private static final String V9 = "V9";
    private SourceProvider mySourceProvider = null;
    private AssetStudioAssetGenerator myAssetGenerator;
    private JPanel myPanel;
    private JRadioButton myImageRadioButton;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myTextRadioButton;
    private JRadioButton myCropRadioButton;
    private JRadioButton myCenterRadioButton;
    private JRadioButton myCircleRadioButton;
    private JRadioButton mySquareRadioButton;
    private JRadioButton myNoneRadioButton;
    private JButton myChooseClipart;
    private JLabel myError;
    private JLabel myDescription;
    private JCheckBox myTrimBlankSpace;
    private JTextField myText;
    private JComboBox myFontFamily;
    private TextFieldWithBrowseButton myImageFile;
    private ColorPanel myBackgroundColor;
    private ColorPanel myForegroundColor;
    private ImageComponent myMdpiPreview;
    private ImageComponent myHdpiPreview;
    private ImageComponent myXHdpiPreview;
    private JSlider myPaddingSlider;
    private ImageComponent myXXHdpiPreview;
    private JLabel myImageFileLabel;
    private JLabel myTextLabel;
    private JLabel myFontFamilyLabel;
    private JLabel myChooseClipartLabel;
    private JLabel myBackgroundColorLabel;
    private JLabel myForegroundColorLabel;
    private JComboBox myAssetTypeComboBox;
    private JLabel myAssetTypeLabel;
    private JComboBox myChooseThemeComboBox;
    private JLabel myChooseThemeLabel;
    private JLabel myForegroundScalingLabel;
    private JLabel myShapeLabel;
    private JPanel myShapePanel;
    private JPanel myScalingPanel;
    private JTextField myResourceNameField;
    private JLabel myResourceNameLabel;
    private JPanel myDpiPanel;
    private JPanel myVersionPanel;
    private ImageComponent myV9XHdpiPreview;
    private ImageComponent myV9XXHdpiPreview;
    private ImageComponent myV9MdpiPreview;
    private ImageComponent myV9HdpiPreview;
    private ImageComponent myV11MdpiPreview;
    private ImageComponent myV11HdpiPreview;
    private ImageComponent myV11XHdpiPreview;
    private ImageComponent myV11XXHdpiPreview;
    protected AssetStudioAssetGenerator.AssetType mySelectedAssetType;
    private boolean myInitialized;
    private final StringEvaluator myStringEvaluator;
    private final MergingUpdateQueue myUpdateQueue;
    private final Map<String, Map<String, BufferedImage>> myImageMap;

    public AssetSetStep(TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable VirtualFile invocationTarget) {
        super(state, project, module, sidePanelIcon, updateListener);
        AndroidFacet facet;
        this.$$$setupUI$$$();
        this.myStringEvaluator = new StringEvaluator();
        this.myImageMap = new ConcurrentHashMap<String, Map<String, BufferedImage>>();
        this.myAssetGenerator = new AssetStudioAssetGenerator(state);
        if (invocationTarget != null && module != null && (facet = AndroidFacet.getInstance(this.myModule)) != null) {
            this.mySourceProvider = (SourceProvider)Iterators.getNext(IdeaSourceProvider.getSourceProvidersForFile(facet, invocationTarget, null).iterator(), null);
        }
        this.myUpdateQueue = new MergingUpdateQueue("asset.studio", 200, true, null, (Disposable)this, null, false);
        this.register("text", this.myText);
        this.register("scaling", this.myCropRadioButton, (Object)AssetStudioAssetGenerator.Scaling.CROP);
        this.register("scaling", this.myCenterRadioButton, (Object)AssetStudioAssetGenerator.Scaling.CENTER);
        this.register("shape", this.myCircleRadioButton, GraphicGenerator.Shape.CIRCLE);
        this.register("shape", this.mySquareRadioButton, GraphicGenerator.Shape.SQUARE);
        this.register("shape", this.myNoneRadioButton, GraphicGenerator.Shape.NONE);
        this.register("padding", this.myPaddingSlider);
        this.register("trim", this.myTrimBlankSpace);
        this.register("font", this.myFontFamily);
        this.register("sourceType", this.myImageRadioButton, (Object)AssetStudioAssetGenerator.SourceType.IMAGE);
        this.register("sourceType", this.myClipartRadioButton, (Object)AssetStudioAssetGenerator.SourceType.CLIPART);
        this.register("sourceType", this.myTextRadioButton, (Object)AssetStudioAssetGenerator.SourceType.TEXT);
        this.register("foregroundColor", this.myForegroundColor);
        this.register("backgroundColor", this.myBackgroundColor);
        this.register("assetType", this.myAssetTypeComboBox);
        this.register("assetTheme", this.myChooseThemeComboBox);
        this.register("assetName", this.myResourceNameField);
        this.myImageFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myForegroundColor.setSelectedColor(Color.BLUE);
        this.myBackgroundColor.setSelectedColor(Color.WHITE);
        for (String font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.myFontFamily.addItem(new ComboBoxItem(font, font, 1, 1));
            if (!font.equals(this.myTemplateState.get("font"))) continue;
            this.myFontFamily.setSelectedIndex(this.myFontFamily.getItemCount() - 1);
        }
        this.myChooseClipart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssetSetStep.this.displayClipartDialog();
            }
        });
        AssetSetStep.populateComboBox(this.myAssetTypeComboBox, AssetStudioAssetGenerator.AssetType.class);
        AssetSetStep.populateComboBox(this.myChooseThemeComboBox, ActionBarIconGenerator.Theme.class);
    }

    @Override
    public void deriveValues() {
        super.deriveValues();
        this.myTemplateState.put(ATTR_ICON_RESOURCE, this.myTemplateState.getString("assetName"));
        if (this.myImageRadioButton.isSelected()) {
            this.hide(new JComponent[]{this.myChooseClipart, this.myChooseClipartLabel, this.myText, this.myTextLabel, this.myFontFamily, this.myFontFamilyLabel, this.myForegroundColor, this.myForegroundColorLabel});
            this.show(new JComponent[]{this.myImageFile, this.myImageFileLabel, this.myBackgroundColor, this.myBackgroundColorLabel});
        } else if (this.myClipartRadioButton.isSelected()) {
            this.hide(new JComponent[]{this.myText, this.myTextLabel, this.myFontFamily, this.myFontFamilyLabel, this.myImageFile, this.myImageFileLabel});
            this.show(new JComponent[]{this.myChooseClipart, this.myChooseClipartLabel, this.myBackgroundColor, this.myBackgroundColorLabel, this.myForegroundColor, this.myForegroundColorLabel});
        } else if (this.myTextRadioButton.isSelected()) {
            this.hide(new JComponent[]{this.myChooseClipart, this.myChooseClipartLabel, this.myImageFile, this.myImageFileLabel});
            this.show(new JComponent[]{this.myText, this.myTextLabel, this.myFontFamily, this.myFontFamilyLabel, this.myBackgroundColor, this.myBackgroundColorLabel, this.myForegroundColor, this.myForegroundColorLabel});
            this.myFontFamily.setSelectedItem(this.myTemplateState.getString("font"));
        }
        if (this.myTemplateState.get("assetType") != null) {
            AssetStudioAssetGenerator.AssetType selectedAssetType;
            this.mySelectedAssetType = selectedAssetType = AssetStudioAssetGenerator.AssetType.valueOf(this.myTemplateState.getString("assetType"));
            if (selectedAssetType != null) {
                switch (selectedAssetType) {
                    case LAUNCHER: {
                        this.hide(this.myChooseThemeComboBox, this.myChooseThemeLabel, this.myVersionPanel);
                        this.show(this.myForegroundScalingLabel, this.myScalingPanel, this.myShapeLabel, this.myShapePanel, this.myDpiPanel, this.myResourceNameLabel, this.myResourceNameField);
                        if (this.myTemplateState.myModified.contains("assetName")) break;
                        this.myTemplateState.put("assetName", "icon");
                        break;
                    }
                    case ACTIONBAR: {
                        this.show(this.myResourceNameField, this.myResourceNameLabel);
                        this.show(this.myChooseThemeComboBox, this.myChooseThemeLabel, this.myDpiPanel);
                        this.hide(new JComponent[]{this.myForegroundScalingLabel, this.myScalingPanel, this.myShapeLabel, this.myShapePanel, this.myBackgroundColorLabel, this.myBackgroundColor, this.myVersionPanel});
                        break;
                    }
                    case NOTIFICATION: {
                        this.show(this.myResourceNameField, this.myResourceNameLabel, this.myVersionPanel);
                        this.hide(new JComponent[]{this.myChooseThemeComboBox, this.myChooseThemeLabel, this.myForegroundColor, this.myForegroundColorLabel});
                        this.hide(new JComponent[]{this.myForegroundScalingLabel, this.myScalingPanel, this.myShapeLabel, this.myShapePanel, this.myBackgroundColorLabel, this.myBackgroundColor, this.myDpiPanel});
                    }
                }
                if (!this.myTemplateState.myModified.contains("assetName")) {
                    this.updateDerivedValue("assetName", this.myResourceNameField, new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return AssetSetStep.this.computeResourceName();
                        }
                    });
                }
            }
        }
        if (this.myChooseThemeComboBox.isVisible() && this.myTemplateState.hasAttr("assetTheme")) {
            if (ActionBarIconGenerator.Theme.valueOf((String)this.myTemplateState.getString("assetTheme")).equals((Object)ActionBarIconGenerator.Theme.CUSTOM)) {
                this.show(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
            } else {
                this.hide(new JComponent[]{this.myForegroundColor, this.myForegroundColorLabel});
            }
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        String assetName = this.myTemplateState.getString("assetName");
        if (this.drawableExists(assetName)) {
            this.setErrorHtml(String.format("A drawable resource named %s already exists and will be overwritten.", assetName));
        }
        this.requestPreviewUpdate();
        return true;
    }

    private void requestPreviewUpdate() {
        this.myUpdateQueue.cancelAllUpdates();
        this.myUpdateQueue.queue(new Update("update"){

            public void run() {
                try {
                    AssetSetStep.this.myAssetGenerator.generateImages(AssetSetStep.this.myImageMap, true, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AssetSetStep.this.updatePreviewImages();
                        }
                    });
                }
                catch (AssetStudioAssetGenerator.ImageGeneratorException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AssetSetStep.this.setErrorHtml(e.getMessage());
                        }
                    });
                }
            }
        });
    }

    private void updatePreviewImages() {
        if (this.mySelectedAssetType == null || this.myImageMap == null) {
            return;
        }
        if (this.mySelectedAssetType.equals((Object)AssetStudioAssetGenerator.AssetType.NOTIFICATION)) {
            BufferedImage v9_mdpi = AssetSetStep.getImage(this.myImageMap, V9, Density.MEDIUM);
            BufferedImage v9_hdpi = AssetSetStep.getImage(this.myImageMap, V9, Density.HIGH);
            BufferedImage v9_xhdpi = AssetSetStep.getImage(this.myImageMap, V9, Density.XHIGH);
            BufferedImage v9_xxhdpi = AssetSetStep.getImage(this.myImageMap, V9, Density.XXHIGH);
            AssetSetStep.setIconOrClear(this.myV9MdpiPreview, v9_mdpi);
            AssetSetStep.setIconOrClear(this.myV9HdpiPreview, v9_hdpi);
            AssetSetStep.setIconOrClear(this.myV9XHdpiPreview, v9_xhdpi);
            AssetSetStep.setIconOrClear(this.myV9XXHdpiPreview, v9_xxhdpi);
            BufferedImage v11_mdpi = AssetSetStep.getImage(this.myImageMap, V11, Density.MEDIUM);
            BufferedImage v11_hdpi = AssetSetStep.getImage(this.myImageMap, V11, Density.HIGH);
            BufferedImage v11_xhdpi = AssetSetStep.getImage(this.myImageMap, V11, Density.XHIGH);
            BufferedImage v11_xxhdpi = AssetSetStep.getImage(this.myImageMap, V11, Density.XXHIGH);
            AssetSetStep.setIconOrClear(this.myV11MdpiPreview, v11_mdpi);
            AssetSetStep.setIconOrClear(this.myV11HdpiPreview, v11_hdpi);
            AssetSetStep.setIconOrClear(this.myV11XHdpiPreview, v11_xhdpi);
            AssetSetStep.setIconOrClear(this.myV11XXHdpiPreview, v11_xxhdpi);
        } else {
            BufferedImage mdpi = AssetSetStep.getImage(this.myImageMap, Density.MEDIUM.getResourceValue());
            BufferedImage hdpi = AssetSetStep.getImage(this.myImageMap, Density.HIGH.getResourceValue());
            BufferedImage xhdpi = AssetSetStep.getImage(this.myImageMap, Density.XHIGH.getResourceValue());
            BufferedImage xxhdpi = AssetSetStep.getImage(this.myImageMap, Density.XXHIGH.getResourceValue());
            AssetSetStep.setIconOrClear(this.myMdpiPreview, mdpi);
            AssetSetStep.setIconOrClear(this.myHdpiPreview, hdpi);
            AssetSetStep.setIconOrClear(this.myXHdpiPreview, xhdpi);
            AssetSetStep.setIconOrClear(this.myXXHdpiPreview, xxhdpi);
        }
        this.myUpdateListener.update();
    }

    private static void setIconOrClear(@NotNull ImageComponent component, @Nullable BufferedImage image) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/AssetSetStep", "setIconOrClear"));
        }
        if (image == null) {
            component.setIcon(null);
        } else {
            component.setIcon(new ImageIcon(image));
        }
    }

    private void displayClipartDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        final JDialog dialog = new JDialog(window, Dialog.ModalityType.DOCUMENT_MODAL);
        FlowLayout layout = new FlowLayout();
        dialog.getRootPane().setLayout(layout);
        int count = 0;
        Iterator iter = GraphicGenerator.getClipartNames();
        while (iter.hasNext()) {
            final String name = (String)iter.next();
            try {
                JButton btn = new JButton();
                btn.setIcon(new ImageIcon(GraphicGenerator.getClipartIcon((String)name)));
                Dimension d = new Dimension(32, 32);
                btn.setMaximumSize(d);
                btn.setPreferredSize(d);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AssetSetStep.this.myTemplateState.put("clipartPath", name);
                        dialog.setVisible(false);
                        AssetSetStep.this.update();
                    }
                });
                dialog.getRootPane().add(btn);
                ++count;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        int size = (int)(Math.sqrt(count) + 1.0) * (32 + layout.getHgap()) + 20;
        dialog.setSize(size, size + 20);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    public void finalizeAssetType(AssetStudioAssetGenerator.AssetType type) {
        this.mySelectedAssetType = type;
        this.myTemplateState.put("assetType", type.name());
        for (int i = 0; i < this.myAssetTypeComboBox.getItemCount(); ++i) {
            if (!((ComboBoxItem)this.myAssetTypeComboBox.getItemAt((int)i)).id.equals(type.name())) continue;
            this.myAssetTypeComboBox.setSelectedIndex(i);
            break;
        }
        this.hide(this.myAssetTypeComboBox, this.myAssetTypeLabel);
        this.update();
    }

    @Nullable
    private static BufferedImage getImage(@NotNull Map<String, Map<String, BufferedImage>> map, @NotNull String name) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/wizard/AssetSetStep", "getImage"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/AssetSetStep", "getImage"));
        }
        Map<String, BufferedImage> images = map.get(name);
        if (images == null) {
            return null;
        }
        Collection<BufferedImage> values = images.values();
        return values.isEmpty() ? null : values.iterator().next();
    }

    @Nullable
    private static BufferedImage getImage(@NotNull Map<String, Map<String, BufferedImage>> map, @NotNull String category, @NotNull Density density) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/wizard/AssetSetStep", "getImage"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/wizard/AssetSetStep", "getImage"));
        }
        if (density == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "density", "com/android/tools/idea/wizard/AssetSetStep", "getImage"));
        }
        String densityString = density.getResourceValue();
        Map<String, BufferedImage> images = map.get(category);
        if (images == null) {
            return null;
        }
        for (String key : images.keySet()) {
            if (!key.contains(densityString)) continue;
            return images.get(key);
        }
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateStep() {
        super.updateStep();
        if (!this.myInitialized) {
            this.myInitialized = true;
            this.initialize();
        }
    }

    public String getHelpId() {
        return "Android-Gradle_Screen_Configuration_Page";
    }

    private void initialize() {
        this.myTemplateState.put("imagePath", new File(TemplateManager.getTemplateRootFolder(), FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule", "root", "res", "mipmap-xhdpi", "ic_launcher.png"})).getAbsolutePath());
        this.register("imagePath", this.myImageFile);
    }

    @NotNull
    private String computeResourceName() {
        String resourceName = null;
        if (this.myTemplateState.get("iconName") != null) {
            resourceName = this.myStringEvaluator.evaluate(this.myTemplateState.getString("iconName"), this.myTemplateState.getParameters());
        }
        if (resourceName == null) {
            resourceName = String.format(this.mySelectedAssetType.getDefaultNameFormat(), "name");
        }
        if (this.drawableExists(resourceName) && this.mySelectedAssetType != AssetStudioAssetGenerator.AssetType.LAUNCHER) {
            int i = 2;
            while (this.drawableExists(resourceName + Integer.toString(i))) {
                ++i;
            }
            resourceName = resourceName + Integer.toString(i);
        }
        String string = resourceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AssetSetStep", "computeResourceName"));
        }
        return string;
    }

    public void createAssets(@Nullable Module module) {
        File targetResDir = (File)this.myTemplateState.get("outputFolder");
        if (targetResDir == null) {
            if (this.myTemplateState.hasAttr("resDir")) {
                assert (module != null);
                File moduleDir = new File(module.getModuleFilePath()).getParentFile();
                targetResDir = new File(moduleDir, this.myTemplateState.getString("resDir"));
            } else {
                return;
            }
        }
        File targetVariantDir = targetResDir.getParentFile();
        this.myAssetGenerator.outputImagesIntoVariantRoot(targetVariantDir);
        VirtualFile resDir = LocalFileSystem.getInstance().findFileByIoFile(targetResDir);
        if (resDir != null) {
            resDir.refresh(true, true);
        } else if (this.myProject != null) {
            this.myProject.getBaseDir().refresh(true, true);
        }
    }

    private boolean drawableExists(String resourceName) {
        if (this.mySourceProvider != null) {
            return Parameter.existsResourceFile(this.mySourceProvider, this.myModule, ResourceFolderType.DRAWABLE, ResourceType.DRAWABLE, resourceName);
        }
        return Parameter.existsResourceFile(this.myModule, ResourceType.DRAWABLE, resourceName);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myImageRadioButton;
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AssetSetStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AssetSetStep", "getError"));
        }
        return jLabel;
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ImageComponent imageComponent;
        ImageComponent imageComponent2;
        ImageComponent imageComponent3;
        ImageComponent imageComponent4;
        JPanel jPanel;
        ImageComponent imageComponent5;
        ImageComponent imageComponent6;
        ImageComponent imageComponent7;
        ImageComponent imageComponent8;
        ImageComponent imageComponent9;
        ImageComponent imageComponent10;
        ImageComponent imageComponent11;
        ImageComponent imageComponent12;
        JPanel jPanel2;
        JTextField jTextField;
        JLabel jLabel;
        JLabel jLabel2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JSlider jSlider;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel6;
        JLabel jLabel7;
        JButton jButton;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JComboBox jComboBox3;
        JTextField jTextField2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel4;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JLabel jLabel11;
        JLabel jLabel12;
        JLabel jLabel13;
        JCheckBox jCheckBox;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(17, 5, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Foreground:");
        jPanel5.add((Component)jLabel14, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTrimBlankSpace = jCheckBox = new JCheckBox();
        jCheckBox.setText("Trim surrounding blank space");
        jPanel5.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myForegroundScalingLabel = jLabel13 = new JLabel();
        jLabel13.setText("Foreground scaling:");
        jPanel5.add((Component)jLabel13, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShapeLabel = jLabel12 = new JLabel();
        jLabel12.setText("Shape:");
        jPanel5.add((Component)jLabel12, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackgroundColorLabel = jLabel11 = new JLabel();
        jLabel11.setText("Background color:");
        jPanel5.add((Component)jLabel11, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 1, 1, 2, 8, 2, 3, 3, null, null, null));
        this.myImageRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("Image");
        jPanel6.add((Component)jRadioButton8, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myClipartRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Clipart");
        jPanel6.add((Component)jRadioButton7, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myTextRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Text");
        jPanel6.add((Component)jRadioButton6, new GridConstraints(0, 2, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myScalingPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(9, 1, 1, 2, 8, 2, 3, 3, null, null, null));
        this.myCropRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Crop");
        jPanel4.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCenterRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Center");
        jPanel4.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShapePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(10, 1, 1, 2, 8, 2, 3, 3, null, null, null));
        this.myCircleRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Circle");
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySquareRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Square");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNoneRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("None");
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myText = jTextField2 = new JTextField();
        jPanel5.add((Component)jTextField2, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFontFamily = jComboBox3 = new JComboBox();
        jPanel5.add(jComboBox3, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTextLabel = jLabel10 = new JLabel();
        jLabel10.setText("Text:");
        jPanel5.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFontFamilyLabel = jLabel9 = new JLabel();
        jLabel9.setText("Font:");
        jPanel5.add((Component)jLabel9, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundColorLabel = jLabel8 = new JLabel();
        jLabel8.setText("Foreground color:");
        jPanel5.add((Component)jLabel8, new GridConstraints(13, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myChooseClipart = jButton = new JButton();
        jButton.setText("Choose");
        jPanel5.add((Component)jButton, new GridConstraints(5, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myImageFileLabel = jLabel7 = new JLabel();
        jLabel7.setText("Image file:");
        jPanel5.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myChooseClipartLabel = jLabel6 = new JLabel();
        jLabel6.setText("Clipart:");
        jPanel5.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myBackgroundColor = colorPanel2 = new ColorPanel();
        jPanel5.add((Component)colorPanel2, new GridConstraints(12, 1, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myForegroundColor = colorPanel = new ColorPanel();
        jPanel5.add((Component)colorPanel, new GridConstraints(13, 1, 1, 2, 8, 0, 3, 3, null, null, null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("Additional padding:");
        jPanel5.add((Component)jLabel15, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(7, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPaddingSlider = jSlider = new JSlider();
        jSlider.setMaximum(100);
        jSlider.setValue(0);
        jSlider.setMinimum(0);
        jPanel7.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setEnabled(true);
        jPanel5.add((Component)jPanel8, new GridConstraints(16, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        this.myDescription = jLabel5 = new JLabel();
        jLabel5.setText("");
        ((Component)jLabel5).setVisible(false);
        jPanel8.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myError = jLabel4 = new JLabel();
        jLabel4.setText(" ");
        jLabel4.setVerticalTextPosition(3);
        jPanel8.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(15, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAssetTypeLabel = jLabel3 = new JLabel();
        jLabel3.setText("Asset Type:");
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAssetTypeComboBox = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel5.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myChooseThemeComboBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setVisible(true);
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel2);
        jPanel5.add(jComboBox, new GridConstraints(11, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myChooseThemeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Theme:");
        ((Component)jLabel2).setVisible(true);
        jPanel5.add((Component)jLabel2, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourceNameLabel = jLabel = new JLabel();
        jLabel.setText("Resource name:");
        jPanel5.add((Component)jLabel, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel5.add((Component)jTextField, new GridConstraints(14, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVersionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 4, 16, 1, 0, 3, 1, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 2, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("Older Versions");
        jPanel2.add((Component)jLabel16, new GridConstraints(1, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("API 11+");
        jPanel2.add((Component)jLabel17, new GridConstraints(3, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        this.myV9XHdpiPreview = imageComponent12 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent12), new GridConstraints(0, 2, 1, 1, 0, 0, 1, 1, new Dimension(32, 50), new Dimension(32, 50), null));
        this.myV9XXHdpiPreview = imageComponent11 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent11), new GridConstraints(0, 3, 1, 1, 0, 0, 3, 1, new Dimension(48, 75), new Dimension(48, 75), null));
        this.myV9MdpiPreview = imageComponent10 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent10), new GridConstraints(0, 0, 1, 1, 0, 0, 3, 1, new Dimension(16, 25), new Dimension(16, 25), null));
        this.myV9HdpiPreview = imageComponent9 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent9), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 1, new Dimension(24, 38), new Dimension(24, 38), null));
        this.myV11XHdpiPreview = imageComponent8 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent8), new GridConstraints(2, 2, 1, 1, 0, 0, 1, 3, new Dimension(48, 48), new Dimension(48, 48), null));
        this.myV11XXHdpiPreview = imageComponent7 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent7), new GridConstraints(2, 3, 1, 1, 0, 0, 3, 3, new Dimension(72, 72), new Dimension(72, 72), null));
        this.myV11MdpiPreview = imageComponent6 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent6), new GridConstraints(2, 0, 1, 1, 0, 0, 3, 3, new Dimension(24, 24), new Dimension(24, 24), null));
        this.myV11HdpiPreview = imageComponent5 = new ImageComponent();
        jPanel2.add((Component)((Object)imageComponent5), new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, new Dimension(36, 36), new Dimension(36, 36), null));
        this.myDpiPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 3, 16, 1, 0, 3, 1, 3, null, null, null));
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("MDPI");
        jPanel.add((Component)jLabel18, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("HDPI");
        jPanel.add((Component)jLabel19, new GridConstraints(3, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("XHDPI");
        jPanel.add((Component)jLabel20, new GridConstraints(5, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("XXHDPI");
        jPanel.add((Component)jLabel21, new GridConstraints(7, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myMdpiPreview = imageComponent4 = new ImageComponent();
        jPanel.add((Component)((Object)imageComponent4), new GridConstraints(0, 0, 1, 1, 0, 0, 1, 3, new Dimension(48, 48), new Dimension(48, 48), null));
        this.myHdpiPreview = imageComponent3 = new ImageComponent();
        jPanel.add((Component)((Object)imageComponent3), new GridConstraints(2, 0, 1, 1, 0, 0, 1, 3, new Dimension(72, 72), new Dimension(72, 72), null));
        this.myXHdpiPreview = imageComponent2 = new ImageComponent();
        jPanel.add((Component)((Object)imageComponent2), new GridConstraints(4, 0, 1, 1, 0, 0, 1, 3, new Dimension(96, 96), new Dimension(96, 96), null));
        this.myXXHdpiPreview = imageComponent = new ImageComponent();
        jPanel.add((Component)((Object)imageComponent), new GridConstraints(6, 0, 1, 1, 0, 0, 1, 3, new Dimension(144, 144), new Dimension(144, 144), null));
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Preview");
        jPanel5.add((Component)jLabel22, new GridConstraints(0, 3, 1, 2, 0, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

