/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.base.Predicate;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.ApplicationRunParameters;
import org.jetbrains.android.run.AvdComboBox;
import org.jetbrains.android.run.ConfigurationSpecificEditor;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private JPanel myPanel;
    private JComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private JCheckBox myWipeUserDataCheckBox;
    private JComboBox myNetworkSpeedCombo;
    private JComboBox myNetworkLatencyCombo;
    private JCheckBox myDisableBootAnimationCombo;
    private JCheckBox myClearLogCheckBox;
    private JBLabel myModuleJBLabel;
    private JRadioButton myShowChooserRadioButton;
    private JRadioButton myEmulatorRadioButton;
    private JRadioButton myUsbDeviceRadioButton;
    private LabeledComponent<AvdComboBox> myAvdComboComponent;
    private JBLabel myMinSdkInfoMessageLabel;
    private JBCheckBox myUseAdditionalCommandLineOptionsCheckBox;
    private RawCommandLineEditor myCommandLineField;
    private JCheckBox myShowLogcatCheckBox;
    private JCheckBox myFilterLogcatCheckBox;
    private JCheckBox myUseLastSelectedDeviceCheckBox;
    private AvdComboBox myAvdCombo;
    private String incorrectPreferredAvd;
    private JComponent anchor;
    @NonNls
    private static final String[] NETWORK_SPEEDS = new String[]{"Full", "GSM", "HSCSD", "GPRS", "EDGE", "UMTS", "HSPDA"};
    @NonNls
    private static final String[] NETWORK_LATENCIES = new String[]{"None", "GPRS", "EDGE", "UMTS"};
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;

    public void setConfigurationSpecificEditor(ConfigurationSpecificEditor<T> configurationSpecificEditor) {
        this.myConfigurationSpecificEditor = configurationSpecificEditor;
        this.myConfigurationSpecificPanel.add(configurationSpecificEditor.getComponent());
        this.setAnchor(this.myConfigurationSpecificEditor.getAnchor());
        this.myShowLogcatCheckBox.setVisible(configurationSpecificEditor instanceof ApplicationRunParameters);
        this.myFilterLogcatCheckBox.setVisible(configurationSpecificEditor instanceof ApplicationRunParameters);
    }

    public AndroidRunConfigurationEditor(Project project, final Predicate<AndroidFacet> libraryProjectValidator) {
        this.$$$setupUI$$$();
        this.myCommandLineField.setDialogCaption("Emulator Additional Command Line Options");
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModulesComboBox){

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) {
                    return false;
                }
                return !facet.isLibraryProject() || libraryProjectValidator.apply((Object)facet);
            }
        };
        this.myAvdComboComponent.setComponent((JComponent)((Object)new AvdComboBox(project, true, false){

            @Override
            public Module getModule() {
                return AndroidRunConfigurationEditor.this.getModuleSelector().getModule();
            }
        }));
        this.myAvdCombo = (AvdComboBox)((Object)this.myAvdComboComponent.getComponent());
        this.myAvdCombo.setMinimumSize(new Dimension(250, this.myAvdCombo.getMinimumSize().height));
        this.myAvdCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String warning = AndroidRunConfigurationEditor.this.myEmulatorRadioButton.isSelected() ? AndroidRunConfigurationEditor.this.getAvdCompatibilityWarning() : null;
                AndroidRunConfigurationEditor.this.resetAvdCompatibilityWarningLabel(warning);
            }
        });
        this.myMinSdkInfoMessageLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        this.myMinSdkInfoMessageLabel.setIcon(AllIcons.General.BalloonWarning);
        Disposer.register((Disposable)this, (Disposable)this.myAvdCombo);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean emulatorSelected = AndroidRunConfigurationEditor.this.myEmulatorRadioButton.isSelected();
                AndroidRunConfigurationEditor.this.myAvdComboComponent.setEnabled(emulatorSelected);
                String warning = emulatorSelected ? AndroidRunConfigurationEditor.this.getAvdCompatibilityWarning() : null;
                AndroidRunConfigurationEditor.this.resetAvdCompatibilityWarningLabel(warning);
            }
        };
        this.myModulesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidRunConfigurationEditor.this.myAvdCombo.startUpdatingAvds(ModalityState.current());
            }
        });
        this.myShowChooserRadioButton.addActionListener(listener);
        this.myEmulatorRadioButton.addActionListener(listener);
        this.myUsbDeviceRadioButton.addActionListener(listener);
        this.myUseLastSelectedDeviceCheckBox.addActionListener(listener);
        this.myNetworkSpeedCombo.setModel(new DefaultComboBoxModel<String>(NETWORK_SPEEDS));
        this.myNetworkLatencyCombo.setModel(new DefaultComboBoxModel<String>(NETWORK_LATENCIES));
        this.myUseAdditionalCommandLineOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidRunConfigurationEditor.this.myCommandLineField.setEnabled(AndroidRunConfigurationEditor.this.myUseAdditionalCommandLineOptionsCheckBox.isSelected());
            }
        });
    }

    private void resetAvdCompatibilityWarningLabel(@Nullable String warning) {
        if (warning != null) {
            this.myMinSdkInfoMessageLabel.setVisible(true);
            this.myMinSdkInfoMessageLabel.setText(warning);
        } else {
            this.myMinSdkInfoMessageLabel.setVisible(false);
        }
    }

    @Nullable
    private String getAvdCompatibilityWarning() {
        IdDisplay selectedItem = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedItem != null) {
            String selectedAvdName = selectedItem.getId();
            Module module = this.getModuleSelector().getModule();
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager == null) {
                return null;
            }
            AvdInfo avd = avdManager.getAvd(selectedAvdName, false);
            if (avd == null || avd.getTarget() == null) {
                return null;
            }
            AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            if (platform == null) {
                return null;
            }
            AndroidVersion minSdk = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
            LaunchCompatibility compatibility = LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), avd.getTarget());
            if (compatibility.isCompatible() == ThreeState.NO) {
                return String.format("'%1$s' may be incompatible with your configuration (%2$s)", selectedAvdName, StringUtil.notNullize((String)compatibility.getReason()));
            }
        }
        return null;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    private static boolean containsItem(JComboBox combo, @NotNull Object item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "containsItem"));
        }
        int n = combo.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!item.equals(combo.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    protected void resetEditorFrom(T configuration) {
        TargetSelectionMode targetSelectionMode;
        this.myModuleSelector.reset(configuration);
        final String avd = ((AndroidRunConfigurationBase)((Object)configuration)).PREFERRED_AVD;
        if (avd != null) {
            JComboBox combo = this.myAvdCombo.getComboBox();
            if (AndroidRunConfigurationEditor.containsItem(combo, avd)) {
                combo.setSelectedItem(avd);
            } else {
                combo.setRenderer(new ListCellRendererWrapper(){

                    public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                        if (value == null) {
                            this.setText("<html><font color='red'>" + avd + "</font></html>");
                        } else if (value instanceof IdDisplay) {
                            this.setText(((IdDisplay)value).getDisplay());
                        } else {
                            this.setText(value.toString());
                        }
                    }
                });
                combo.setSelectedItem(null);
                this.incorrectPreferredAvd = avd;
            }
        }
        this.myShowChooserRadioButton.setSelected((targetSelectionMode = ((AndroidRunConfigurationBase)((Object)configuration)).getTargetSelectionMode()) == TargetSelectionMode.SHOW_DIALOG);
        this.myEmulatorRadioButton.setSelected(targetSelectionMode == TargetSelectionMode.EMULATOR);
        this.myUsbDeviceRadioButton.setSelected(targetSelectionMode == TargetSelectionMode.USB_DEVICE);
        this.myUseLastSelectedDeviceCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).USE_LAST_SELECTED_DEVICE);
        this.myAvdComboComponent.setEnabled(targetSelectionMode == TargetSelectionMode.EMULATOR);
        this.resetAvdCompatibilityWarningLabel(targetSelectionMode == TargetSelectionMode.EMULATOR ? this.getAvdCompatibilityWarning() : null);
        this.myUseAdditionalCommandLineOptionsCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).USE_COMMAND_LINE);
        this.myCommandLineField.setText(((AndroidRunConfigurationBase)((Object)configuration)).COMMAND_LINE);
        this.myConfigurationSpecificEditor.resetFrom(configuration);
        this.myWipeUserDataCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).WIPE_USER_DATA);
        this.myDisableBootAnimationCombo.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).DISABLE_BOOT_ANIMATION);
        AndroidRunConfigurationEditor.selectItemCaseInsensitively(this.myNetworkSpeedCombo, ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_SPEED);
        AndroidRunConfigurationEditor.selectItemCaseInsensitively(this.myNetworkLatencyCombo, ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_LATENCY);
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).SHOW_LOGCAT_AUTOMATICALLY);
        this.myFilterLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).FILTER_LOGCAT_AUTOMATICALLY);
    }

    private static void selectItemCaseInsensitively(@NotNull JComboBox comboBox, @Nullable String item) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "selectItemCaseInsensitively"));
        }
        if (item == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = comboBox.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof String) || !item.equalsIgnoreCase((String)element)) continue;
            comboBox.setSelectedItem(element);
            return;
        }
    }

    protected void applyEditorTo(T configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo(configuration);
        if (this.myShowChooserRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.SHOW_DIALOG);
        } else if (this.myEmulatorRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.EMULATOR);
        } else if (this.myUsbDeviceRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.USB_DEVICE);
        }
        ((AndroidRunConfigurationBase)((Object)configuration)).USE_LAST_SELECTED_DEVICE = this.myUseLastSelectedDeviceCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).COMMAND_LINE = this.myCommandLineField.getText();
        ((AndroidRunConfigurationBase)((Object)configuration)).USE_COMMAND_LINE = this.myUseAdditionalCommandLineOptionsCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).PREFERRED_AVD = "";
        ((AndroidRunConfigurationBase)((Object)configuration)).WIPE_USER_DATA = this.myWipeUserDataCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).DISABLE_BOOT_ANIMATION = this.myDisableBootAnimationCombo.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_SPEED = ((String)this.myNetworkSpeedCombo.getSelectedItem()).toLowerCase();
        ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_LATENCY = ((String)this.myNetworkLatencyCombo.getSelectedItem()).toLowerCase();
        ((AndroidRunConfigurationBase)((Object)configuration)).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).FILTER_LOGCAT_AUTOMATICALLY = this.myFilterLogcatCheckBox.isSelected();
        if (this.myAvdComboComponent.isEnabled()) {
            JComboBox combo = this.myAvdCombo.getComboBox();
            IdDisplay preferredAvd = (IdDisplay)combo.getSelectedItem();
            ((AndroidRunConfigurationBase)((Object)configuration)).PREFERRED_AVD = preferredAvd == null ? (this.incorrectPreferredAvd != null ? this.incorrectPreferredAvd : "") : preferredAvd.getId();
        }
        this.myConfigurationSpecificEditor.applyTo(configuration);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        RawCommandLineEditor rawCommandLineEditor;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox6;
        JBLabel jBLabel;
        LabeledComponent labeledComponent;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JComboBox jComboBox3;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(46, 14), null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.general.tab.title"), null, jPanel3, null);
        this.myModuleJBLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Module:");
        jBLabel2.setDisplayedMnemonic('M');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesComboBox = jComboBox3 = new JComboBox();
        jPanel3.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigurationSpecificPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.title"), 0, 0, null, null));
        this.myEmulatorRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.emulator"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUsbDeviceRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.usb.device"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowChooserRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.show.dialog"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAvdComboComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.ComboboxWithBrowseButton");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setEnabled(true);
        labeledComponent.setText(ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.prefer.avd.label"));
        jPanel4.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null, 2));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMinSdkInfoMessageLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.min.sdk.info.message"));
        jPanel4.add((Component)jBLabel, new GridConstraints(5, 0, 1, 2, 8, 2, 0, 0, null, null, null, 2));
        this.myUseLastSelectedDeviceCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Use same device for future launches");
        jPanel4.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.emulator.tab.title"), null, jPanel5, null);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.network.spped.label"));
        jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNetworkSpeedCombo = jComboBox2 = new JComboBox();
        jPanel6.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.network.latency.label"));
        jPanel6.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNetworkLatencyCombo = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        this.myWipeUserDataCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.wipe.user.data.label"));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myDisableBootAnimationCombo = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.disable.boot.animation.label"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUseAdditionalCommandLineOptionsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Additional command line options:");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(11);
        jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommandLineField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel7.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.tab.title"), null, jPanel8, null);
        this.myClearLogCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.skip.content.label"));
        jPanel8.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel8.add((Component)spacer7, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShowLogcatCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show logcat automatically");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFilterLogcatCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Filter to only show output from this application");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox3);
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

